/*
 * This class provides the ability for an Info Panel, and possibly a bunch of
 * other panels, to be loaded at a later time than when the program is loaded.
 * This is specific to Info Panels, though if I find a need for something
 * similar at a future date, I may change it to be more generic.
 * For information of the use of the DelayInfo class, refer to the accompanying
 * documentation.
 */

#import <objc/Object.h>

@interface DelayInfo:Object
{
    id	infoPanel;
}

+ new;				// make sure that infoPanel is nil.
- setInfoPanel:anObject;	// set the infoPanel.
- infoPanel;			// return the infoPanel, or load it.
- info:sender;			// make the info panel be up there.

- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

@end
