/* File:	PrimeGenerator.h - Prime generator for 'PrimeSpiral'
 *
 * By:		Christopher Lane
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Date:	23 February 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.  This program
 *		may be distributed without restriction for non-commercial use.
 */

#import <objc/Object.h>

#define NUMELEMS ((size_t) 8192)

typedef struct { unsigned int prime, square; } ENTRY;

@interface PrimeGenerator:Object
{
	unsigned int number, index;
	size_t maximum;
	ENTRY *primes;
}

+ new;
- (unsigned int) generate;
- free;

@end
