/* File:	SpiralGenerator.m - Spiral generator for 'PrimeSpiral'
 *
 * By:		Christopher Lane
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Date:	24 February 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.  This program
 *		may be distributed without restriction for non-commercial use.
 */
 
#ifdef DEBUG
#import <stdio.h>
#endif
#import "SpiralGenerator.h"

@implementation SpiralGenerator

+ new
{
	self = [super new];
	
	count = 1;
	remain = 2;
	distance = 1;
	direction = RIGHT;
	
	return self;
}
	
- generate:(unsigned int) number :(NXPoint *) point
{
	int dx = 0, dy = 0;
	
	for(; count <= number; count++) {
		if(!--remain) {
			switch(direction) {
				case UP: distance++; direction = LEFT; break;
				case DOWN: distance++;
				default: direction--; break;
				}
			remain = distance;
			}
		switch(direction) {
			case LEFT: --dx; break;
			case RIGHT: ++dx; break;
			case UP: ++dy; break;
			case DOWN: --dy; break;
			}
		}
	point->x += (float) dx;
	point->y += (float) dy;
#ifdef DEBUG
	(void) printf("\t(%g, %g)\n", point->x, point->y);
#endif
	return self;
}

@end
