/* File:	SpiralView.m - View object for 'PrimeSpiral'
 *
 * By:		Christopher Lane
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Date:	26 February 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.  This program
 *		may be distributed without restriction for non-commercial use.
 */

#import "SpiralView.h"

#import <math.h>
#import <appkit/Cell.h>
#import <appkit/Cursor.h>
#import <dpsclient/psops.h>

#import "PrimeGenerator.h"
#import "SpiralGenerator.h"
#import "SpiralOps.h"

@implementation SpiralView

- spiral:sender
{
	NXPoint point;
	PrimeGenerator *prime = [PrimeGenerator new];
	SpiralGenerator *spiral = [SpiralGenerator new];
	
	point.x = (float) rint((double) (bounds.size.width / 2.0));
	point.y = (float) rint((double) (bounds.size.height / 2.0));
	
	[self lockFocus];
	
	PSclearToGray(NX_LTGRAY);
	
	while(point.x > bounds.origin.x || point.y > bounds.origin.y) {
		[spiral generate:[prime generate] :&point];
		PSdrawAt(point.x, point.y);
		}
		
	[self unlockFocus];
	
	[prime free];
	[spiral free];
	
	return self;
}

- setVersion:anObject
{
	[(version = anObject) setStringValue:VERSION];
	
	return self;
}

@end
