/*****************************************************************************/
/* PolyView.h								     */
/* interface file for PolyView class of RandPoly application		     */
/* Carl F. Sutter   September 1989					     */
/*****************************************************************************/
 
#import <appkit/View.h>
#import <appkit/Bitmap.h>
#import "Animator.h"

#define MAXCORNERS 20
#define FILL_FILL   0
#define FILL_EOFILL 1
#define BORDER_YES  0

@interface PolyView:View
   {
   // outlets
   id	cornersDisplay;			// Text object to show number of verticies
   id	alphaDisplay;			// Text object to show alpha value
   id	delayDisplay;			// Text object to show delay time
   
   // internal instance variables
   Animator	*timer;  		// Instance of Animator object
   Bitmap	*bmpPoly;		// bitmap to hold alpha image
   int		nNumCorners;		// number of verticies of polygons
   BOOL		bAlpha;			// whether to use compositing
   float	flAlpha;		// alpha value of polygons
   NXSize	minWindowSize;		// min win size so view !< 1x1
   BOOL		bDrawInIcon;		// whether to mess with icon too
   char		ops[MAXCORNERS+1];	// Array of PS operators for user path
   int		nFill;			// flag for fill type
   int		nBorder;		// flag for border or not
   }

// factory method
+ newFrame:(NXRect *)rect;

// window and application delegate messages
// delegate outlets for window and application to this view are set in the IB
- appDidInit:(id)sender;
- windowWillResize:sender toSize:(NXSize *)frameSize;
- windowDidResize:sender;

// outlet initialization methods
- setCornersDisplay:anObject;
- setAlphaDisplay:anObject;
- setDelayDisplay:anObject;

// actions
- setCorners:sender;
- setAlpha:sender;
- setDelay:sender;
- setBAlpha:sender;
- drawInTheIcon:sender;
- setFill:sender;
- setBorder:sender;

// internal methods
- drawPolygons:(id)sender;
- drawOnePolygon:(NXRect)nxrBounds;
- createOpsArray;

@end
