#include <stdio.h>
#include <nlist.h>
#include <machine/vm_types.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/dk.h>
#define	KERNEL
#include <sys/time.h>
#undef KERNEL
#include <sys/kernel.h>
#include <sys/vmmeter.h>
#include <sys/vmsystm.h>
#include <vm/vm_statistics.h>

#define	peek(index,value) \
   do {if (lseek(kmem, (index), L_SET) != (off_t) (index)) {fprintf(stderr, "vmstat: cannot seek in /dev/kmem\n"); exit(1);} \
       if (read(kmem, &(value), sizeof(value)) != sizeof(value)) {fprintf(stderr, "vmstat: cannot read from /dev/kmem\n"); exit(1);}} while (0)

struct nlist nl[] =
{
   {{"_avenrun"}, 0, 0, 0, 0},
#define	X_AVENRUN	0

   {{"_boottime"}, 0, 0, 0, 0},
#define	X_BOOTTIME	1

   {{"_cnt"}, 0, 0, 0, 0},
#define	X_CNT		2

   {{"_cp_time"}, 0, 0, 0, 0},
#define	X_CP_TIME	3

   {{"_deficit"}, 0, 0, 0, 0},
#define	X_DEFICIT	4

   {{"_dk_ndrive"}, 0, 0, 0, 0},
#define	X_DK_NDRIVE	5

   {{"_dk_time"}, 0, 0, 0, 0},
#define	X_DK_TIME	6

   {{"_dk_seek"}, 0, 0, 0, 0},
#define	X_DK_SEEK	7

   {{"_dk_xfer"}, 0, 0, 0, 0},
#define	X_DK_XFER	8

   {{"_dk_wds"}, 0, 0, 0, 0},
#define	X_DK_WDS	9

   {{"_dk_bps"}, 0, 0, 0, 0},
#define	X_DK_BPS	10

   {{"_domainname"}, 0, 0, 0, 0},
#define	X_DOMAINNAME	11

   {{"_domainnamelen"}, 0, 0, 0, 0},
#define	X_DOMAINNAMELEN	12

   {{"_forkstat"}, 0, 0, 0, 0},
#define	X_FORKSTAT	13

   {{"_freemem"}, 0, 0, 0, 0},
#define	X_FREEMEM	14

   {{"_hostname"}, 0, 0, 0, 0},
#define	X_HOSTNAME	15

   {{"_hostnamelen"}, 0, 0, 0, 0},
#define	X_HOSTNAMELEN	16

   {{"_hz"}, 0, 0, 0, 0},
#define	X_HZ		17

   {{"_ifnet"}, 0, 0, 0, 0},
#define	X_IFNET		18

   {{"_mach_factor"}, 0, 0, 0, 0},
#define	X_MACH_FACTOR	19

   {{"_mem_size"}, 0, 0, 0, 0},
#define	X_MEM_SIZE	20

   {{"_nproc"}, 0, 0, 0, 0},
#define X_NPROC		21

   {{"_rate"}, 0, 0, 0, 0},
#define	X_RATE		22

   {{"_sum"}, 0, 0, 0, 0},
#define	X_SUM		23

   {{"_total"}, 0, 0, 0, 0},
#define	X_TOTAL		24

   {{"_vm_stat"}, 0, 0, 0, 0},
#define	X_VM_STAT	25

   {{""}, 0, 0, 0, 0}
};

main()
{
   int			kmem;
   int			i;
   char			line[128];
   struct ifnet		ifnet;

   char			hostname[MAXHOSTNAMELEN];
   int			hostnamelen;
   char			domainname[32];
   int			domainnamelen;
   struct timeval	boottime;
   int			hz;
   long			avenrun[3];
   int			nproc;
   long			mach_factor[3];
   long			cp_time[CPUSTATES];
   struct vmmeter	cnt;
   struct vmmeter	rate;
   struct vmmeter	sum;
   struct vmtotal	total;
   struct forkstat	forkstat;
   vm_size_t		mem_size;
   int			freemem;
   int			deficit;
   struct vm_statistics vm_stat;
   int			dk_ndrive;
   long			dk_time[DK_NDRIVE];
   long			dk_seek[DK_NDRIVE];
   long			dk_xfer[DK_NDRIVE];
   long			dk_wds[DK_NDRIVE];
   long			dk_bps[DK_NDRIVE];
   struct ifnet	       *ifnetp;

   if (nlist("/vmunix", nl))
   {
      fprintf(stderr, "vmstat: cannot nlist /vmunix\n");
      exit(1);
   }

   for (i = 0; *nl[i].n_un.n_name; i++)
      printf("nlist entry {%s, 0x%x, 0x%x, %d, 0x%x}\n", nl[i].n_un.n_name,
	 nl[i].n_type, nl[i].n_sect, nl[i].n_desc, nl[i].n_value);
   printf("\n");

   if ((kmem = open("/dev/kmem", O_RDONLY)) < 0)
   {
      fprintf(stderr, "vmstat: cannot open /dev/kmem\n");
      exit(1);
   }

   peek(nl[X_HOSTNAME].n_value, hostname);
   peek(nl[X_HOSTNAMELEN].n_value, hostnamelen);
   peek(nl[X_DOMAINNAME].n_value, domainname);
   peek(nl[X_DOMAINNAMELEN].n_value, domainnamelen);

   peek(nl[X_BOOTTIME].n_value, boottime);

   peek(nl[X_HZ].n_value, hz);

   peek(nl[X_AVENRUN].n_value, avenrun);
   peek(nl[X_NPROC].n_value, nproc);
   peek(nl[X_MACH_FACTOR].n_value, mach_factor);

   peek(nl[X_CP_TIME].n_value, cp_time);

   peek(nl[X_CNT].n_value, cnt);
   peek(nl[X_RATE].n_value, rate);
   peek(nl[X_SUM].n_value, sum);

   peek(nl[X_TOTAL].n_value, total);

   peek(nl[X_FORKSTAT].n_value, forkstat);

   peek(nl[X_MEM_SIZE].n_value, mem_size);
   peek(nl[X_FREEMEM].n_value, freemem);
   peek(nl[X_DEFICIT].n_value, deficit);
   peek(nl[X_VM_STAT].n_value, vm_stat);

   peek(nl[X_DK_NDRIVE].n_value, dk_ndrive);
   peek(nl[X_DK_TIME].n_value, dk_time);
   peek(nl[X_DK_SEEK].n_value, dk_seek);
   peek(nl[X_DK_XFER].n_value, dk_xfer);
   peek(nl[X_DK_WDS].n_value, dk_wds);
   peek(nl[X_DK_BPS].n_value, dk_bps);

   peek(nl[X_IFNET].n_value, ifnetp);

   printf("hostname \"%.*s\", domainname \"%.*s\"\n", hostnamelen, hostname, domainnamelen, domainname);
   printf("values returned by struct timeval boottime\n");
      printf("   %ld   %ld   %s", boottime.tv_sec, boottime.tv_usec, ctime(&boottime.tv_sec));
   printf("value returned by int hz\n");
      printf("   %d\n", hz);
   printf("values returned by long avenrun[3]\n");
      printf("   %ld   %ld   %ld\n", avenrun[0], avenrun[1], avenrun[2]);
   printf("value returned by int nproc\n");
      printf("   %d\n", nproc);
   printf("values returned by long mach_factor[3]\n");
      printf("   %ld   %ld   %ld\n", mach_factor[0], mach_factor[1], mach_factor[2]);
   printf("values returned by long cp_time[%d]\n", CPUSTATES);
      for (i = 0; i < CPUSTATES; i++)
	 printf("   %ld", cp_time[i]);
      printf("\n");
   printf("values returned by struct vmmeter cnt\n");
      printf("   context switches %u\n", cnt.v_swtch);
      printf("   calls to trap %u\n", cnt.v_trap);
      printf("   calls to syscall() %u\n", cnt.v_syscall);
      printf("   device interrupts %u\n", cnt.v_intr);
      printf("   software interrupts %u\n", cnt.v_soft);
      printf("   pseudo-dma interrupts %u\n", cnt.v_pdma);
      printf("   pages swapped in %u\n", cnt.v_pswpin);
      printf("   pages swapped out %u\n", cnt.v_pswpout);
      printf("   pageins %u\n", cnt.v_pgin);
      printf("   pageouts %u\n", cnt.v_pgout);
      printf("   pages paged in %u\n", cnt.v_pgpgin);
      printf("   pages paged out %u\n", cnt.v_pgpgout);
      printf("   intransit blocking page faults %u\n", cnt.v_intrans);
      printf("   total page reclaims %u\n", cnt.v_pgrec);
      printf("   found in free list rather than on swapdev %u\n", cnt.v_xsfrec);
      printf("   found in free list rather than in filsys %u\n", cnt.v_xifrec);
      printf("   pages filled on demand from executables %u\n", cnt.v_exfod);
      printf("   pages zero filled on demand %u\n", cnt.v_zfod);
      printf("   fills of pages mapped by vread() %u\n", cnt.v_vrfod);
      printf("   number of exfod's created %u\n", cnt.v_nexfod);
      printf("   number of zfod's created %u\n", cnt.v_nzfod);
      printf("   number of vrfod's created %u\n", cnt.v_nvrfod);
      printf("   page reclaims from free list %u\n", cnt.v_pgfrec);
      printf("   total faults taken %u\n", cnt.v_faults);
      printf("   scans in page out daemon %u\n", cnt.v_scan);
      printf("   revolutions of the hand %u\n", cnt.v_rev);
      printf("   pages taken from sequential programs %u\n", cnt.v_seqfree);
      printf("   pages freed by daemon %u\n", cnt.v_dfree);
      printf("   fast reclaims in locore %u\n", cnt.v_fastpgrec);
      printf("   swapins %u\n", cnt.v_swpin);
      printf("   swapouts %u\n", cnt.v_swpout);
   printf("values returned by struct vmmeter rate\n");
      printf("   context switches %u\n", rate.v_swtch);
      printf("   calls to trap %u\n", rate.v_trap);
      printf("   calls to syscall() %u\n", rate.v_syscall);
      printf("   device interrupts %u\n", rate.v_intr);
      printf("   software interrupts %u\n", rate.v_soft);
      printf("   pseudo-dma interrupts %u\n", rate.v_pdma);
      printf("   pages swapped in %u\n", rate.v_pswpin);
      printf("   pages swapped out %u\n", rate.v_pswpout);
      printf("   pageins %u\n", rate.v_pgin);
      printf("   pageouts %u\n", rate.v_pgout);
      printf("   pages paged in %u\n", rate.v_pgpgin);
      printf("   pages paged out %u\n", rate.v_pgpgout);
      printf("   intransit blocking page faults %u\n", rate.v_intrans);
      printf("   total page reclaims %u\n", rate.v_pgrec);
      printf("   found in free list rather than on swapdev %u\n", rate.v_xsfrec);
      printf("   found in free list rather than in filsys %u\n", rate.v_xifrec);
      printf("   pages filled on demand from executables %u\n", rate.v_exfod);
      printf("   pages zero filled on demand %u\n", rate.v_zfod);
      printf("   fills of pages mapped by vread() %u\n", rate.v_vrfod);
      printf("   number of exfod's created %u\n", rate.v_nexfod);
      printf("   number of zfod's created %u\n", rate.v_nzfod);
      printf("   number of vrfod's created %u\n", rate.v_nvrfod);
      printf("   page reclaims from free list %u\n", rate.v_pgfrec);
      printf("   total faults taken %u\n", rate.v_faults);
      printf("   scans in page out daemon %u\n", rate.v_scan);
      printf("   revolutions of the hand %u\n", rate.v_rev);
      printf("   pages taken from sequential programs %u\n", rate.v_seqfree);
      printf("   pages freed by daemon %u\n", rate.v_dfree);
      printf("   fast reclaims in locore %u\n", rate.v_fastpgrec);
      printf("   swapins %u\n", rate.v_swpin);
      printf("   swapouts %u\n", rate.v_swpout);
   printf("values returned by struct vmmeter sum\n");
      printf("   context switches %u\n", sum.v_swtch);
      printf("   calls to trap %u\n", sum.v_trap);
      printf("   calls to syscall() %u\n", sum.v_syscall);
      printf("   device interrupts %u\n", sum.v_intr);
      printf("   software interrupts %u\n", sum.v_soft);
      printf("   pseudo-dma interrupts %u\n", sum.v_pdma);
      printf("   pages swapped in %u\n", sum.v_pswpin);
      printf("   pages swapped out %u\n", sum.v_pswpout);
      printf("   pageins %u\n", sum.v_pgin);
      printf("   pageouts %u\n", sum.v_pgout);
      printf("   pages paged in %u\n", sum.v_pgpgin);
      printf("   pages paged out %u\n", sum.v_pgpgout);
      printf("   intransit blocking page faults %u\n", sum.v_intrans);
      printf("   total page reclaims %u\n", sum.v_pgrec);
      printf("   found in free list rather than on swapdev %u\n", sum.v_xsfrec);
      printf("   found in free list rather than in filsys %u\n", sum.v_xifrec);
      printf("   pages filled on demand from executables %u\n", sum.v_exfod);
      printf("   pages zero filled on demand %u\n", sum.v_zfod);
      printf("   fills of pages mapped by vread() %u\n", sum.v_vrfod);
      printf("   number of exfod's created %u\n", sum.v_nexfod);
      printf("   number of zfod's created %u\n", sum.v_nzfod);
      printf("   number of vrfod's created %u\n", sum.v_nvrfod);
      printf("   page reclaims from free list %u\n", sum.v_pgfrec);
      printf("   total faults taken %u\n", sum.v_faults);
      printf("   scans in page out daemon %u\n", sum.v_scan);
      printf("   revolutions of the hand %u\n", sum.v_rev);
      printf("   pages taken from sequential programs %u\n", sum.v_seqfree);
      printf("   pages freed by daemon %u\n", sum.v_dfree);
      printf("   fast reclaims in locore %u\n", sum.v_fastpgrec);
      printf("   swapins %u\n", sum.v_swpin);
      printf("   swapouts %u\n", sum.v_swpout);
   printf("values returned by struct vmtotal total\n");
      printf("   length of the run queue %d\n", total.t_rq);
      printf("   jobs in ``disk wait'' (neg priority) %d\n", total.t_dw);
      printf("   jobs in page wait %d\n", total.t_pw);
      printf("   jobs sleeping in core %d\n", total.t_sl);
      printf("   swapped out runnable/short block jobs %d\n", total.t_sw);
      printf("   total virtual memory %ld\n", total.t_vm);
      printf("   active virtual memory %ld\n", total.t_avm);
      printf("   total real memory in use %ld\n", total.t_rm);
      printf("   active real memory %ld\n", total.t_arm);
      printf("   virtual memory used by text %ld\n", total.t_vmtxt);
      printf("   active virtual memory used by text %ld\n", total.t_avmtxt);
      printf("   real memory used by text %ld\n", total.t_rmtxt);
      printf("   active real memory used by text %ld\n", total.t_armtxt);
      printf("   free memory pages %ld\n", total.t_free);
   printf("values returned by struct forkstat forkstat\n");
      printf("   number of forks %d\n", forkstat.cntfork);
      printf("   number of vforks %d\n", forkstat.cntvfork);
      printf("   size of forks %d\n", forkstat.sizfork);
      printf("   size of vforks %d\n", forkstat.sizvfork);
   printf("value returned by vm_size_t mem_size\n");
      printf("   %u\n", mem_size);
   printf("value returned by int freemem\n");
      printf("   %d\n", freemem);
   printf("value returned by int deficit\n");
      printf("   %d\n", deficit);
   printf("values returned by struct vm_statistics vm_stat\n");
      printf("   page size in bytes %ld\n", vm_stat.pagesize);
      printf("   number of pages free %ld\n", vm_stat.free_count);
      printf("   number of pages active %ld\n", vm_stat.active_count);
      printf("   number of pages inactive %ld\n", vm_stat.inactive_count);
      printf("   number of pages wired down %ld\n", vm_stat.wire_count);
      printf("   number of zero fill pages %ld\n", vm_stat.zero_fill_count);
      printf("   number of pages reactivated %ld\n", vm_stat.reactivations);
      printf("   number of pageins %ld\n", vm_stat.pageins);
      printf("   number of pageouts %ld\n", vm_stat.pageouts);
      printf("   number of page faults %ld\n", vm_stat.faults);
      printf("   number of copy-on-write faults %ld\n", vm_stat.cow_faults);
      printf("   number of object cache lookups %ld\n", vm_stat.lookups);
      printf("   number of object cache hits %ld\n", vm_stat.hits);
   printf("values returned by long dk_time[%d]\n", dk_ndrive);
      for (i = 0; i < dk_ndrive; i++)
	 printf("   %ld", dk_time[i]);
      printf("\n");
   printf("values returned by long dk_seek[%d]\n", dk_ndrive);
      for (i = 0; i < dk_ndrive; i++)
	 printf("   %ld", dk_seek[i]);
      printf("\n");
   printf("values returned by long dk_xfer[%d]\n", dk_ndrive);
      for (i = 0; i < dk_ndrive; i++)
	 printf("   %ld", dk_xfer[i]);
      printf("\n");
   printf("values returned by long dk_wds[%d]\n", dk_ndrive);
      for (i = 0; i < dk_ndrive; i++)
	 printf("   %ld", dk_wds[i]);
      printf("\n");
   printf("values returned by long dk_bps[%d]\n", dk_ndrive);
      for (i = 0; i < dk_ndrive; i++)
	 printf("   %ld", dk_bps[i]);
      printf("\n");
   printf("values returned by struct ifnet *ifnet\n");
      for (i = 1; ifnetp; ifnetp = ifnet.if_next, i++)
      {
	 peek(ifnetp, ifnet);
	 peek(ifnet.if_name, line);
	 printf("   name \"%s\"\n", line);
	 printf("   sub-unit for lower level driver %d\n", ifnet.if_unit);
	 printf("   maximum transmission unit %d\n", ifnet.if_mtu);
	 printf("   flags 0x%x\n", ifnet.if_flags);
	 printf("   time until watchdog called %d\n", ifnet.if_timer);
	 printf("   routing metric %d\n", ifnet.if_metric);
	 printf("   packets received on interface %d\n", ifnet.if_ipackets);
	 printf("   input errors on interface %d\n", ifnet.if_ierrors);
	 printf("   packets sent on interface %d\n", ifnet.if_opackets);
	 printf("   output errors on interface %d\n", ifnet.if_oerrors);
	 printf("   collisions on interface %d\n", ifnet.if_collisions);
      }

   close(kmem);
   exit(0);
}
