/*---------------------------------------------------------------------------
LoadServer.c -- Supply load information to remote clients.

This server routine supplies load information to remote clients.  It was
written on an Encore Multimax system running UMAX 4.3 BSD.  The need for this
program is due to the lack of RPC support on the Encore.  This dedicated
server supplies load information to remote NeXT clients running the NLoad
program.  Systems that have Sun's RPC support do not need to run this
dedicated server since the NeXT NLoad program supports RPC too.

This implementation is based on a UDP connectionless socket.  Loss of a
packet here and there is of little concern.  This style of implementation
results in minimal network traffic.

LoadServer sits patiently on a socket until a remote host sends a tickler
packet.  It then returns a UDP packet containing the following string:

                 "serverHostname load1 load5 load15 scale"

Rex Pruess <rpruess@umaxc.weeg.uiowa.edu>
-----------------------------------------------------------------------------*/
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>

#define FAILURE -1
#define QUEUES 3
#define	UDPSERVERPORT 5500	/* Client must agree with this too! */

int loadave (char * buf);

main(argc, argv)
int argc;
char *argv[];
{
   char	buf[BUFSIZ];
   int clientLength;
   long vector[QUEUES];
   int i;
   int n;
   int scale;
   int sockfd;
   char temp[16];

   struct sockaddr_in serverAddr;
   struct sockaddr clientAddr;
	
   /* 
    * Open a UDP socket (an Internet datagram socket).
    */
   if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
      errExit (argv[0], "Can not open datagram socket.");

   /*
    * Bind our local address so that the client can send to us.
    */
   bzero((char *) &serverAddr, sizeof(serverAddr));
   serverAddr.sin_family = AF_INET;
   serverAddr.sin_addr.s_addr = htonl(INADDR_ANY);
   serverAddr.sin_port = htons(UDPSERVERPORT);

   if (bind(sockfd, (struct sockaddr *) &serverAddr, sizeof(serverAddr)) < 0)
      errExit(argv[0], "Can not bind local address");

   /*
    * Sit in this infinite loop waiting for a remote client to send a
    * tickler packet.  Then, collect the load averages and return a packet
    * to the client.
    */
   while (1)
   {
      clientLength = sizeof (clientAddr);
      n = recvfrom(sockfd, buf, BUFSIZ, 0, (struct sockaddr *) &clientAddr, &clientLength);

      gethostname (buf, BUFSIZ - 2);
      buf[BUFSIZ - 1] = '\0';
		
      if (loadave (buf + strlen(buf)) == FAILURE) {
	 fprintf (stderr, "%s: loadave subroutine failure.  Execution continues.\n", argv[0]);
	 continue;
      }
	  
      n = strlen(buf) + 1;
      if (sendto(sockfd, buf, n, 0, (struct sockaddr *) &clientAddr, clientLength) != n)
	 fprintf (stderr, "%s: sento error.  Execution continues.\n", argv[0]);
   }

   /* This line is never reached. */
}

errExit (char *progName, char *errMsg)
{
   fprintf(stderr, "%s: %s\n", progName, errMsg);
   exit(1);
}


/*---------------------------------------------------------------------------
The code to calculate load averages is unique to each vendor.  On 4.3 BSD
systems, refer to the source code for the "w" command.  The "w.c" source code
is copyrighted by the Regents of the University of California.  Encore
Computer Corporation has further copyrighted its version of "w.c".  Due to
these copyrights, the code to calculate the load values is not included.
-----------------------------------------------------------------------------*/
int loadave (char * buf) {
   int sumA, sumB, sumC, scale;

   /*
    * Replace with code to calculate the load averages for your host.
    */

   sprintf(buf, " %d %d %d %d\n", sumA, sumB, sumC, scale);
   return 0;
}

