#include <stdio.h>

#define REPORT "report"
#define OVER "over"
#define LOW "low"
#define LOG "log"
#define MAIL "mail"
#define LOWMIN 90

FILE *log;
int domail;

main(argc,argv)
int argc;
char *argv[];
{
	FILE *fopen(), *rfp, *ofp, *lfp;
	char user[20];
	float quota, usage, pcnt;
	int ip, i;

	domail = 1;
	for (i = 1; i < argc; i++) {
		if (!strcmp(argv[i],"-m")) domail = 0;
	}

	log = fopen(LOG,"a");
	if (log == NULL) {
		fprintf(stderr,"%s: can't open log file: %s\n",argv[0],LOG);
		exit(1);
	}

	rfp = fopen(REPORT,"r");
	if (rfp == NULL) {
		fprintf(log,"can't open quota report file: %s\n",REPORT);
		exit(1);
	}

	ofp = fopen(OVER,"w");
	if (ofp == NULL) {
		fprintf(log,"can't open quota over file: %s\n",OVER);
		exit(1);
	}

	lfp = fopen(LOW,"w");
	if (lfp == NULL) {
		fprintf(log,"can't open quota low file: %s\n",LOW);
		exit(1);
	}

	while (fscanf(rfp,"%s %f %f",user,&quota,&usage) > 0) {
		pcnt = usage / quota * 100.0;
		ip = pcnt;
		if (ip > 100) {
			fprintf(ofp,"%s %g %g %d%%\n",user,quota,usage,ip);
			OverQuota(user,quota,usage);
		}
			
		if (ip >= LOWMIN && ip <= 100) {
			fprintf(lfp,"%s %g %g %d%%\n",user,quota,usage,ip);
			LowQuota(user,quota,usage);
		}
	}

	fclose(rfp);
	fclose(ofp);
	fclose(lfp);
	fclose(log);

	exit(0);
}

OverQuota(user,quota,usage)
char *user;
float quota, usage;
{
	FILE *fopen(), *mfp;
	char str[64];

	mfp = fopen(MAIL,"w");
	if (mfp == NULL) {
		fprintf(log,"can't write mail file: %s\n",MAIL);
		exit(1);
	}

	fprintf(mfp,"Warning!  Your disk usage is %g Kbytes, which exceeds\n",usage);
	fprintf(mfp,"your quota of %g Kbytes.  Please reduce your usage\n",quota);
	fprintf(mfp,"by removing unnecessary files.  If your usage continues\n");
	fprintf(mfp,"to exceed your quota, your account may be disabled.\n");
	fprintf(mfp,"\n");
	fprintf(mfp,"Note! If you drop files into the Recycler, you should\n");
	fprintf(mfp,"select the \"Empty Recycler\" item from the Workspace\n");
	fprintf(mfp,"\"File\" menu to actually get rid of them.\n");
	fprintf(mfp,"\n");
	fprintf(mfp,"---\n");
	fprintf(mfp,"The Accounting System\n");
	fclose(mfp);

	sprintf(str,"mail -s \"Disk usage\" %s < %s",user,MAIL);
	if (domail) system(str);

	return(0);
}

LowQuota(user,quota,usage)
char *user;
float quota, usage;
{
	FILE *fopen(), *mfp;
	char str[64];

	mfp = fopen(MAIL,"w");
	if (mfp == NULL) {
		fprintf(log,"can't write mail file: %s\n",MAIL);
		exit(1);
	}

	fprintf(mfp,"Warning!  Your disk usage is %g Kbytes, which is close to\n",usage);
	fprintf(mfp,"your quota of %g Kbytes.  Consider reducing your usage\n",quota);
	fprintf(mfp,"by removing unnecessary files.\n");
	fprintf(mfp,"\n");
	fprintf(mfp,"Note! If you drop files into the Recycler, you should\n");
	fprintf(mfp,"select the \"Empty Recycler\" item from the Workspace\n");
	fprintf(mfp,"\"File\" menu to actually get rid of them.\n");
	fprintf(mfp,"\n");
	fprintf(mfp,"---\n");
	fprintf(mfp,"The Accounting System\n");
	fclose(mfp);

	sprintf(str,"mail -s \"Disk usage\" %s < %s",user,MAIL);
	if (domail) system(str);

	return(0);
}
