#include <netinfo/ni.h>
#include <stdio.h>
#include "quota.h"

main(argc,argv)
int argc;
char *argv[];
{
	ni_status rc, ni_printdir();
	void *myhandle;
	ni_namelist mynamelist;
	ni_proplist  myproplist;
	ni_property myproperty;
	ni_entrylist myentrylist;
	ni_id myid;
	ni_index myindex;
	char str[256], user[16], domain[16], prop[16], val[16], *getpass();
	int i, j, q;
	int propp, domainp, valp;

	propp = 0;
	valp = 0;
	domainp = 0;
	
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') switch(argv[i][1]) {
			case 'd': strcpy(domain,argv[++i]); domainp = 1; break;
			case 'p': strcpy(prop,argv[++i]); propp = 1; break;
			case 'v': strcpy(val,argv[++i]); valp = 1; break;
			default: usage(argv[0]);
		}
		else {
			if (propp == 0) {
				strcpy(prop,argv[i]);
				propp = 1;
			}
			else {
				strcpy(val,argv[i]);
				valp = 1;
			}
		}
	}
	
	if (domainp == 0) strcpy(domain,DEFAULTDOMAIN);
	if (propp == 0) usage(argv[0]);
	if (valp == 0) usage(argv[0]);

	/* open netinfo */
	rc = ni_open(NULL, domain, &myhandle);
	if (rc) errexit("ni_open",rc);
	
	if (getuid() != 0) {
		rc = ni_setpassword(myhandle,getpass("Password: "));
		if (rc) errexit("ni_setpassword",rc);
		rc = ni_setuser(myhandle,"root");
		if (rc) errexit("ni_setuser",rc);
	}
	
	rc = ni_pathsearch(myhandle, &myid, "/users");
	if (rc) errexit("ni_pathsearch",rc);

	rc = ni_list(myhandle,&myid,"name",&myentrylist);
        if (rc) errexit("ni_list",rc);

        for (i = 0; i < myentrylist.ni_entrylist_len; i++) {
                strcpy(user,myentrylist.ni_entrylist_val[i].names->ni_namelist_val[0]);
                sprintf(str,"/users/%s",user);
		rc = ni_pathsearch(myhandle, &myid, str);
		if (rc) errexit("ni_pathsearch",rc);
	
		rc = ni_lookupprop(myhandle,&myid,prop,&mynamelist);
	
		if (rc == NI_NOPROP) {
			printf("creating new %s property for %s\n",prop,user);
			myindex = NI_INDEX_NULL;
			myproperty.nip_name = malloc(strlen(prop) + 1);
			strcpy(myproperty.nip_name,prop);
			myproperty.nip_val.ni_namelist_len = 1;
			myproperty.nip_val.ni_namelist_val = malloc(sizeof(char *));
			myproperty.nip_val.ni_namelist_val[0] = malloc(QSIZE);
			strcpy(myproperty.nip_val.ni_namelist_val[0],val);
			rc = ni_createprop(myhandle,&myid,myproperty,myindex);
			if (rc) errexit("ni_createprop",rc);
		}
		else {
			rc = ni_read(myhandle,&myid,&myproplist);
			if (rc) errexit("ni_read",rc);
			myindex = ni_proplist_match(myproplist,prop,NULL);
			mynamelist.ni_namelist_len = 1;
			mynamelist.ni_namelist_val = malloc(sizeof(char *));
			mynamelist.ni_namelist_val[0] = malloc(QSIZE);
			strcpy(mynamelist.ni_namelist_val[0],val);
			rc = ni_writeprop(myhandle,&myid,myindex,mynamelist);
			if (rc) errexit("ni_writeprop",rc);
		}
	}
	ni_free(myhandle);
	exit(0);
}


errexit(s,rc)
char *s;
ni_status rc;
{
	fprintf(stderr,"%s: %s\n",s,ni_error(rc));
	exit(1);
}

usage(n)
char *n;
{
	fprintf(stderr,"usage: %s prop val\n",n);
	exit(1);
}
		
