// Inquirer.m
// SCSI Bus Inquirer  - NeXTStep 
//
// Copyright (C) 1990 by Jiro Nakamura and Canon Inc.
// Copyright (C) 1991 by Jiro Nakamura.
// All Rights Reserved.
//
// RCS Information
// Revision Number->	$Revision: 1.4 $
// Last Revised->	$Date: 91/04/24 16:34:30 $
//
// HISTORY
// ---------
//	Apr-24-91	Jiro (jiro@shaman.com)
//		Revised for version 1.4
//	Aug- 8-90	Jiro
//		Revised to read disk capacity
//	Jul-13-90	Jiro
//		Revised to handle new versions of SCSI. Improved and cleaned up.
//	Jun-11-90	Jiro Nakamura
//		Created.
//

static char rcsid[]="$Id: Inquirer.m,v 1.4 91/04/24 16:34:30 jiro Exp Locker: jiro $";

#import "Inquirer.h"
#import "SCSI.h"
#import <strings.h>
#import <appkit/TextField.h>
#import <appkit/Matrix.h>
#import <appkit/Button.h>
#import <appkit/ButtonCell.h>
#import <appkit/Panel.h>		// For NX Run alert panel
#import <sys/types.h>
#import <libc.h>			// For geteuid()

#define DEVTYPE_SCANNER		0x06		/* Someone forgot this */
#define DEVTYPE_STILLVIDEO   	0x9f		/* Still video drive */
	
@implementation Inquirer

- update
{
	if( geteuid() != 0)	// If we are not effectively root
		if( NXRunAlertPanel("Not running as Root", 
			"This program must be run SET-UID root "
			"in order to access all SCSI devices.", 
			"Continue", "Quit", NULL) == 0)
			exit(1);
		
	return [self inquireAll: self];
}


- inquireAll:sender
{
	int target;
	
	for( target = 0; target < 7; target ++)
		[self inquireTarget: target];
	return self;
}

- inquireTarget: (int) target
{
	id 	titles[8] = {Title0, Title1, Title2, Title3, Title4,  
			Title5, Title6, Title7};
	SCSI	*scsi;
	struct inquiry_reply ibuffer;
	static char vendorBuffer[50], typeBuffer[20];
	static char tiffBuffer[25];
	
	scsi  = [SCSI new];
	[scsi openSCSI];
	

	if( [scsi setTarget: target lun: 0] == 0 )
		{
			
		
		if(  [scsi inquirySCSI: &ibuffer] == 0)
			{
			#ifdef DEBUG
				fprintf(stderr, 
					"Target = %d   Lun = %d\n"
					"Device type  = 0x%x\n"
					"ANSI Version Number     = %d\n"
					"Additional List Length  = %d\n"
					"Vendor ID    = <%.8s>\n" 
					"Product ID   = <%.16s>\n"
					"Revision     = <%.4s>\n"
					"-----------------------\n", 
					target, 0, 
					ibuffer.ir_devicetype, 
					ibuffer.ir_ansiversion,
					ibuffer.ir_addlistlen,
					ibuffer.ir_vendorid, 	
					ibuffer.ir_productid, 
					ibuffer.ir_revision);
			#endif
			
			sprintf(vendorBuffer,"%.8s\n%.16s", 
				ibuffer.ir_vendorid, 
				ibuffer.ir_productid);
			
			switch( ibuffer.ir_devicetype )
				{
				
				case DEVTYPE_DISK:
					if( ibuffer.ir_removable == YES)
						sprintf( typeBuffer, 
							"Removable-Disk");
					else
						sprintf( typeBuffer, 
							"Hard-Drive");
					
					break;
				case DEVTYPE_TAPE:														
					sprintf( typeBuffer, "Tape-Drive");
					break;
				case DEVTYPE_PRINTER:
					sprintf( typeBuffer, "Printer");
					break;
				case DEVTYPE_PROCESSOR:
					sprintf( typeBuffer, "Processor");
					break;
				case DEVTYPE_WORM:
					if( ibuffer.ir_removable == YES)
						sprintf( typeBuffer, 
							"Removable-Worm");
					else
						sprintf( typeBuffer, 
							"Fixed-Worm");
					break;
				case DEVTYPE_READONLY:
					if( ibuffer.ir_removable == YES)
						sprintf( typeBuffer,
							 "Removable-ReadOnly");
					else
						sprintf( typeBuffer,
							"Fixed-ReadOnly");
					break;
				case DEVTYPE_SCANNER:
					sprintf(typeBuffer, "Scanner");
					break;
				case DEVTYPE_STILLVIDEO:
					sprintf(typeBuffer, "Still-Video");
					break;
				case DEVTYPE_NOTPRESENT:
					sprintf(typeBuffer, "No-Device");
					break;
				default:
					sprintf(typeBuffer, "Not-Recognized");
				}			
		
			}
		else
			{
			sprintf(vendorBuffer, "No device");
			sprintf(typeBuffer, "No-Device");
			}
		}
	else
		{
		sprintf(vendorBuffer, "Cannot access");
		sprintf(typeBuffer, "Cannot-Access");
		}
			
	[titles[target] setStringValue: vendorBuffer];
	
	sprintf(tiffBuffer,"%s.tiff", typeBuffer);
	
	if( target < 4)
		[[ButtonMatrix1 findCellWithTag: target] setIcon: typeBuffer];
	else
		[[ButtonMatrix2 findCellWithTag: target] setIcon: typeBuffer];
		
	NXPing();
	[scsi closeSCSI];
	[scsi free];
	return self;
}

- inquireSelected: sender
{
	SCSI	*scsi;
	static struct inquiry_reply ibuffer;
	static char vendorBuffer[10], productBuffer[30], revisionBuffer[10],
			typeBuffer[30];
	int target;
	struct readCapacity_reply rbuffer;
	static char tmpBuffer[50];

	[moreInfo1TitleText setStringValue: ""];
	[moreInfo2TitleText setStringValue: ""];
	[moreInfo3TitleText setStringValue: ""];
	[moreInfo1Text setStringValue: ""];
	[moreInfo2Text setStringValue: ""];
	[moreInfo3Text setStringValue: ""];
	
	target = [[sender selectedCell] tag];
	
	[self	inquireTarget: target];		// Get the small icon info right
	
	scsi  = [SCSI new];
	[scsi openSCSI];
	
	if( [scsi setTarget: target lun: 0] == 0 )
		{
		if([scsi inquirySCSI: &ibuffer] == 0)
			{
			strncpy( vendorBuffer, ibuffer.ir_vendorid, 8);
			strncpy( productBuffer, ibuffer.ir_productid, 16);
			strncpy( revisionBuffer, ibuffer.ir_revision, 4);
				
			switch( ibuffer.ir_devicetype )
				{
				case DEVTYPE_DISK:
					if( ibuffer.ir_removable == YES)
						sprintf( typeBuffer, 
						"Read/Write Disk - Removable");
					else
						sprintf( typeBuffer, 
							"Read/Write Disk - Fixed");
							
					if( [scsi readCapacitySCSI: &rbuffer] == 0)
						{
						[moreInfo1TitleText setStringValue:
							"Block Capacity: "];
						[moreInfo2TitleText setStringValue:
							"Block Size: "];
						[moreInfo3TitleText setStringValue:
							"Total disk capacity:"];			
						sprintf(tmpBuffer,"%d blocks", 
							rbuffer.logicalBlockAddress+1);
						[moreInfo1Text setStringValue:
							tmpBuffer];
						sprintf(tmpBuffer,"%d bytes", 
							rbuffer.blockLength);
						[moreInfo2Text setStringValue:
							tmpBuffer];
						sprintf(tmpBuffer,"%d bytes (%2.1f megabytes)",
							(rbuffer.logicalBlockAddress+1) *
							rbuffer.blockLength,
							(double)
							((rbuffer.logicalBlockAddress+1) *
							rbuffer.blockLength) / (1024*1024));
						[moreInfo3Text setStringValue:
							tmpBuffer];
						}
					break;
				case DEVTYPE_TAPE:														
					if( ibuffer.ir_removable == YES)
						sprintf( typeBuffer, 
							"Tape or Sequential Device - "
							"Removable");
					else
						sprintf( typeBuffer, 
							"Tape or Sequential Device - "
								"Fixed");
					break;
				case DEVTYPE_PRINTER:
					sprintf( typeBuffer, "Printer");
					break;
				case DEVTYPE_PROCESSOR:
					sprintf( typeBuffer, "Processor");
						break;
				case DEVTYPE_WORM:
					if( ibuffer.ir_removable == YES)
						sprintf( typeBuffer, 
							"Write Once Optical Disk - "
							"Removable");
					else
						sprintf( typeBuffer, 
							"Write Once Optical Disk - "
							"Fixed");
					break;
				case DEVTYPE_READONLY:
					if( ibuffer.ir_removable == YES)
						sprintf( typeBuffer,
							"CD-ROM or Read Only Device - "
							"Removable");
					else
						sprintf( typeBuffer,
							"CD-ROM or Read Only Device - "
							"Fixed");

					break;
				case DEVTYPE_SCANNER:
					sprintf(typeBuffer, "Scanner");
					break;
				case DEVTYPE_STILLVIDEO:
					sprintf(typeBuffer, "Still-video");
					break;
				case DEVTYPE_NOTPRESENT:
					sprintf(typeBuffer, "No Device");
					break;
				default:
					sprintf(typeBuffer, "Not Recognized -- 0x0%x",
						ibuffer.ir_devicetype );
				}			
			}
		else
			{
			strcpy(vendorBuffer, "-");
			strcpy(typeBuffer, "Not Present");
		
			strcpy( vendorBuffer,   "-");
			strcpy( productBuffer,  "-");
			strcpy( revisionBuffer, "-");
			}
		}
	else
		{
		strcpy(vendorBuffer, "-");
		strcpy(typeBuffer, "Cannot access");
		
		strcpy( vendorBuffer,   "-");
		strcpy( productBuffer,  "-");
		strcpy( revisionBuffer, "-");
		}
	
	[targetText		setIntValue:	target];
	[lunText		setIntValue:	0]; // lun is always 0 for now
	[vendorText		setStringValue:	vendorBuffer];
	[productText		setStringValue:	productBuffer];
	[revisionText		setStringValue: revisionBuffer];
	[typeText		setStringValue: typeBuffer];	

	[scsi closeSCSI];
	[scsi free];
	
	return self;
}


@end
