//
// SCSI.h
//
// SCSI generic driver object library (phew)
// Version 1 (Revision 1.0.1)
//
// The SCSI class source, header, and documentation are all:
// Copyright (c) 1990 by Canon Inc. 
// Copyright (c) 1991 by Jiro Nakamura.
 // All Rights Reserved.
//
// This class is provided for use by the general public. The class interface 
// header file (SCSI.h), source (SCSI.m) and documentation (Class_SCSI.wn) 
// may be freely copied and distributed as long as this legend is included on 
// all storage media and as part of the software program and documentation.
//
// See Class Documentation for information. I am not a great comment-person, 
// although I am not too proud of that fact....
//
// Original Author:	Jiro Nakamura @ Canon
// Created:		June 12, 1990
//
// RCS Information
// Revision Number->	$Revision: 1.6 $
// Last Revised->	$Date: 91/01/01 01:34:43 $
// ------------------
// History:
//	 6-Aug-90	Jiro
//		Cleaned up code. Removed dead fragments (Rev. 1.1)
//	 3-Aug-90	Jiro    
//		Added READ CAPACITY. (Rev. 1.0.1)
//	12-Jul-90	Jiro Nakamura
//		Fixed up for Revision 1.0 (Version 1).	
// 	12-Jun-90	Jiro Nakamura at Canon	(ac6y@vax5.cit.cornell.edu)
//		Created.

#import <objc/Object.h>
#import <sys/types.h>
#import <nextdev/scsireg.h>

// Structure for readCapacity basic command
struct readCapacity_reply
	{
	u_int	logicalBlockAddress: 32;
	u_int	blockLength: 32;
	};
	
	
@interface SCSI: Object
{
	BOOL scsiOpen;			// TRUE if SCSI device open

	int target, lun;		// Target/ logical unit
	int fd;				// File descriptor
	char *dev_name;			// Generic SCSI Device
	
	struct scsi_req sr;		// SCSI command request	parameters
	struct scsi_adr sa;		// SCSI address parameters
	
	char	errorString[100];	// English error information
}

// Factory methods
+ new;			// Overrides superclass


// Opening and closing the driver
- (int) openSCSI;
- (int) openSCSIAt: (int) trg lun: (int) ln;
- (int) closeSCSI;


// Setting the target SCSI ID and logical unit
- (int) setTarget: (int) target lun: (int)lun;


// Returning English error information
- (char *) errorString;


// User Macro Commands
- (int) findDevice;			// Just [self findDevice: 0];
- (int) findDevice: (int) trg;		// Wrap on findDeviceSCSI:
- (BOOL) isDevice: (int) trg;		// Wrap on isDeviceSCSI 
- (int) inquiry: (struct inquiry_reply *) ibuffer;	
- (int) readCapacity: (struct readCapacity_reply *) rbuffer;
- (int) requestSense: (struct esense_reply *) rbuffer;
- (int) testUnitReady;


// Pseudo-basic SCSI commands
- (BOOL) isDeviceSCSI: (int) trg;	// Subclass Responsibility
- (int) findDeviceSCSI: (int) trg;	// Is this our device?

// Basic SCSI commands. Structures are in <nextdev/scsireg.h> and above
- (int) inquirySCSI: 		(struct inquiry_reply *) ibuffer;
- (int) readCapacitySCSI:	(struct readCapacity_reply *) rbuffer;
- (int)	requestSenseSCSI:	(struct esense_reply *)  rbuffer;
- (int) testUnitReadySCSI;



// Variable accessors
- (struct scsi_req *) statusReq;
- (BOOL) scsiOpen;


// Archiving methods
- write: (NXTypedStream *) stream;
- read: (NXTypedStream *) stream;


// Internal Routines -- Only subclasses should use these
- (int) performSCSIRequest;
- clearCommandBlock: (union cdb *) cdbp;
@end


