// My stuff.
#import "Animator.h"
#import "MonApp.h"
#import "MonitorView.h"

// appkit stuff
#import <appkit/defaults.h>		// To get the dang things.
#import <appkit/Control.h>		// To handle initing of dialSize slider.
#import <appkit/Matrix.h>		// To handle initing of type matrix.
#import <appkit/Window.h>		// to blast the window around.

// unix stuff.
#import <stdlib.h>			// atof().

@implementation MonApp

+ new			// create the new application, and make us its delegate.
{
  self = [super new];
  [self setDelegate:self];
  return self;
}
- setMonitorView:anObject
{
  monitorView=anObject;
  return self;
}
// This is a gross, gross c function.  Positive side - it works!
const char *ftoa( float f)
{
  static char num[ 100];
  sprintf( num, "%f", f);
  return num;
}
- terminate:sender		// store the position and size.
{
  NXRect r;
  // This is stupid.  Need the _window's_ position in screen coordinates,
  // and the _monitorView's_ size (no coordinates) to be able to correctly
  // place the window when re-run.  Didn't want to use placeWindow, as
  // sizes and stuff didn't seem to work.
  [[monitorView window] getFrame:&r];
  NXWriteDefault( [self appName], "WindowX", ftoa( r.origin.x));
  NXWriteDefault( [self appName], "WindowY", ftoa( r.origin.y));
  [monitorView getBounds:&r];
  NXWriteDefault( [self appName], "WindowWidth", ftoa( r.size.width));
  NXWriteDefault( [self appName], "UpdateInterval", ftoa( [[monitorView animator] timing]));
  return [super terminate:sender];
}
- appPowerOffIn:(int)ms andSave:(int)aFlag	// catch Workspace logout.
{
  return [self terminate:self];
}

- setTimingSlider:anObject
{
  timingSlider=anObject;
  return self;
}

static NXDefaultsVector def=
  {
    { "WindowX", "250"},
    { "WindowY", "400"},
    { "WindowSize", "350"},
    { "UpdateInterval", "1.0"},
    {NULL},
  };

- appDidInit:sender		// get info such as window positioning.
{
  NXRect r;
  NXRegisterDefaults( [self appName], def);
  [[monitorView animator] setTiming:atof( NXGetDefaultValue( [self appName], "UpdateInterval"))];
  [timingSlider setFloatValue:[[monitorView animator] timing]];
  
  [[monitorView window]
	      moveTo:atof( NXGetDefaultValue( [self appName], "WindowX"))
		    :atof( NXGetDefaultValue( [self appName], "WindowY"))];
  [[[monitorView window] contentView] getBounds:&r];
  [[monitorView window]
	      sizeWindow:atof( NXGetDefaultValue( [self appName], "WindowSize"))
	      		:r.size.height];
  
  [[monitorView window] display];			// Let's redraw some stuff.
  [[monitorView window] orderFront:self];		// and then display it.
  [[monitorView animator] start:self];			// start the fun!
  return self;
}

@end
