/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	bsd_prot.c,v $
 * Revision 2.2  90/09/08  00:15:35  rwd
 * 	First checkin
 * 	[90/08/31  13:33:28  rwd]
 * 
 */
/*
 *	File:	./bsd_prot.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <mach.h>
#include <errno.h>
#include <ux_user.h>

bsd_getgroups(ut, rval, ngids, gids)
	struct ux_task *ut;
	int rval[2];
	int ngids;
	int *gids;
{
	if (ngids < ut->ut_ngids) {
		return EINVAL;
	}
	bcopy(ut->ut_gids, gids, ut->ut_ngids * sizeof(int));
	rval[0] = ut->ut_ngids;
	return 0;
}

bsd_setgroups(ut, rval, ngids, gids)
	struct ux_task *ut;
	int rval[2];
	int ngids;
	int *gids;
{
	int error;

	if (ngids < 0 || ngids > NGIDS) {
		return EINVAL;
	}
	bcopy(gids, ut->ut_gids, ngids * sizeof(int));
	ut->ut_ngids = ngids;
	return 0;
}

Bsd_getgid(ut, rval)
	struct ux_task *ut;
	int rval[2];
{
	rval[0] = ut->ut_rgid;
	rval[1] = ut->ut_egid;
	return 0;
}

Bsd_getuid(ut, rval)
	struct ux_task *ut;
	int rval[2];
{
	rval[0] = ut->ut_ruid;
	rval[1] = ut->ut_euid;
	return 0;
}

Bsd_setreuid(ut, rval, ruid, euid)
	struct ux_task *ut;
	int rval[2];
	int ruid;
	int euid;
{
	if (ruid != -1) ut->ut_ruid = ruid;
	if (euid != -1) ut->ut_euid = euid;
	return 0;
}
	
Bsd_setregid(ut, rval, rgid, egid)
	struct ux_task *ut;
	int rval[2];
	int rgid;
	int egid;
{
	if (rgid != -1) ut->ut_rgid = rgid;
	if (egid != -1) ut->ut_egid = egid;
	return 0;
}
