/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	ufs_dops.c,v $
 * Revision 2.2  90/09/08  00:21:36  rwd
 * 	First checkin
 * 	[90/08/31  13:59:58  rwd]
 * 
 */
/*
 *	File:	./ufs_dops.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <mach.h>
#include <fnode.h>
#include <errno.h>
#include <ux_user.h>
#include <ufs_fops.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <bsd_ioctl.h>

extern struct ux_task *ut_self();

/* Used for creating files and for creating directories. */
ufs_create(und, unp, mode)
	struct unode *und;
	struct unode **unp;
        int mode;
{
   struct unode *un;
   int error;
   struct ux_task  *ut = ut_self();
   struct fs *fs = &und->un_ud->ud_fs;
   struct direct *dp;

   mode &= S_IFMT | ~ut->ut_umask; /* umask cannot effect file type */
   if( error = ialloc( und, 0 /*ipref*/, mode, NULL /*cred*/, &un )) {
      return error;
   }
   un->i_mode = mode;
   printf ("AJR ufs_create: un->i_mode set to 0%o.\n", un->i_mode );
   un->i_nlink = 0;
   un->i_uid = und->i_uid; /* I know it's more complicated that this */
   un->i_gid = und->i_gid; /* " " XXX */
   un->i_rdev = 0; /* ??? */
   un->i_size = 0;
   un->i_atime = get_time(0);
   un->i_mtime = un->i_atime;
   un->i_ctime = un->i_atime;
   un->i_blocks = 0;
   if( (mode & S_IFMT) == S_IFDIR ) {
      if( (error = denter (".", un, un->un_ino)) ||
	  (error = denter ("..", un, und->un_ino ))) {
	 itrunc( un, 0, 0 );
	 ifree( un, un->un_ino, un->i_mode );
	 return error;
      }
      (un->i_nlink)++;
      (und->i_nlink)++;
   }
   *unp = un;
   return 0;
}

ufs_link(und, name, un)
	struct unode *und;
	char *name;
	struct unode *un;
{
   int error;

   printf ("AJR ufs_link called on name %s.\n", name );
   if( error = denter(name, und, un->un_ino) ) return error;

   un->i_nlink++;
   return 0;
}

ufs_unlink(und, name, un)
	struct unode *und;
	char *name;
     	struct unode *un;
{
   /* check for type? or is that done above, in bsd_unlink? */
   int error;

   if( error = dremove(name, und) ) return error;

   if( --(un->i_nlink) == 0 ) {
      itrunc( un, 0, 0 );
      ifree( un, un->un_ino, un->i_mode );
   }
   return 0;
}
