/* 
 * Mach Operating System
 * Copyright (c) 1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/*
 * HISTORY
 * $Log:	ecc.c,v $
 * Revision 2.3  92/07/09  22:53:10  rvb
 * 	Minimal support for mapping ecc fifo's.
 * 	[92/05/12  17:09:58  rvb]
 * 
 * Revision 2.2  92/04/03  12:08:12  rpd
 * 	Created
 * 	[92/03/23            rvb]
 * 
 */

#include <ecc.h>

#if	NECC > 0

#include <machine/machparam.h>		/* spl definitions */
#include <sys/types.h>
#include <kern/time_out.h>		/* ? maybe */
#include <device/errno.h>
#include <device/io_req.h>

#include <chips/busses.h>
#include <chips/eccreg.h>

#include <mips/mips_cpu.h>

struct bus_device *ecc_info[NECC];
int ecc_probe(), ecc_attach();

struct bus_driver ecc_driver =
       { ecc_probe, 0, ecc_attach, 0, /* csr */ 0, "ecc", ecc_info, 
       	 "", 0, /* flags */ BUS_INTR_DISABLED};

typedef struct	ecc_softc {
       caddr_t	addr;
       int foo;
} ecc_softc_t;

ecc_softc_t ecc_softc[NECC];

ecc_probe(reg, ui)
u_long reg;
register struct bus_device *ui;
{
	int             unit = ui->unit;
	int             i;
	register ecc_softc_t *ec;
	int 		*cr = (int *)(reg + FA_CR);

	if (check_memory(reg, 0))
		return 0;

	ecc_info[unit] = ui;
	ec = &ecc_softc[unit];
	ec->addr = (caddr_t) reg;		/* k1 address */

	/*
	 * this would probably be a good place to reset the interface
	 * or at least print the state.
	*addr = RESET_RCV | RESET_XMT;
	 */
	return 1;
}

ecc_attach(ui)
register struct bus_device *ui;
{
	int             	unit = ui->unit;
	struct ecc_softc	*ec = &ecc_softc[unit];
	caddr_t			addr = ec->addr;
}

ecc_intr(unit, spllevel)
int unit;
int spllevel;
{
	register struct ecc_softc	*ec = &ecc_softc[unit];
}

ecc_output(dev, ior)
dev_t		dev;
io_req_t	ior;
{
}

ecc_start(unit)
int unit;
{
}

ecc_open(dev, flag, ior)
dev_t		dev;
int		flag;
io_req_t	ior;
{
	register int	 	unit = minor(dev);
	register ecc_softc_t	*ec = &ecc_softc[unit];
	
	if (unit >= NECC)
		return EINVAL;
	if (!(int)ec->addr)
		return ENXIO;

	return KERN_SUCCESS;
}

ecc_close(dev, flag)
dev_t	dev;
{
}

ecc_read(dev, ior)
dev_t		dev;
io_req_t	ior;
{
}

ecc_write(dev, ior)
dev_t		dev;
io_req_t	ior;
{
}

ecc_get_status(dev, flavor, status, status_count)
dev_t		 dev;
int		 flavor;
dev_status_t	 status;	/* pointer to OUT array */
unsigned int	*status_count;		/* out */
{
}

ecc_set_status(dev, flavor, status, status_count)
dev_t		dev;
int		flavor;
dev_status_t	status;
unsigned int	status_count;
{
}

ecc_mmap(dev, off, prot)
	dev_t		dev;
	vm_offset_t	off;
	int		prot;
{
	caddr_t		addr = ecc_softc[minor(dev)].addr;
	int i;

	if (off < FA_END)	/* 4 * 64K bytess */ {
		i = K1SEG_TO_PHYS(addr + off);
		return mips_btop(i);
	} else
		return -1;
}

ecc_setinput(dev, receive_port, priority, filter, filter_count)
dev_t		dev;
ipc_port_t	receive_port;
int		priority;
/*filter_t	*filter;*/
unsigned int	filter_count;
{
}

ecc_restart(ifp)
/*	register struct ifnet *ifp;	*/
{
}

ecc_portdeath(dev, port)
dev_t		dev;
mach_port_t	port;
{
}

#endif	NECC > 0





