#
# $RCSfile: GenProtComposeHacks.awk,v $
#
# x-kernel v3.2
#
# Copyright (c) 1993,1991,1990  Arizona Board of Regents
#
# $Revision: 1.1 $
# $Date: 1993/04/27 00:49:27 $

#
# Generates Makefile directives from a file describing irregularities
# in the files making up the protocol library 
#


BEGIN {
	print "#"
	print "# WARNING -- This file is automatically generated and "
	print "# overwritten.  Make changes to the ComposeHacksList file, "
	print "# not directly to this file."
	print "#"
	print ""
}

NF == 2 {
	print "ifneq (,$(findstring +"$1"+,$(COMPOSE_LIB_PROTS)))"
	print $1"_FILES = $("$2"_FILES)"
	print "COMPOSE_LIB_PROTS := $(COMPOSE_LIB_PROTS)+"$2"+"
	print "endif"
	print ""
}

NF > 2 {
	printf("%s_FILES := \\\n", $1);
	for ( i=3; i <= NF; i++ ) {
		printf("\t protocols/%s/$(HOW)/%s/.o \\\n", $2, $i);
	}
	printf("\n\n");
}