/*
 * java.io.FileDescriptor.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 **/

/*** CHANGELOG ***
 *
 *  2.2.1998   Vesa Karpijoki        added SET- and USED-calls
 *
 * 15.2.1998   Arttu Kuukankorpi     added dokumatic-documentation
 *
 * 16.3.1998   Arttu Kuukankorpi     changed include-directories of
 *                                    FileDescriptor.h and support.h
 */

#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "../java.io.stubs/FileDescriptor.h"
#include "kthread.h"
#include "../../../src/support.h"

/**
  @title java_io_FileDescriptor
  @desc Instances of the file descriptor class serve as an opaque handle to the underlying machine-specific structure representing an open file or an open socket. 
  @funcidx
  @end
  */

/**
  @function java_io_FileDescriptor_initSystemFD
  @description Initialise a file descriptor to the given file nr.
  @parameter Reference to the current (this) object.
  @parameter File number.
  @rvalue File Descriptor.
  @end
  */

struct Hjava_io_FileDescriptor*
java_io_FileDescriptor_initSystemFD(struct Hjava_io_FileDescriptor* this, jint i)
{
	unhand(this)->fd = fixfd(i);
	return (this);
}

/**
  @function java_io_FileDescriptor_valid
  @description Is this file descriptor valid ?
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_FileDescriptor_valid(struct Hjava_io_FileDescriptor* this)
{
	if (unhand(this)->fd >= 0) {
		return (1);
	}
	else {
		return (0);
	}
}

/*
 * XXX UNIMPLEMENTED
 **/
void
java_io_FileDescriptor_sync(struct Hjava_io_FileDescriptor* this)
{
    SET(this);
    USED(this);

    unimp("java.io.File:sync unimplemented");
}
