/*
 * java.util.ResourceBundle.c
 *
 * Copyright (c) 1996,97 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.co.uk>
 */

/*** CHANGELOG ***
 *
 * 2.2.1998    Vesa Karpijoki   Added some SET- and USED-calls.
 *
 */

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "config-io.h"
#include <native.h>
#include "../java.util.stubs/ResourceBundle.h"

/**
  @title java_util_ResourceBundle
  @funcidx
  @end
  */

/**
  @function    java_util_ResourceBundle
  @description Returns the class context of the ResourceBundle.
  @parameter   Reference to the current (this) object.
  @rvalue      Java Object Array holding the context.
  @end
  */

HArrayOfObject* java_util_ResourceBundle_getClassContext(struct Hjava_util_ResourceBundle* this)
{
    HArrayOfObject* array;
    SET(this);
    USED(this);

    array = (HArrayOfObject*)AllocObjectArray(3, "Ljava/lang/Class;");

    return (array);
}
