/*
 * gethostbyaddr.c
 *
 * Uses the dns to solve the name of the host based on an internet address
 * that is given as an argument to the function.
 * 
 * This function is a helper function for java.net.InetAddressImpl native
 * methods.
 */

#include <u.h>
#include <libc.h>
#include "dns.h"
#include "hostresolution.h"
#include "ip.h"

/**
  @title gethostbyaddr
  @desc This function is used to get the host name based on an address.
  @funcidx
  @end
  */

/**
  @function    gethostbyaddr
  @description Returns the host name based on a given internet address.
  @parameter   The internet address of the host in host byte order.
  @parameter   Pointer to a char buffer where the returned name is stored.
  @rvalue      Pointer to the beginning of the string holding the asked name.
  @end
  */

char* gethostbyaddr(int addr, char *name)
{
  int fd, n, ip1, ip2, ip3, ip4;
  char *p1, *line;
  char buf[1024], line2[100];
 
  fd = open("/net/dns", ORDWR);
  
  if(fd < 0){
    
    fd = open("/srv/dns", ORDWR);
    
    if(fd < 0){
      print("can't open /srv/dns: %r\n");
      return 0;
    }
    
    if(mount(fd, "/net", MBEFORE, "") < 0){
      print("can't mount /srv/dns: %r\n");
      return 0;
    }
    
    fd = open("/net/dns", ORDWR);
    
    if(fd < 0){
      print("can't open /net/dns: %r\n");
      return 0;
    }
  }
  
  ip1 = (addr & 0xff000000) >> 24;
  ip2 = (addr & 0x00ff0000) >> 16;
  ip3 = (addr & 0x0000ff00) >> 8;
  ip4 = (addr & 0x000000ff);
  
  sprint(line2, "%d.%d.%d.%d.in-addr.arpa", ip1, ip2, ip3, ip4);

  line = strcat(line2, " ptr");
  n = strlen(line);

  seek(fd, 0, 0);
  if(write(fd, line, n) < 0)
    return 0;
  
  seek(fd, 0, 0);
  while((n = read(fd, buf, sizeof(buf))) > 0) {
    buf[n] = 0;
    
    p1 = strstr(buf, " ptr")+5;
    strcpy(name, p1);
  }
  close(fd);
  
  return name;
}



