/*
 * readClass.c
 * Read in a new class.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 *  27.1.1998    Teemu Ikonen                Standard headers 
 *     
 *
 */

#define	DBG(s) 

#include <u.h>
#include <libc.h>
#include "plan9interface.h"
#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "config-mem.h"
#include "gtypes.h"			/* Ugh! */
#include "file.h"       		/* Ugh! */
#include "access.h"			/* Ugh! */
#include "object.h"
#include "constants.h"			/* Ugh! */
#include "readClassConfig.h"		/* Ugh! */
#include "readClass.h"

Hjava_lang_Class*
readClass(Hjava_lang_Class* classThis, classFile* fp, struct Hjava_lang_ClassLoader* loader)
{
	u2 minor_version;
	u2 major_version;
	u4 magic;
	u2 access_flags;
	u2 this_class;
	u2 super_class;

	/* Read in class info */
	readu4(&magic, fp);
	if (magic != JAVAMAGIC) {
		fprintf(stderr, "Bad magic %x in class\n", magic);
		EXIT(1);
	}
	readu2(&minor_version, fp);
	readu2(&major_version, fp);

DBG(	printf("major=%d, minor=%d\n", major_version, minor_version);	)

	if (major_version != MAJOR_VERSION) {
		fprintf(stderr, "Warning: Major version number mismatch.\n");
	}
	if (minor_version != MINOR_VERSION) {
		fprintf(stderr, "Warning: Minor version number mismatch.\n");
	}

	readConstantPool(classThis, fp);

	readu2(&access_flags, fp);
	readu2(&this_class, fp);
	readu2(&super_class, fp);

	ADDCLASS(this_class, super_class, access_flags, constant_pool);

	readInterfaces(fp, classThis);
	readFields(fp, classThis);
	readMethods(fp, classThis);
	readAttributes(fp, classThis, classThis);

	return (classThis);
}

/*
 * Read in interfaces.
 */
void
readInterfaces(classFile* fp, Hjava_lang_Class* this)
{
    u2 interfaces_count;

    readu2(&interfaces_count, fp);
    DBG(	printf("interfaces_count=%d\n", interfaces_count);	)

	
    READINTERFACES(fp, this, interfaces_count);
}

/*
 * Read in fields.
 */
void
readFields(classFile* fp, Hjava_lang_Class* this)
{
	u2 i;
	u2 fields_count;
	void* fieldThis;

	readu2(&fields_count, fp);
DBG(	printf("fields_count=%d\n", fields_count);		)
	fieldThis = 0;

	READFIELD_START(fields_count, this);

	for (i = 0; i < fields_count; i++) {
		READFIELD(fp, this);


		readAttributes(fp, this, fieldThis);

	}
	READFIELD_END(this);

}

/*
 * Read in attributes.
 */
void
readAttributes(classFile* fp, Hjava_lang_Class* this, void* thing)
{
	u2 i;
	u2 cnt;

	readu2(&cnt, fp);
DBG(	printf("attributes_count=%d\n", cnt);				)

	/* Skip attributes for the moment */
	for (i = 0; i < cnt; i++) {
		READATTRIBUTE(fp, this, thing);

	}
}

/*
 * Read in methods.
 */
void
readMethods(classFile* fp, Hjava_lang_Class* this)
{
	u2 i;
	u2 methods_count;
	Method* methodThis;

	readu2(&methods_count, fp);
DBG(	printf("methods_count=%d\n", methods_count);		)
	methodThis = 0;

	READMETHOD_START(methods_count, this);

	for (i = 0; i < methods_count; i++) {
		READMETHOD(fp, this);

		readAttributes(fp, this, methodThis);
	}
	READMETHOD_END();

}
