import java.io.*;

class RandomAccessFileTest {

  public static void main (String args[])
  throws java.io.IOException,
    java.io.EOFException
  {
    RandomAccessFile f1;
    RandomAccessFile f2;
    int count = 0;
    int tmp;
    byte[]  buffer = new byte[1024];

    f1 = new RandomAccessFile(args[0], "r");
    f2 = new RandomAccessFile(args[1], "rw");

    System.out.println(args[0] + " is " + f1.length() + " bytes long.");
    System.out.println("Skipped " + f1.skipBytes(1000) + " bytes in " + args[0]);
    System.out.println("File pointer of " + args[0] + " is " + f1.getFilePointer());

    System.out.println("Read " + f1.read(buffer) + " bytes from " + args[0]);
    f2.write(buffer);

    while ( (tmp = f1.read() ) != -1 ) {
      count += 1;
      f2.write(tmp);
    }

    System.out.println("Read " + count + " bytes before reached the end of file.");

    f1.close();
    f2.close();
  }
}
