/*
 * java.io.File.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 **/

/*** CHANGELOG ***
 *
 * 22.1.1998   Arttu Kuukankorpi          removed some includes
 *
 * 26.1.1998   Arttu Kuukankorpi          changed the way stat-calls are
 *                                        being used
 *
 *  1.2.1998   Arttu Kuukankorpi          fixed some bugs
 *
 *  2.2.1998   Vesa Karpijoki             fixed some bugs
 *
 * 12.2.1998   Teemu Ikonen, Jari K.      fixed some bugs
 *
 * 15.2.1998   Arttu Kuukankorpi          added dokumatic-documentation
 *
 * 16.3.1998   Arttu Kuukankorpi          changed include-directory of
 *                                        support.h and File.h
 */


#include <u.h>
#include <libc.h>
#include <auth.h> 
#include <fcall.h> 

#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include "config-mem.h"
#include <native.h>
#include "defs.h"
#include "files.h"
#include "system.h"
#include "../java.io.stubs/File.h"
#include "../../../src/support.h"

extern void* gc_malloc_fixed(unsigned int);

/**
  @title java_io_File
  @desc Instances of this class represent the name of a file or directory on the host file system.
  @funcidx
  @end
  */

/**
  @function java_io_File_isFile0
  @description Is named item a file?
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_isFile0(struct Hjava_io_File* this)
{
        Dir edir;
        char ap[DIRLEN];
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = stat(str, ap);
        if (r < 0) {
                return (0);
        }

	convM2D(ap, &edir);

	if (edir.mode&CHDIR) {
		return (0);
	}
	else {
		return (1);
	}
}

/**
  @function java_io_File_isDirectory0
  @description Is named item a directory?
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_isDirectory0(struct Hjava_io_File* this)
{
        Dir edir;
	char str[MAXPATHLEN];
        char ap[DIRLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = stat(str, ap);
        if (r < 0) {
                return (0);
        }

	convM2D(ap, &edir);

	if (edir.mode&CHDIR) {
		return (1);
	}
	else {
		return (0);
	}
}

/**
  @function java_io_File_exists0
  @description Does named file exist?
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_exists0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];

	javaString2CString(unhand(this)->path, str, sizeof(str));

        return (access(str, 0) < 0) ? 0 : 1;

/*
	r = stat(str, &buf);
	if (r < 0) {
		return (0);
	}
	else {
		return (1);
	}
*/
}

/**
  @function java_io_File_lastModified0
  @description Last modified time on file.
  @parameter Reference to the current (this) object.
  @end
  */

jlong
java_io_File_lastModified0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
        char ap[DIRLEN];
        Dir edir;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	if( stat(str, ap) < 0 )
		return 0;
	memset(&edir, 0, sizeof(Dir));
	convM2D(ap, &edir);
	
	return edir.mtime;

/*
	r = stat(str, &buf);
	if (r != 0) {
		return (off_t2jlong(0));
	}
	return (buf.st_mtime * (jlong)1000);
*/
}

/**
  @function java_io_File_canWrite0
  @description Can I write to this file?
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_canWrite0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	r = access(str, 2);
	return (r < 0 ? 0 : 1);
}

/**
  @function java_io_File_canRead0
  @description Can I read from this file?
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_canRead0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	r = access(str, 4);
	return (r < 0 ? 0 : 1);
}

/**
  @function java_io_File_length0
  @description Return length of file.
  @parameter Reference to the current (this) object.
  @end
  */

jlong
java_io_File_length0(struct Hjava_io_File* this)
{
	char ap[DIRLEN];
        Dir edir;
	char str[MAXPATHLEN];

	javaString2CString(unhand(this)->path, str, sizeof(str));

	if( stat(str, ap) < 0 )
		return 0;
	memset(&edir, 0, sizeof(Dir));
	convM2D(ap, &edir);
	
	return edir.length;
}

/**
  @function java_io_File_mkdir0
  @description Create a directory.
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_mkdir0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));

	r = create(str, OREAD, CHDIR|0777L);

	return (r < 0 ? 0 : 1);
}

/**
  @function java_io_File_renameTo0
  @description Rename a file.
  @parameter Reference to the current (this) object.
  @parameter Reference to a object with the new name of file
  @end
  */

jbool
java_io_File_renameTo0(struct Hjava_io_File* this, struct Hjava_io_File* that)
{
	char ap[DIRLEN];
        Dir edir;
	char str[MAXPATHLEN];
	char str2[MAXPATHLEN];

	javaString2CString(unhand(this)->path, str, sizeof(str));
	javaString2CString(unhand(that)->path, str2, sizeof(str2));

	if( stat(str, ap) < 0 )
		return 0;
	memset(&edir, 0, sizeof(Dir));
	convM2D(ap, &edir);

	if( strlen(str2) > NAMELEN )
		return 0;
	strcpy(edir.name, str2);
	convD2M(&edir, ap);

	return (wstat(str, ap) < 0) ? 0 : 1;
}

/**
  @function java_io_File_delete0
  @description Delete a file.
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_delete0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	r = remove(str);
	return(r < 0 ? 0 : 1);
}

/**
  @function java_io_File_rmdir0
  @description Delete a directory.
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_rmdir0(struct Hjava_io_File* this)
{
	char str[MAXPATHLEN];
	int r;

	javaString2CString(unhand(this)->path, str, sizeof(str));
	r = remove(str);
	return(r < 0 ? 0 : 1);
}

/**
  @function java_io_File_list0
  @description Get a directory listing.
  @parameter Reference to the current (this) object.
  @rvalue Array containing the directory listing.
  @end
  */

HArrayOfObject*
java_io_File_list0(struct Hjava_io_File* this)
{
	char path[MAXPATHLEN];
/*
	DIR* dir;
	struct dirent* entry;
*/
	struct dentry {
		struct dentry* next;
		struct Hjava_lang_String* name;
	};
	struct dentry* dirlist;
	struct dentry* mentry;
	HArrayOfObject* array;
	int count;
	int i;

        int n;
        int fd;
        Dir buf[25];

	javaString2CString(unhand(this)->path, path, sizeof(path));

/*
	dir = opendir(path);
	if (dir == 0) {
		return (0);
	}
*/
	fd = open(path, OREAD);
	if( fd < 0 )
		return 0;

	dirlist = 0;
	count = 0;
	while ( (n = dirread(fd,buf,sizeof(buf))) > 0) {
                n /= sizeof(Dir);
                for(i=0; i<n; i++) {
		    /*                   mentry = (struct dentry *)sysMalloc(sizeof(struct dentry));*/
		   mentry = (struct dentry *)gc_malloc_fixed(sizeof(struct dentry));
		   mentry->name = makeJavaString(buf[i].name,strlen(buf[i].name));
		   mentry->next = dirlist;
		   dirlist = mentry;
		   count++;
                }
	}
/*
	closedir(dir);
*/
        close(fd);

	array = (HArrayOfObject*)AllocObjectArray(count, "Ljava/lang/String");
	for (i = 0; i < count; i++) {
		mentry = dirlist;
		dirlist = mentry->next;
		unhand(array)->body[i] = (Hjava_lang_Object*)mentry->name;
		gc_free(mentry);
	}

	return (array);
}

/*
 * XXX UNIMPLEMENTED
 **/
struct Hjava_lang_String*
java_io_File_canonPath(struct Hjava_io_File* this, struct Hjava_lang_String* str)
{
    SET(this);
    USED(this);
    SET(str);
    USED(str);
    unimp("java.io.File:canonPath unimplemented");
    return (NULL);
}

/**
  @function java_io_File_isAbsolute0
  @description Is this filename absolute?
  @parameter Reference to the current (this) object.
  @end
  */

jbool
java_io_File_isAbsolute(struct Hjava_io_File* this)
{
	char str[2];

	javaString2CString(unhand(this)->path, str, sizeof(str));

	if (str[0] == file_seperator[0]) {
		return (1);
	}
	else {
		return (0);
	}
}
