/*
 * java.lang.Float.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h> and <libc.h>.
 *                              Removed some #includes.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 */

#include <u.h>
#include <libc.h>

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "../../../src/gtypes.h"
#include "../../../src/classMethod.h"
#include <native.h>
#include "defs.h"
#include "../java.lang.stubs/Float.h"

/**
  @title java_lang_Float
  @desc Native methods of the Java API class java.lang.Float.
  @funcidx
  @end
  */

/**
  @function java_lang_Float_toString
  @description Convert float to a string.
  @parameter Float value to be converted.
  @rvalue Reference to the created string.
  @end
  */
struct Hjava_lang_String*
java_lang_Float_toString(jfloat val)
{
	char str[MAXNUMLEN];

	sprintf(str, "%g", val);
	return (makeJavaString(str, strlen(str)));
}

struct Hjava_lang_Double;
extern double java_lang_Double_valueOf0(struct Hjava_lang_String*);

/**
  @function java_lang_Float_valueOf
  @description Convert string into Float object. (JDK 1.0.2)
  @parameter Reference to the string to be converted.
  @rvalue Reference to the created Float object.
  @end
  */
struct Hjava_lang_Float* java_lang_Float_valueOf(struct Hjava_lang_String* str)
{
	struct Hjava_lang_Float* obj;
	obj = (struct Hjava_lang_Float*)execute_java_constructor(0, "java.lang.Float", 0, "()V");
	unhand(obj)->value = java_lang_Double_valueOf0(str);
	return (obj);
}

/**
  @function java_lang_Float_floatToIntBits
  @description Convert float to int bits.
  @parameter Float value to be converted.
  @rvalue Converted jint value.
  @end
  */
jint
java_lang_Float_floatToIntBits(jfloat val)
{
	return (*(jint*)&val);
}

/**
  @function java_lang_Float_intBitsToFloat
  @description Convert int bits to float.
  @parameter Jint value to be converted.
  @rvalue Converted float value.
  @end
  */
float
java_lang_Float_intBitsToFloat(jint val)
{
	return (*(jfloat*)&val);
}
