/*
 * java.lang.SecurityManager.c
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "lib-license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG ***
 *
 * 21.1.1998   Vesa Karpijoki   Added #includes <u.h>, <libc.h> and
 *                              "plan9interface.h". Removed some #includes.
 *
 * 2.2.1998    Vesa Karpijoki   Added some SET- and USED-calls. Fixed some bugs.
 *
 * 18.3.1998   Vesa Karpijoki   Added Dokumatic documentation.
 *                              Changed #include:s.
 */

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "../../../src/gtypes.h"
#include "../../../src/access.h"
#include "../../../src/constants.h"
#include "../../../src/object.h"
#include "../../../src/classMethod.h"
#include "../../../src/itypes.h"
#include <native.h>
#include "defs.h"
#include "../java.lang.stubs/SecurityManager.h"
#include "../../../src/stackTrace.h"
#include "../../../src/support.h"

/**
  @title java_lang_SecurityManager
  @desc Native methods of the Java API class java.lang.SecurityManager.
  @funcidx
  @end
  */

extern struct Hjava_lang_Class* getClassWithLoader(int*);

/**
  @function java_lang_SecurityManager_getClassContext
  @description Gets the class context.
  @parameter Reference to the SecurityManager object (this).
  @rvalue Reference to an array describing the class context.
  @end
  */
HArrayOfObject* java_lang_SecurityManager_getClassContext(struct Hjava_lang_SecurityManager* this)
{
    SET(this);
    USED(this);

    /* HArrayOfClass */
    return ((HArrayOfObject*)getClassContext(NULL));
}

/**
  @function java_lang_SecurityManager_currentClassLoader
  @description Gets the most recent class loader.
  @parameter Reference to the SecurityManager object (this).
  @rvalue Reference to the current ClassLoader object.
  @end
  */
struct Hjava_lang_ClassLoader* java_lang_SecurityManager_currentClassLoader(struct Hjava_lang_SecurityManager* this)
{
    int depth;
    struct Hjava_lang_Class* class;

    SET(this);
    USED(this);

    class = getClassWithLoader(&depth);
    if (class != NULL) {
	return ((struct Hjava_lang_ClassLoader*)(class->loader));
    }
    else {
	return NULL;
    }
}

/**
  @function java_lang_SecurityManager_classDepth
  @description Returns the stack depth of the specified class.
  @parameter Reference to the SecurityManager object (this).
  @parameter Reference to the fully qualified name of the class to search for.
  @rvalue The depth on the stack frame of the first occurrence of a method
  from a class with the specified name. -1 if such a frame cannot be found. 
  @end
  */
jint java_lang_SecurityManager_classDepth(struct Hjava_lang_SecurityManager* this, struct Hjava_lang_String* str)
{
    char buf[MAXNAMELEN];

    SET(this);
    USED(this);

    javaString2CString(str, buf, sizeof(buf));
    classname2pathname(buf, buf);

    return (classDepth(buf));
}

/**
  @function java_lang_SecurityManager_classLoaderDepth
  @description Returns the stack depth of the most recently executing
  method from a class defined using a class loader.
  @parameter Reference to the SecurityManager object (this).
  @rvalue The depth on the stack frame of the most recent occurrence of a
  method from a class defined using a class loader. Returns -1 if there is no
  occurrence of a method from a class defined using a class loader.
  @end
  */
jint java_lang_SecurityManager_classLoaderDepth(struct Hjava_lang_SecurityManager* this)
{
    int depth;

    SET(this);
    USED(this);

    SET(depth);
    USED(getClassWithLoader(&depth));

    return (depth);
}

/**
  @function java_lang_SecurityManager_currentLoadedClass0
  @description Unimplemented!
  @parameter Reference to the SecurityManager object (this).
  @rvalue Reference to a Class object.
  @end
  */
struct Hjava_lang_Class* java_lang_SecurityManager_currentLoadedClass0(struct Hjava_lang_SecurityManager* this)
{
    SET(this);
    USED(this);

    unimp("java.lang.SecurityManager:currentLoadedClass0 unimplemented");

    return NULL;
}
