/*
 * gtypes.h
 * General types.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */


#ifndef __gtype_h
#define __gtype_h

#include "config.h"
#include "jtypes.h"

typedef signed char		int8;


typedef	unsigned char		uint8;

typedef	short			int16;
typedef	unsigned short		uint16;


typedef	int			int32;
typedef	unsigned int		uint32;


typedef	long long		int64;
typedef	unsigned long long	uint64;


typedef uint32			uintp;


typedef enum _bool {
	false	= 0,
	true	= 1
} bool;

typedef uint8			u1;
typedef uint16			u2;
typedef uint32			u4;

typedef	u1		nativecode;
typedef u2		accessFlags;
typedef u2		constIndex;

typedef struct _strconst Utf8Const;
/* typedef struct Hjava_lang_Class Class; */
typedef struct _methods Method;
typedef struct Array Array;
typedef struct _fields Field;

#define PTR_TYPE_SIZE	SIZEOF_VOIDP

struct _constants;
struct _methodTable;
struct _dispatchTable;
struct _jexception;

/* If INTERN_UTF8CONSTS is 1, then all Utf8Const objects are interned in
 * a hashtable, thus you can compare them with ==.
 */
#define INTERN_UTF8CONSTS	0

struct _strconst {
	/* If we're not interning, store hash for fast comparisons. */
	uint16			hash;

	uint16			length;
	char			data[1]; /* In Utf8 format, with final '\0'. */
};

#define	SHIFT_jchar		1
#define	SHIFT_jbyte		0
#define	SHIFT_jshort		1
#define	SHIFT_jint		2
#define	SHIFT_jlong		3
#define	SHIFT_jfloat		2
#define	SHIFT_jdouble		3
#define	SHIFT_jref		2


#define	EXIT(X)	exit(X)
#define	ABORT()	abort()


#endif
