/*
 * locks.h
 * Manage locking system.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.co.uk>, 1996,97.
 */

#ifndef __locks_h
#define __locks_h

#include "md.h"

/*
 * Use native locks if available, otherwise use the internal ones.
 */
#include "locks-internal.h"

#define	lockMutex(THING)	_lockMutex((THING))
#define	unlockMutex(THING)	_unlockMutex((THING))
#define	waitCond(THING, TIME)	_waitCond((THING), (TIME))
#define	signalCond(THING)	_signalCond((THING))
#define	broadcastCond(THING)	_broadcastCond((THING))

struct Hjava_lang_Thread;

typedef int	quickLock;
typedef struct _iLock {
	void*				address;
	struct _iLock*			next;
	int				ref;
	struct Hjava_lang_Thread*	holder;
	int				count;
	MUTEX_DECL			mux;
	CONDVAR_DECL			cv;
} iLock;

extern iLock*	getLock(void*);
extern void	freeLock(iLock*);
extern void	_lockMutex(void*);
extern void	_unlockMutex(void*);
extern int	_waitCond(void*, jlong);
extern void	_signalCond(void*);
extern void	_broadcastCond(void*);

#endif
