import java.net.*;
import java.io.*;
import java.util.*;

/**
 * HTTPServer class used for serving a new connection.
 */
public class HTTPServer
{
  /**
   * The constant index name string.
   */
  public final static String INDEX_FILE_NAME = "index.html";

  /**
   * The name and version of the http server.
   */
  public final static String SERVER_NAME = "StupidServer/1.0";
  
  /**
   * Instance variable holding the verbose mode flag.
   */
  public boolean verbose;

  /**
   * The socket for the new connection.
   */
  public Socket connection;
  
  /**
   * The constructor definition for HTTPServer class.
   */
  public HTTPServer(Socket connection_, boolean verbose_)
  {
    connection = connection_;
    verbose = verbose_;
  }
  
  /**
   * The run method for HTTPServer class.
   */
  public void serveConnection()
  {
    String methodName, contentType;
    String version = "";
    File requestedFile;
    File documentRoot = MainServer.documentRoot;
    
    if (verbose) 
      {
	System.out.println("Starting to serve the new request.");
      }
    try
      {
	DataOutputStream os = new DataOutputStream(connection.getOutputStream());
	BufferedReader is =
	  new BufferedReader(new InputStreamReader(connection.getInputStream()));
	
	String requestedMethod = is.readLine();
	StringTokenizer st = new StringTokenizer(requestedMethod);
	methodName = st.nextToken();
	
	if (methodName.equals("GET"))
	  {
	    if (verbose)
	      {
		System.out.println("Requested method: GET");
	      }
	    String requestedFileName = st.nextToken();
	    if (requestedFileName.endsWith("/"))
	      {
		requestedFileName += INDEX_FILE_NAME;
	      }
	    
	    contentType = guessContentTypeFromName(requestedFileName);
	    if (st.hasMoreTokens())
	      {
		version = st.nextToken();
	      }
	    
	    // ignore the rest of the input
	    while ((requestedMethod = is.readLine()) != null)
	      {
		if (requestedMethod.trim().equals(""))
		  {
		    break;
		  }
	      }
	    
	    try
	      {
		String fName =
		  requestedFileName.substring(1, requestedFileName.length());
		requestedFile = new File(documentRoot, fName);
		
		if (verbose)
		  {
		    System.out.println("Requested file: "+fName);
		  }

		FileInputStream fis = new FileInputStream(requestedFile);
		byte[] inputData = new byte[(int) requestedFile.length()];
		fis.read(inputData);
		fis.close();
		
		if (verbose)
		  {
		    System.out.println("Read requested file successfully");
		  }
		if (version.startsWith("HTTP/"))
		  {
		    os.writeBytes("HTTP/1.0 200 OK\r\n");
		    /*Date currentDate = new Date();
		    os.writeBytes("Date: " + currentDate"\r\n");*/
		    os.writeBytes("Server: " + SERVER_NAME + "\r\n");
		    os.writeBytes("Content-length: " + inputData.length + "\r\n");
		    os.writeBytes("Content-type: " + contentType + "\r\n\r\n");
		  }
		os.write(inputData);
		os.close();
	      }
	    catch (IOException e)
	      {
		if (version.startsWith("HTTP/"))
		  {
		    os.writeBytes("HTTP/1.0 404 File Not Found\r\n");
		    /*Date currentDate = new Date();
		    os.writeBytes("Date: " + currentDate + "\r\n");*/
		    os.writeBytes("Connection: close\r\n");
		    os.writeBytes("Server: " + SERVER_NAME + "\r\n");
		    os.writeBytes("Content-type: text/html\r\n\r\n");
		  }
		if (verbose)
		  {
		    System.out.println("Could not open the requested file.");
		  }
		os.writeBytes("<HTML><HEAD><TITLE>File Not Found</TITLE></HEAD>\n");
		os.writeBytes("<BODY><H1>HTTP Error 404: File Not Found</H1></BODY>"+
			      "</HTML>\n");
		os.close();
	      }
	  }
	else
	  {
	    if (version.startsWith("HTTP/"))
	      {
		os.writeBytes("HTTP/1.0 501 Not Implemented\r\n");
		/*Date currentDate = new Date();
		os.writeBytes("Date: " + currentDate + "\r\n");*/
		os.writeBytes("Connection: close\r\n");
		os.writeBytes("Server: " + SERVER_NAME + "\r\n");
		os.writeBytes("Content-type: text/html\r\n\r\n"); 
	      }    
	    if (verbose)
	      {
		System.out.println("The requested method not implemented.");
	      }
	    os.writeBytes("<HTML><HEAD><TITLE>Not Implemented</TITLE></HEAD>\n");
	    os.writeBytes("<BODY><H1>HTTP Error 501: Not Implemented</H1></BODY>"+
			  "</HTML>\n");
	    os.close();
	  }
      }
    catch (IOException e) {}
    
    try
      {
	connection.close();
      }
    catch (IOException e) {}
  }
  
  /**
   * Method for defining the content type on the basis of file name.
   *
   * @param name_    The file name upon which the content type is guessed.
   * @return String  The guessed content type string.
   */
  public String guessContentTypeFromName(String name_)
  {
    if (verbose)
      {
	System.out.println("Determining the content type from file name.");
      }
    if (name_.endsWith(".html") || name_.endsWith(".htm")) 
      {
	return "text/html";
      }
    else if (name_.endsWith(".txt") || name_.endsWith(".java"))
      {
	return "text/plain";
      }
    else if (name_.endsWith(".gif") )
      {
	return "image/gif";
      }
    else if (name_.endsWith(".class") )
      {
      return "application/octet-stream";
      }
    else if (name_.endsWith(".jpg") || name_.endsWith(".jpeg")) 
      {
	return "image/jpeg";
      }
    else 
      {
	return "text/plain";
      }
  }
}


