/*
 * files.h
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

/*** CHANGELOG
 *
 * 18.1.1998    Vesa Karpijoki   Added X_OK to access flags.
 *
 * 20.1.1998    Vesa Karpijoki   Redefined SYS_ERROR.
 *
 * 22.1.1998    Arttu Kuukankorpi  Changed ae:s in Vesa's last name to a:s,
 *                                 changed if !defined:s to ifndef:s
 *
 * 2.2.1998     Teemu Ikonen       removed some '#include's
 */

#ifndef __files_h
#define __files_h

#include "config.h"
#include "config-std.h"
#include "config-io.h"
#include <jtypes.h>

#define SYS_ERROR "System call error"

/* Define access() flags if not already defined */
#ifndef W_OK
#define X_OK            1
#define	W_OK		2
#define	R_OK		4
#endif

/* If we don't have O_BINARY, define it to be 0 */
#ifndef O_BINARY
#define	O_BINARY	0
#endif

/* Convert jlong's to and from off_t's */
#define	jlong2off_t(j)		((off_t)(j))
#define	off_t2jlong(j)		((jlong)(j))

#endif
