/* slib.h
 * Macro'ise the shared library calls to be 'portable'.
 *
 * Copyright (c) 1996-7 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.co.uk>
 */

#ifndef __slib_h
#define __slib_h

/* ------------------------------------------------------------------------ */

/*
 * If we don't have any shared library support, we use the buildin native
 * function tables.
 */
#undef	LIBRARYLOAD
#undef	LIBRARYFUNCTION
#undef	LIBRARYHANDLE
#undef	LIBRARYERROR

#define	LIBRARYLOAD(HAND, LIB)		1
#define	LIBRARYFUNCTION(FUNC, STUB)					\
	do {								\
		int z;							\
		FUNC = 0;						\
		for (z = 0; native_funcs[z].name != 0; z++) {		\
			if (strcmp(native_funcs[z].name, STUB) == 0) {	\
				FUNC = native_funcs[z].func;		\
				break;					\
			}						\
		}							\
	} while (0)
#define	LIBRARYHANDLE			int
#define	LIBRARYERROR()			"No shared library support"

/* ------------------------------------------------------------------------ */

#endif
