/*
 * stackTrace.h
 *
 * Copyright (c) 1996,97 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Peter Nagy <tegla@katalin.csoma.elte.hu>
 */

#ifndef __stacktrace_h
#define __stacktrace_h

#include "exception.h"

#if defined(INTERPRETER)

typedef struct _stackTrace {
	vmException* frame;
} stackTrace;

#define STACKTRACEINIT(stacktrace,init,o) ((stacktrace).frame = TCTX(currentThread)->exceptPtr)

#define STACKTRACESTEP(stacktrace)	((stacktrace).frame = (stacktrace).frame->prev)
#define STACKTRACEPC(stacktrace)	((stacktrace).frame->pc)
#define STACKTRACEMETH(stacktrace)	((stacktrace).frame->meth)
#define STACKTRACEEND(stacktrace)	((stacktrace).frame == 0)

#elif defined(TRANSLATOR)

typedef struct _stackTrace {
	struct _exceptionFrame	nframe;
	struct _exceptionFrame* frame;
} stackTrace;

#define STACKTRACEINIT(stacktrace, init, o)				\
	{								\
		if ((init)==NULL) {					\
			FIRSTFRAME((stacktrace).nframe, o);		\
			(stacktrace).frame = &((stacktrace).nframe);	\
		} else {						\
			(stacktrace).frame = init;			\
		}							\
	}

#define	STACKTRACESTEP(stacktrace)	(NEXTFRAME((stacktrace).frame))
#define STACKTRACEPC(stacktrace)	(PCFRAME((stacktrace).frame))
#define	STACKTRACEMETH(stacktrace)	(findMethodFromPC(PCFRAME((stacktrace).frame)))
#define	STACKTRACEEND(stacktrace)	(!FRAMEOKAY((stacktrace).frame))

#endif

Hjava_lang_Object*	buildStackTrace(struct _exceptionFrame* base);
Hjava_lang_Object*	getClassContext(void* bulk);
Hjava_lang_Class*	getClassWithLoader(int* depth);
jint			classDepth(char* name);

#endif
