/* Output from p2c, the Pascal-to-C translator */
/* From input file "tp_debug.pas" */

#define TP_DEBUG_G
#include "tp_debug.h"

#ifndef TP_DECL_H
#include "tp_decl.h"
#endif
#ifndef TP_MISC_H
#include "tp_misc.h"
#endif

#include <stdlib.h>

/********************************************************/
void WriteDebugInfo(Instring)
Char *Instring;
{
  /********************************************************/
  if (!Debug)
    return;
  switch (DebugOut) {

  case SCREEN:
#ifdef __TURBOC__
    cprintf("%s\r\n",Instring);
#endif
#ifndef __TURBOC__
	printf("%s\r\n",Instring);
#endif
    break;

  case DEBFILE:
    fprintf(DebugFile, "%s\n", Instring);
    break;

  case PRINT:
#ifdef __TURBOC__
    cprintf("%s\r\n",Instring);
#endif
#ifndef __TURBOC__
	printf("%s\r\n",Instring);
#endif
    break;
  }
}


/********************************************/
void Help(void)
{
  /********************************************/
  /* WriteLn('A correct call to Midi2TeX looks like this :'); */
  printf("\n    MIDI2TEX midifilename [TeXfilename] [-option1] [-option2] ...\r\n\n");
  printf("Switch -s suppresses note generation for tracks #\n");
  printf("Switch -o determines order of tracks to display on staffs (up-down)\n\r");
  printf("Switch -b assigns the bass clef to staff # (counted from top to bottom)\n\r");
  printf("Switch -a1..-a5 assign the alto clefs to staff # (from top to bottom)\n\r");
  printf("Switch -i assigns 2 or more staffs to one instrument\n\r");
  printf("Switch -q determines the quantization note time, 1,2,4,8,16,32,64,128\n\r");
  printf("Switch -p redefines the part time, (default a quarter note)\n\r");
  printf("Switch -f forces the slopes of the beams to be zero\n\r");
  printf("Switch -h changes the horizontal size of the score [1600  *0.1mm]\n\r");
  printf("Switch -v changes the vertical size of the score [2400 *0.1mm]\n\r");
  printf("Switch -m select music size [20,16]\n\r");
  printf("Switch -e change \\elemskip value (in pt)\n\r");
#ifdef ST
  printf("Switch -x skips wait for key hit at end of program\n\r");
#endif
  printf("Switch -d@ switches on debugging info, @ can be any of the following :\n\r");
  printf(" NONE    : no debugging,             SCREEN  : debug info to the screen\n\r");
  printf(" PRINTER : debug info to the printer,   FILE : debug info to a file\n\r");
#ifdef __unix
  printf("Switch -H displays this help message\n\r");
#else
  printf("Switch -? displays this help message\n\r");
#endif
}


/********************************/
void ToBothEr(S)
Char *S;
{
  /********************************/
  Char STR1[256];

  sprintf(STR1, "Fatal error: %s", S);
  WriteDebugInfo(STR1);
  printf("\n\rFatal error:%s\n\r", S);
}


/********************************/
void Warning(S)
Char *S;
{
  /********************************/
  Char STR1[256];

  sprintf(STR1, "Warning:%s", S);
  WriteDebugInfo(STR1);
  printf("Warning:%s\n\r", S);
}


/********************************************/
void ErrorExit(errorcode)
long errorcode;
{
  /********************************************/
  Char STR3[256];

  switch (errorcode) {

  case 0:
    Help();
    break;

  case 1:
    ToBothEr(" No input file specified, or file does not exist ");
    break;

  case 3:
    sprintf(STR3, " MidiFile track %i is not ok", (int)CurTrack);
    ToBothEr(STR3);
    break;

  case 4:
    ToBothEr(" Found a NoteOff without a NoteOn");
    break;

  case 5:
    ToBothEr(" Can only translate MIDI files of type 1, sorry...");
    break;

  case 6:
    ToBothEr(" Nil pointer detected in NoteOff search");
    break;

  case 7:
    ToBothEr(
      " No. of order indices does not correspond with No. of tracks in file");
    break;

  case 8:
    ToBothEr(
      " Staffindex out of range, you tried to change a staff attribute which I cannot handle");
    break;

  case 9:
    ToBothEr(" Heap exhausted during initializing memory");
    break;

  case 10:
    ToBothEr(
      " The noteheap appeared to be empty during a note request to the noteheap");
    break;

  case 11:
    ToBothEr(" A note value exceeded 127, probably a program bug");
    break;

  case 12:
    ToBothEr(" Invalid PartTime entered, only one of 1,2,4,8,16,32 allowed");
    break;

  case 13:
#ifdef __unix
    ToBothEr(" Invalid quantization time entered, use switch -H to get proper range");
#else
    ToBothEr(" Invalid quantization time entered, use switch -? to get proper range");
#endif
    break;

  case 14:
    ToBothEr(" Can only define one multi-staff instrument in this version");
    break;

  case 15:
    ToBothEr(" Definition of an instrument of one track is useless");
    break;

  case 16:
    ToBothEr(" The Slurr-array is exhausted, too many slurrs (9) for MusicTeX");
    break;

  case 17:
    ToBothEr(" Process terminated by user ");
    break;

  case 18:
    ToBothEr(" The Beam-array is exhausted, too many beams (9) for MusicTeX");
    break;

  case 19:
    ToBothEr(" -h,-v,-m and -k option can only take one parameter");
    break;

  case 20:
    ToBothEr(" -m option parameter must be either 20 or 16");
    break;

  case 21:
    ToBothEr(" -k option parameter must be between -8 and 8");
    break;

  case 22:
    ToBothEr(" -a1..-a5 option parameter is not correct");
    break;

  case 23:
    ToBothEr(" -s option parameter is not correct");
    break;

  case 24:
    ToBothEr(" Unexpected end of MIDI file reached, file corrupted ?");
    break;

  case 25:
    ToBothEr(" Unable to open output file ");
    break;

  case 89:
    ToBothEr("tot en met i gekomen");
    break;
    
  default:
    ToBothEr(" Unknown error , either a corrupted midi file or a bug..");
    break;
  }
  WriteDebugInfo("Program Terminated");
  switch (errorcode) {

  case 1:
  case 7:
  case 8:
  case 12:
  case 13:
  case 14:
  case 15:
#ifdef __unix
    printf("Run program with switch -? to get additional help\n\r");
#else
    printf("Run program with switch -H to get additional help\n\r");
#endif
    break;

  default:
    if (MidiFileOpened) {
      fprintf(TexFile,
	"%%MIDI2TeX file processing aborted due to a non-run time error\n\r");
      fprintf(TexFile, "\\finmorceau\n\r");
      fprintf(TexFile, "\\bye\n\r");
    }
    break;
  }
  /* _Escape(0); */
  exit(0);
}  /* ErrorExit */


void _TP_debug_init()
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}
/* p2c: Note: Remember to call _TP_debug_init() in main program [215] */
/* End. */
