.TH HETRO 1Csound "7 Feb 1991"
.SH NAME
hetro \- hetrodyne filter analysis for Csound \fIadsyn\fR module
.SH SYNOPSIS
.B hetro 
[flags] infilename outfilename
.SH DESCRIPTION
.I hetro
takes an input monaural soundfile, decomposes it into a set of
harmonically related sine waves with time-varying amplitude and phase,
and outputs the components in breakpoint form.
The method requires an estimate of the fundamental frequency.
Analysis is conditioned by the control flags below.
A space is optional between a flag and its value.
.TP 13
-s<srate>
sampling rate of the audio input file.  The default is 20000.
.TP 13
-b<begin>
beginning time (in seconds) of the audio segment to be analyzed.
The default is 0.0
.TP 13
-d<duration>
duration (in seconds) of the audio segment to be analyzed.
The default of 0.0 means to the end of file.  Maximum is 32.766 secs.
.TP 13
-f<begfreq>
estimated starting frequency of the fundamental, necessary to
initialize the filter analysis.  The default is 100 cps.
.TP 13
-h<partials>
number of harmonic partials sought in the audio file.
The default is 10.  Maximum is 50.
.TP 13
-M<maxamp>
maximum amplitude summed across all concurrent tracks.
The default is 32767.
.TP 13
-m<minamp>
amplitude threshold below which a track is dormant and will not contribute
to output summation.  Typical values are: 128 (48 dB down from full scale),
64 (54 dB down), 32 (60 dB down), 0 (no thresholding).  The default is 32.
.TP 13
-n<brkpts>
initial number of analysis breakpoints in each amplitude and frequency track,
prior to thresholding (-m) and standard data reduction.  The initial points
are spread evenly over the duration.  The default is 256.
.TP 13
-l<cutfreq>
substitute a 3rd order Butterworth low-pass filter with this cutoff frequency (cps),
in place of the default averaging comb filter.  The default is 0 (don't use).
.SH EXAMPLE
hetro -s44100 -b.5 -d2.5 -h16 -M24000 audiofile adsynfile7
.sp
This will analyze 2.5 seconds of a file "audiofile", recorded at
44100 Herz, beginning .5 seconds from the start, and place the result in
a file "adsynfile7".  We request just the first 16 harmonics, with 256
initial breakpoint values per amplitude and frequency track, and a peak
summation amp of 24000.  The fundamental is estimated to begin at 100 Hz.
Amplitude thresholding is at 60 dB down.  The Butterworth LPF is not enabled.
.SH FILE FORMAT
The output file contains time-sequenced amplitude and frequency values for
each partial of an additive complex tone.  The information is in the form of
breakpoints (time, value, time, value, .....) using 16-bit integers in the range
0 - 32767.  Time is given in milliseconds, and frequency in Hertz (cps).
The breakpoint data is exclusively non-negative, and the values -1 and -2
uniquely signify the start of new amplitude and frequency tracks.  A track is
terminated by the value 32767.  Before being written out, each track is
data-reduced by amplitude thresholding and breakpoint consolidation.
.SH "SEE ALSO"
Csound(1Csound),
.I "The Csound Reference Manual"
.SH BUGS
Currently reads only 16-bit integer format soundfiles (no header).

