c#rdrec.f     srs     v1.2     apr 81  
	subroutine rdrec(iun,ifmt,iend,an,rn,nr,x,d)
c
c	This routine reads one atom record from a
c	formatted coordinate file. The format types 
c	available are listed in the comment section of
c	FTCHUZ.
c
c	v1.2 : input reads are done in free format to
c		provide a wider compatabiliy with variants
c		of the format types.
c
c	Arguments are as follows:
c
c	IUN ... logical unit number for read
c	IEND .. end of file flag. Usually IEND = 0
c		but set to 1 if end of file or
c		terminator record encountered.
c	IFMT .. format designator. see FTCHUZ
c	AN .... atom name; a character*4 variable
c	RN .... residue name; character*4
c	NR .... residue number
c	X ..... x,y,z ; atomic coordinate
c	D ..... up to two associated parameters
c
c*******************************************************
c&
	dimension x(3),d(2)
	character*4 an,rn,oldrna,atom,resu,last,atom2,last1
	character*1 onelet
	character*80 list
	character*4 alist
	integer oldrnu
	equivalence (alist,list)
	data atom,resu,last,last1/'atom','RESI','end','END'/
	data atom2/'ATOM'/
c
	d(1) = 0.0
	d(2) = 1.0
	iend = 0
c
	go to (10,20,30,40,50,60),ifmt
c
c ****  PDB format
10	read(iun,1,end=500,err=10)oldrna,in,an,rn,nr,x,d
	if( oldrna .ne. atom .and.
     .      oldrna .ne. 'ATOM' .and.
     .      oldrna .ne. 'ATOM2' .and.
     .	    oldrna .ne. atom2 .and.
     .	    oldrna .ne. 'heta' .and.
     .      oldrna .ne. 'HETA') go to 10
	return
c ****  KRAUT format
20	read(iun,3,end=500)list
	if( alist .eq. resu) go to 25
	if( alist .eq. last) go to 500
	if( alist .eq. last1) go to 500
	if( alist .ne. atom2) go to 600
	read(list,4)an,x,d(1),an,nr
	return
25	read(list,5)rn,nr
	go to 20
c ****  DIAMOND format
30	read(iun,6,end=500)x,d(1),idw,nr,no,d(2),rn,an
	if (no .le. 0) go to 500
c
	return
c ****  HENDRICKSON format
40	read(iun,7,end=500)ichain,rn,onelet,nr,an,x,d(2),d(1)
	if(nr .eq. 999) go to 500
	return
c
c ****  FROM HENDRICKSON format
60 	read(iun,8,end=500) onelet,nr,an,x,d(2),d(1)      
	if(onelet.eq.' ') go to 500
	call recode(rn,onelet)
	if(an.eq.'OT ') an='OXT'
	return
c
500	iend = 1
	print *,'end of file encountered'
	return
c
600	print *,'(" wild card found in KRAUT file:",a4)', alist
	stop
700	print *,'(" wild card found in PDB file:",a4)', oldrna
	stop
c
50	print *,' SHAPLEY fmt is not supposed to be read '
	stop
c
1	format(a4,2x,i5,2x,2a4,1x,i4,4x,3f8.3,2f6.2)
3	format(a80)
4	format(9x,a4,3f8.4,f6.2,a4,i4)
5	format(8x,a4,i4)
6	format(4f10.5,3i5,f9.4,1x,a4,6x,a4)
7	format(i2,1x,a3,1x,a1,i3,a4,5f10.5)
8	format(7x,a1,i3,a4,5f10.3)
	end
