/* Inclusion des fichiers header  						    */

# include<genlib.h>
# include<stdio.h>
# include<ctype.h>
# include<string.h>
# include<math.h>


/* definition des constantes     						    */

#define TRUE  		(1)		/* valeur booleenne VRAI		    */
#define FALSE 		(0)		/* valeur booleenne FAUX		    */


/* definition des variables externes globales                                       */

extern int step,step1,step2;	/* pas de pipeline				    */
extern long N,M;		/* Taille des operandes				    */
extern char	*name;		/* nom du bloc genere				    */
extern int 	t0,t1,n;	/* Parametres pour l'emplacement du pipeline	    */

/************************************************************************/
/* 			genere le vhdl comportemental			*/
/************************************************************************/
void vhdlpack ()
{
int i,j,k,l;			/* indices de boucles			*/
int n_pipe=0;			/* nombre total de bancs de registres	*/
FILE *f;			/* descripteur du fichier .vbe		*/
char fvbe [16];			/* nom du fichier.vbe			*/
char *name_bloc;		/* nom de bloc				*/

n_pipe=t0+t1+n;			/* calcul du nombre couche de regstres  */
name_bloc=mbkstrdup(name);	/* duplication du nom pour fvbe  	*/
strcpy (fvbe,name_bloc);	/* affectation du nom de bloc a fvbe	*/
strcat (fvbe,".vbe");	        /* rajout de .vbe a fvbe		*/
f=fopen(fvbe,"w");
fprintf(f, "entity %s is\n\n",name);
fprintf(f,"PORT(	A : in  bit_vector(0 to %d);		\n",M-1);
fprintf(f,"		B : in  bit_vector(0 to %d);		\n",N-1);
if ( n_pipe != 0 )
	{
	fprintf(f,"		ck	: in  bit;		\n");
	fprintf(f,"		scanin	: in  bit;		\n");
	fprintf(f,"		scanout : out bit;		\n");
	fprintf(f,"		sd	: in  bit;		\n");
	fprintf(f,"		st	: in  bit;		\n");
	}
fprintf(f,"		P : out bit_vector(0 to %d);		\n",N-1+M);
fprintf(f,"		vss : in  bit;				\n");
fprintf(f,"		vdd : in  bit				\n");
fprintf(f,"		);					\n");
fprintf(f,"\n");
fprintf(f,"end %s;\n",name);

fprintf(f,"architecture comportementale of %s is\n\n",name);


fprintf(f,"signal	T	: bit_vector(0 to %d);\n",N-1+M);
fprintf(f,"signal	N,D,C	: bit_vector(0 to %d);\n",N/2-1);
fprintf(f,"signal	I1,I2	: bit_vector(0 to %d);\n",N-1);
fprintf(f,"signal	RC	: bit_vector(0 to %d);\n",M-1);
fprintf(f,"signal	I3	: bit_vector(0 to %d);\n",N);

for (i=1; i<N/2+1; i++)
fprintf(f,"signal	V%d	: bit_vector(0 to %d);\n",2*i-1,M);

for (j=2; j<N/2+1; j++)
{
	fprintf(f,"signal	R%d	: bit_vector(0 to %d);\n",2*j-1,M);
	fprintf(f,"signal	M%d	: bit_vector(0 to %d);\n",2*j-1,M);
}

/***	DECLARATION DES SIGNAUX INTERMEDIAIRES DES REGISTRES ***/
for (i=1; i<n_pipe+1; i++)
fprintf(f,"signal	Q%d	: reg_vector (0 to %d) register;\n",i,M+N-1);

fprintf(f,"\n");
fprintf(f,"begin\n\n");

fprintf(f,"n(0) <= (not(b(1))) and (not(b(0)));\n");
fprintf(f,"d(0) <= b(1) and (not(b(0)));\n");
fprintf(f,"c(0) <= b(1);\n\n");

for (k=1; k<N/2; k++)
{
fprintf(f,"n(%d) <= (b(%d) and b(%d) and b(%d)) or ((not(b(%d))) and (not(b(%d))) and (not(b(%d))));\n",k,2*k+1,2*k,2*k-1,2*k+1,2*k,2*k-1);
fprintf(f,"d(%d) <= ((not(b(%d))) and b(%d) and b(%d)) or (b(%d) and (not(b(%d))) and (not(b(%d))));\n",k,2*k+1,2*k,2*k-1,2*k+1,2*k,2*k-1);
fprintf(f,"c(%d) <= b(%d) and ((not(b(%d))) or (not(b(%d))));\n\n",k,2*k+1,2*k,2*k-1);
}
fprintf(f,"\n");
fprintf(f,"-----------------------------------------------------------------------\n");

fprintf(f,"etage1:block\n\n");

fprintf(f,"begin\n\n");

fprintf(f,"with N(0)&D(0)&C(0) select\n");
fprintf(f,"V1(0 to %d)<=not(A(0 to %d))&not(A(%d)) when \"001\",\n",M,M-1,M-1);
fprintf(f,"'0'&A(0 to %d) when \"010\",\n",M-1);
fprintf(f,"'1'&not(A(0 to %d)) when \"011\",\n",M-1);
fprintf(f,"A(0 to %d)&A(%d) when \"000\",\n",M-1,M-1);

fprintf(f,"\"");
for (k=0; k<M+1; k++)
{
	fprintf(f,"0");
}

fprintf(f,"\" when others;\n");
fprintf(f,"end block etage1;\n");
 
fprintf(f,"-----------------------------------------------------------------------\n");

fprintf(f,"etage2:block\n");
fprintf(f,"begin\n\n");

fprintf(f," with N(1)&D(1)&C(1) select\n");
fprintf(f,"M3(0 to %d)<=not(A(0 to %d))&not(A(%d)) when \"001\",\n",M,M-1,M-1);
fprintf(f,"'0'&A(0 to %d) when \"010\",\n",M-1);
fprintf(f,"'1'&not(A(0 to %d)) when \"011\",\n",M-1);
fprintf(f,"A(0 to %d)&A(%d) when \"000\",\n",M-1,M-1);
 
fprintf(f,"\"");
for (k=0; k<M+1; k++)
{
	fprintf(f,"0");
}

fprintf(f,"\" when others;\n");

fprintf(f,"V3(0 to %d)<=M3(0 to %d) xor V1(2 to %d);\n",M-2,M-2,M);
fprintf(f,"V3(%d to %d)<=M3(%d to %d) xor V1(%d)&V1(%d);\n",M-1,M,M-1,M,M,M);
 
fprintf(f,"R3(0 to %d)<=M3(0 to %d) and V1(2 to %d);\n",M-2,M-2,M);
fprintf(f,"R3(%d to %d)<=M3(%d to %d) and V1(%d)&V1(%d);\n",M-1,M,M-1,M,M,M);
 
fprintf(f,"end block etage2;\n");
for (k=3; k<N/2+1; k++)
{
fprintf(f,"-----------------------------------------------------------------------\n");
fprintf(f,"etage%d:block\n",k);     
fprintf(f,"begin\n\n");
 
fprintf(f,"with N(%d)&D(%d)&C(%d) select\n",k-1,k-1,k-1);
fprintf(f,"M%d(0 to %d)<=not(A(0 to %d))&not(A(%d)) when \"001\",\n",2*k-1,M,M-1,M-1);
fprintf(f,"'0'&A(0 to %d) when \"010\",\n",M-1);
fprintf(f,"'1'&not(A(0 to %d)) when \"011\",\n",M-1);
fprintf(f,"A(0 to %d)&A(%d) when \"000\",\n",M-1,M-1);

fprintf(f,"\"");
for (j=0; j<M+1; j++)
{
	fprintf(f,"0");
}

fprintf(f,"\" when others;\n");
 
fprintf(f,"V%d(0 to %d)<=M%d(0 to %d) xor V%d(2 to %d) xor R%d(1 to %d);\n",2*k-1,M-2,2*k-1,M-2,2*k-3,M,2*k-3,M-1);
fprintf(f,"V%d(%d to %d)<=M%d(%d to %d) xor V%d(%d)&V%d(%d) xor R%d(%d)&R%d(%d);\n",2*k-1,M-1,M,2*k-1,M-1,M,2*k-3,M,2*k-3,M,2*k-3,M,2*k-3,M);
fprintf(f,"R%d(0 to %d)<=(M%d(0 to %d) and V%d(2 to %d)) or (R%d(1 to %d) and (V%d(2 to %d) or M%d(0 to %d)));\n",2*k-1,M-2,2*k-1,M-2,2*k-3,M,2*k-3,M-1,2*k-3,M,2*k-1,M-2);
fprintf(f,"R%d(%d to %d)<=(M%d(%d to %d) and V%d(%d)&V%d(%d)) or (R%d(%d)&R%d(%d) and (V%d(%d)&V%d(%d) or M%d(%d to %d)));\n",2*k-1,M-1,M,2*k-1,M-1,M,2*k-3,M,2*k-3,M,2*k-3,M,2*k-3,M,2*k-3,M,2*k-3,M,2*k-1,M-1,M);
 
fprintf(f,"end block etage%d;\n",k);
}
fprintf(f,"------------------------------------------------------------------------\n");
fprintf(f,"final:block\n");
fprintf(f,"begin\n");
 
fprintf(f,"I1(0) <= C(0);\n");
fprintf(f,"I1(1) <= \"0\";\n");
for (k=1; k<N/2; k++)
{
fprintf(f,"I1(%d) <= C(%d);\n",2*k,k);
fprintf(f,"I1(%d) <= R%d(0);\n",2*k+1,2*k+1);
}
fprintf(f,"\n");
for (k=0; k<N/2; k++)
{
fprintf(f,"I2(%d) <= V%d(0);\n",2*k,2*k+1);
fprintf(f,"I2(%d) <= V%d(1);\n",2*k+1,2*k+1);
}
fprintf(f,"end block final;\n");
fprintf(f,"--------------------------------------------------------------------------------\n");
fprintf(f,"BPF:block\n");
 
fprintf(f,"begin\n\n");
 
fprintf(f,"I3(0) <= \"0\";\n");
fprintf(f,"T(0 to %d) <= I1(0 to %d) xor I2(0 to %d) xor I3(0 to %d);\n",N-1,N-1,N-1,N-1);
fprintf(f,"I3(1 to %d) <= (I1(0 to %d) and I2(0 to %d)) or (I3(0 to %d) and (I1(0 to %d) or I2(0 to %d)));\n",N,N-1,N-1,N-1,N-1,N-1);
 
fprintf(f,"end block BPF;\n");
 
fprintf(f,"---------------------------------------------------------------------------------\n");
 
fprintf(f,"CLA:block\n");
 
fprintf(f,"begin\n\n");
 
fprintf(f,"RC(0) <= I3(%d);\n",N);
fprintf(f,"T(%d to %d) <= V%d(2 to %d) xor R%d(1 to %d) xor RC(0 to %d);\n",N,N+M-2,N-1,M,N-1,M-1,M-2);
fprintf(f,"RC(1 to %d) <= (V%d(2 to %d) and R%d(1 to %d)) or (RC(0 to %d) and (V%d(2 to %d) or R%d(1 to %d)));\n",M-1,N-1,M,N-1,M-1,M-2,N-1,M,N-1,M-1);
fprintf(f,"T(%d) <= RC(%d) xor R%d(%d) xor V%d(%d);\n",N+M-1,M-1,N-1,M,N-1,M);
 

fprintf(f,"end block CLA;\n");
 
fprintf(f,"---------------------------------------------------------------------------------\n");
 
if ( n_pipe == 0 ) fprintf(f,"P(0 to %d)<=T(0 to %d);\n\n",N+M-1,N+M-1);

else     /* on place des registres a decalage */
	{
	fprintf (f,	"registre1: BLOCK (ck='0' and not ck'stable)		\n");
	fprintf (f,	"		BEGIN					\n");
	fprintf (f,	"		Q1 (0 to %d) <= guarded T (0 to %d);	\n",N+M-1,N+M-1);
	fprintf (f,	"		end BLOCK registre1;			\n\n");
	for (i=2;i<n_pipe+1;i++)
		{
		fprintf (f,	"registre%d: BLOCK (ck='0' and not ck'stable)		\n",i);
		fprintf (f,	"		BEGIN					\n");
		fprintf (f,	"		Q%d (0 to %d) <= guarded Q%d (0 to %d);	\n",i,N+M-1,i-1,N+M-1);
		fprintf (f,	"		end BLOCK registre%d;		\n\n",i);
		}
	fprintf (f,	"P (0 to %d) <= Q%d (0 to %d);	\n\n\n",N+M-1,n_pipe,N+M-1);
	}


fprintf(f,"end;\n");
fclose(f);
}
/*_______________________________________________________________________*/
