/* ###--------------------------------------------------------------### */
/*									*/
/* file		: beh_debug.c						*/
/* date		: Sep   3 1993						*/
/* version	: v106							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* description	: high level function					*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include MUT_H
#include LOG_H
#include BEH_H

struct typoin				/* structure used by beh_debug	*/
  {					/* to store its state		*/
  short  type;				/* code of current structure	*/
  short  mark;				/* stop mark			*/
  void  *data;				/* pointer of the structure	*/
  };

#define BEH_STKSIZ	   200		/* stack size			*/

#define BEH_errorDFN      -1		/* unknown     command		*/

#define BEH__setDFN        1		/* _set        command		*/
#define BEH__upDFN         2		/* _up         command		*/
#define BEH__topDFN        3		/* _top        command		*/
#define BEH__stopDFN       4		/* _stop       command		*/
#define BEH__backDFN       5		/* _back       command		*/
#define BEH__exitDFN       6		/* _exit       command		*/

#define BEH_befigDFN       7		/* befig       command		*/
#define BEH_beregDFN       8		/* bereg       command		*/
#define BEH_bemsgDFN       9		/* bemsg       command		*/
#define BEH_berinDFN      10		/* berin       command		*/
#define BEH_beoutDFN      11		/* beout       command		*/
#define BEH_bebusDFN      12		/* bebus       command		*/
#define BEH_beauxDFN      13		/* beaux       command		*/
#define BEH_bebuxDFN      14		/* beaux       command		*/
#define BEH_beporDFN      15		/* bepor       command		*/
#define BEH_biablDFN      16		/* biabl       command		*/
#define BEH_binodeDFN     17		/* binode      command		*/
#define BEH_begenDFN      18		/* begen       command		*/

#define BEH_nextDFN       19		/* next        command		*/
#define BEH_userDFN       20		/* user        command		*/
#define BEH_ptypeDFN      21		/* ptype       command		*/

#define BEH_dataDFN       22		/* data        command		*/
#define BEH_levelDFN      23		/* level       command		*/
#define BEH_typeDFN       24		/* type        command		*/
#define BEH_directionDFN  25		/* direction   command		*/

#define BEH_bedlyDFN      26		/* bedly       command		*/

#define BEH_MAXDFN        27		/* number of command understood	*/

extern        char  *exprToCharInt();
extern struct chain *bddToAbl();

/* ###--------------------------------------------------------------### */
/* function	: vhd_hash						*/
/* description	: hash function						*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static int vhd_hash (str)

char *str;				/* string to be hashed		*/

  {
  char c;
  int code = 0;

  while(*str != '\0')
    {
    c    = *str - 'A' + 'a';
    code =  code<<1 ^ c;
    str++;
    }

  if (code < 0)
    code = -code;

  return (code);
  }

/* ###--------------------------------------------------------------### */
/* function	: vhd_getcmd						*/
/* description	: reads a command from standard input and return its	*/
/*		  position in the commands' table			*/
/* called func.	: vhd_hash						*/
/* ###--------------------------------------------------------------### */

static int vhd_getcmd (prvcmd)

char prvcmd[3][20];		/* last command read from input		*/

  {
  char readstr[60];
  char comd0[20];
  char comd1[20];
  char comd2[20];
  int  code;

  printf ("\n\n\n COMMAND >> ");
  comd0[0] = '\0';
  comd1[0] = '\0';
  comd2[0] = '\0';
  gets   (readstr);
  sscanf (readstr,"%s%s%s",comd0,comd1,comd2);

  if (strcmp(comd0,"."))
    {
    strcpy (prvcmd[0], comd0);
    strcpy (prvcmd[1], comd1);
    strcpy (prvcmd[2], comd2);
    }
  code = vhd_hash (prvcmd[0]);

  printf ("\n\n\n\n\n");
  return (code);
  }

/* ###--------------------------------------------------------------### */
/* function	: beh_debug						*/
/* description	: beh structures displayer-debugger			*/
/* called func.	: vhd_hash     , mbkalloc, vhd_getcmd, bddToAbl,	*/
/*		  exprToCharInt, mbkfree				*/
/* ###--------------------------------------------------------------### */

void beh_debug (head_pnt,stru_name)

void  *head_pnt;		/* pointer of the struc. to be displayed*/
char  *stru_name;		/* name of the struc. to be displayed	*/

  {

  char          *buffer=NULL;
  unsigned int   buff_size = 100;
  int		 key[BEH_MAXDFN];
  char		*tab[BEH_MAXDFN];
  void		*nxt[BEH_MAXDFN];
  short		 typ[BEH_MAXDFN];

  int		 i;
  int		 state;
  int		 newsta0;
  int		 newsta1;
  int		 readcmd = 0;
  char		 readtab[3][20];
  int		 stk_pnt = 0;
  int            type = BEH__exitDFN;

  struct chain	*ptr_abl;

  struct ptype	*pty_pnt;

  struct befig	*bef_pnt;
  struct bereg	*ber_pnt;
  struct bemsg	*bem_pnt;
  struct beout	*beo_pnt;
  struct bebus	*beb_pnt;
  struct beaux	*bex_pnt;
  struct bebux	*bbx_pnt;
  struct bepor	*bep_pnt;
  struct begen	*beg_pnt;
  struct biabl	*bbl_pnt;
  struct binode	*bnd_pnt;
  struct berin	*bei_pnt;

  struct circuit *cct_pnt;

  struct typoin  cur_pnt;
  struct typoin  stk[BEH_STKSIZ];

  char           empty[4];
  char           avail[12];

  buffer  = mbkalloc (buff_size);

  strcpy (empty,"");
  strcpy (avail,"AVAILABLE");

  key[BEH__setDFN]      = vhd_hash ("_set");
  key[BEH__upDFN]       = vhd_hash ("_up");
  key[BEH__topDFN]      = vhd_hash ("_top");
  key[BEH__stopDFN]     = vhd_hash ("_stop");
  key[BEH__backDFN]     = vhd_hash ("_back");
  key[BEH__exitDFN]     = vhd_hash ("_exit");
  key[BEH_befigDFN]     = vhd_hash ("befig");
  key[BEH_beregDFN]     = vhd_hash ("bereg");
  key[BEH_bemsgDFN]     = vhd_hash ("bemsg");
  key[BEH_berinDFN]     = vhd_hash ("berin");
  key[BEH_beoutDFN]     = vhd_hash ("beout");
  key[BEH_bebusDFN]     = vhd_hash ("bebus");
  key[BEH_beauxDFN]     = vhd_hash ("beaux");
  key[BEH_bedlyDFN]     = vhd_hash ("bedly");
  key[BEH_bebuxDFN]     = vhd_hash ("bebux");
  key[BEH_beporDFN]     = vhd_hash ("bepor");
  key[BEH_biablDFN]     = vhd_hash ("biabl");
  key[BEH_binodeDFN]    = vhd_hash ("binode");
  key[BEH_begenDFN]     = vhd_hash ("begen");
  key[BEH_nextDFN]      = vhd_hash ("next");
  key[BEH_userDFN]      = vhd_hash ("user");
  key[BEH_ptypeDFN]     = vhd_hash ("ptype");
  key[BEH_dataDFN]      = vhd_hash ("data");
  key[BEH_levelDFN]     = vhd_hash ("level");
  key[BEH_typeDFN]      = vhd_hash ("type");
  key[BEH_directionDFN] = vhd_hash ("direction");

  readcmd = vhd_hash (stru_name);
  for (i=0 ; i<BEH_MAXDFN ; i++)
    {
    if (readcmd == key[i])
      {
      type = i;
      break;
      }
    }
  if (head_pnt == NULL)
    type = BEH__exitDFN;
  cur_pnt.data = head_pnt;
  cur_pnt.type = type;
  state        = type;

  while (state != BEH__exitDFN)
    {

    for (i=0 ; i<BEH_MAXDFN ; i++)
      {
      tab[i] = empty;
      nxt[i] = NULL;
      typ[i] = i;
      }

    tab[BEH__exitDFN] = avail;
    tab[BEH__setDFN] = avail;
    tab[BEH__stopDFN] = avail;

    if (stk_pnt != 0)
      {
      tab[BEH__upDFN] = avail;
      tab[BEH__topDFN] = avail;
      tab[BEH__backDFN] = avail;
      }

    switch (state)
      {
      case (BEH_befigDFN):

	/* ###------------------------------------------------------### */
	/*			BEFIG					*/
	/* ###------------------------------------------------------### */

        bef_pnt = (struct befig *)(cur_pnt.data);

        if (bef_pnt->BEREG != NULL)
          {
          tab[BEH_beregDFN] = avail;
          nxt[BEH_beregDFN] = (void *)bef_pnt->BEREG;
          typ[BEH_beregDFN] = BEH_beregDFN;
          }
        if (bef_pnt->BEMSG != NULL)
          {
          tab[BEH_bemsgDFN] = avail;
          nxt[BEH_bemsgDFN] = (void *)bef_pnt->BEMSG;
          typ[BEH_bemsgDFN] = BEH_bemsgDFN;
          }
        if (bef_pnt->BERIN != NULL)
          {
          tab[BEH_berinDFN] = avail;
          nxt[BEH_berinDFN] = (void *)bef_pnt->BERIN;
          typ[BEH_berinDFN] = BEH_berinDFN;
          }
        if (bef_pnt->BEOUT != NULL)
          {
          tab[BEH_beoutDFN] = avail;
          nxt[BEH_beoutDFN] = (void *)bef_pnt->BEOUT;
          typ[BEH_beoutDFN] = BEH_beoutDFN;
          }
        if (bef_pnt->BEBUS != NULL)
          {
          tab[BEH_bebusDFN] = avail;
          nxt[BEH_bebusDFN] = (void *)bef_pnt->BEBUS;
          typ[BEH_bebusDFN] = BEH_bebusDFN;
          }
        if (bef_pnt->BEBUX != NULL)
          {
          tab[BEH_bebuxDFN] = avail;
          nxt[BEH_bebuxDFN] = (void *)bef_pnt->BEBUX;
          typ[BEH_bebuxDFN] = BEH_bebuxDFN;
          }
        if (bef_pnt->BEAUX != NULL)
          {
          tab[BEH_beauxDFN] = avail;
          nxt[BEH_beauxDFN] = (void *)bef_pnt->BEAUX;
          typ[BEH_beauxDFN] = BEH_beauxDFN;
          }
        if (bef_pnt->BEDLY != NULL)
          {
          tab[BEH_bedlyDFN] = avail;
          nxt[BEH_bedlyDFN] = (void *)bef_pnt->BEDLY;
          typ[BEH_bedlyDFN] = BEH_beauxDFN;
          }
        if (bef_pnt->BEPOR != NULL)
          {
          tab[BEH_beporDFN] = avail;
          nxt[BEH_beporDFN] = (void *)bef_pnt->BEPOR;
          typ[BEH_beporDFN] = BEH_beporDFN;
          }
        if (bef_pnt->BEGEN != NULL)
          {
          tab[BEH_begenDFN] = avail;
          nxt[BEH_begenDFN] = (void *)bef_pnt->BEGEN;
          typ[BEH_begenDFN] = BEH_begenDFN;
          }
        if (bef_pnt->USER != NULL)
          {
          tab[BEH_userDFN] = avail;
          nxt[BEH_userDFN] = (void *)bef_pnt->USER;
          typ[BEH_userDFN] = BEH_ptypeDFN;
          }
        if (bef_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bef_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_befigDFN;
          }

        cct_pnt = bef_pnt->CIRCUI;

        printf ("   name        : %s\n",bef_pnt->NAME);
        printf ("   errflg      : %d\n",bef_pnt->ERRFLG);
        printf ("   type        : %d\n",bef_pnt->TYPE);
        printf ("-> bereg       : %s\n",tab[BEH_beregDFN]);
        printf ("-> bemsg       : %s\n",tab[BEH_bemsgDFN]);
        printf ("-> berin       : %s\n",tab[BEH_berinDFN]);
        printf ("-> beout       : %s\n",tab[BEH_beoutDFN]);
        printf ("-> bebus       : %s\n",tab[BEH_bebusDFN]);
        printf ("-> beaux       : %s\n",tab[BEH_beauxDFN]);
        printf ("-> bedly       : %s\n",tab[BEH_bedlyDFN]);
        printf ("-> bebux       : %s\n",tab[BEH_bebuxDFN]);
        printf ("-> bepor       : %s\n",tab[BEH_beporDFN]);
        printf ("-> begen       : %s\n",tab[BEH_begenDFN]);
        printf ("-> user        : %s\n",tab[BEH_userDFN]);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_beregDFN):

	/* ###------------------------------------------------------### */
	/*			BEREG					*/
	/* ###------------------------------------------------------### */

        ber_pnt = (struct bereg *)(cur_pnt.data);

        if (ber_pnt->BIABL != NULL)
          {
          tab[BEH_biablDFN] = avail;
          nxt[BEH_biablDFN] = (void *)ber_pnt->BIABL;
          typ[BEH_biablDFN] = BEH_biablDFN;
          }
        if (ber_pnt->BINODE != NULL)
          {
          tab[BEH_binodeDFN] = avail;
          nxt[BEH_binodeDFN] = (void *)ber_pnt->BINODE;
          typ[BEH_binodeDFN] = BEH_binodeDFN;
          }
        if (ber_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)ber_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_beregDFN;
          }

        printf ("   name        : %s\n",ber_pnt->NAME);
        printf ("-> biabl       : %s\n",tab[BEH_biablDFN]);
        printf ("-> binode      : %s\n",tab[BEH_binodeDFN]);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_bemsgDFN):

	/* ###------------------------------------------------------### */
	/*			BEMSG					*/
	/* ###------------------------------------------------------### */

        bem_pnt = (struct bemsg *)(cur_pnt.data);

        if (bem_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bem_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_bemsgDFN;
          }

        printf ("   message     : %s\n",bem_pnt->MESSAGE);
        printf ("   label       : %s\n",bem_pnt->LABEL);
        printf ("   level       : %c\n",bem_pnt->LEVEL);
        if (bem_pnt->ABL != NULL)
          {
          buffer=exprToCharInt (bem_pnt->ABL,1,buffer,&buff_size);
          printf ("   abl         : %s\n",buffer);
          }
        else
          printf ("   abl         :\n");
        buffer[0] = '\0';

        if (bem_pnt->NODE != NULL)
          {
          ptr_abl = bddToAbl (bem_pnt->NODE, cct_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   node        : %s\n",buffer);
          }
        else
          printf ("   node        :\n");
        buffer[0] = '\0';
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_berinDFN):

	/* ###------------------------------------------------------### */
	/*			BERIN					*/
	/* ###------------------------------------------------------### */

        bei_pnt = (struct berin *)(cur_pnt.data);

        if (bei_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bei_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_berinDFN;
          }

        printf ("   name        : %s\n",bei_pnt->NAME);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_beoutDFN):

	/* ###------------------------------------------------------### */
	/*			BEOUT					*/
	/* ###------------------------------------------------------### */

        beo_pnt = (struct beout *)(cur_pnt.data);

        if (beo_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)beo_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_beoutDFN;
          }

        printf ("   name        : %s\n",beo_pnt->NAME);
        if (beo_pnt->ABL != NULL)
          {
          buffer=exprToCharInt (beo_pnt->ABL,1,buffer,&buff_size);
          printf ("   abl         : %s\n",buffer);
          }
        else
          printf ("   abl         :\n");
        buffer[0] = '\0';

        if (beo_pnt->NODE != NULL)
          {
          ptr_abl= bddToAbl (beo_pnt->NODE, cct_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   node        : %s\n",buffer);
          }
        else
          printf ("   node        :\n");
        buffer[0] = '\0';
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_bebusDFN):

	/* ###------------------------------------------------------### */
	/*			BEBUS					*/
	/* ###------------------------------------------------------### */

        beb_pnt = (struct bebus *)(cur_pnt.data);

        if (beb_pnt->BINODE != NULL)
          {
          tab[BEH_binodeDFN] = avail;
          nxt[BEH_binodeDFN] = (void *)beb_pnt->BINODE;
          typ[BEH_binodeDFN] = BEH_binodeDFN;
          }
        if (beb_pnt->BIABL != NULL)
          {
          tab[BEH_biablDFN] = avail;
          nxt[BEH_biablDFN] = (void *)beb_pnt->BIABL;
          typ[BEH_biablDFN] = BEH_biablDFN;
          }
        if (beb_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)beb_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_bebusDFN;
          }

        printf ("   name        : %s\n",beb_pnt->NAME);
        printf ("   type        : %c\n",beb_pnt->TYPE);
        printf ("-> biabl       : %s\n",tab[BEH_biablDFN]);
        printf ("-> binode      : %s\n",tab[BEH_binodeDFN]);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_bebuxDFN):

	/* ###------------------------------------------------------### */
	/*			BEBUX					*/
	/* ###------------------------------------------------------### */

        bbx_pnt = (struct bebux *)(cur_pnt.data);

        if (bbx_pnt->BINODE != NULL)
          {
          tab[BEH_binodeDFN] = avail;
          nxt[BEH_binodeDFN] = (void *)bbx_pnt->BINODE;
          typ[BEH_binodeDFN] = BEH_binodeDFN;
          }
        if (bbx_pnt->BIABL != NULL)
          {
          tab[BEH_biablDFN] = avail;
          nxt[BEH_biablDFN] = (void *)bbx_pnt->BIABL;
          typ[BEH_biablDFN] = BEH_biablDFN;
          }
        if (bbx_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bbx_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_bebuxDFN;
          }

        printf ("   name        : %s\n",bbx_pnt->NAME);
        printf ("   type        : %c\n",bbx_pnt->TYPE);
        printf ("-> biabl       : %s\n",tab[BEH_biablDFN]);
        printf ("-> binode      : %s\n",tab[BEH_binodeDFN]);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_beauxDFN):

	/* ###------------------------------------------------------### */
	/*			BEAUX					*/
	/* ###------------------------------------------------------### */

        bex_pnt = (struct beaux *)(cur_pnt.data);

        if (bex_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bex_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_beauxDFN;
          }

        printf ("   name        : %s\n",bex_pnt->NAME);
        if (bex_pnt->ABL != NULL)
          {
          buffer=exprToCharInt (bex_pnt->ABL,1,buffer,&buff_size);
          printf ("   abl         : %s\n",buffer);
          }
        else
          printf ("   abl         :\n");
        buffer[0] = '\0';

        if (bex_pnt->NODE != NULL)
          {
          ptr_abl= bddToAbl (bex_pnt->NODE, cct_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   node        : %s\n",buffer);
          }
        else
          printf ("   node        :\n");
        buffer[0] = '\0';
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_beporDFN):

	/* ###------------------------------------------------------### */
	/*			BEPOR					*/
	/* ###------------------------------------------------------### */

        bep_pnt = (struct bepor *)(cur_pnt.data);

        if (bep_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bep_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_beporDFN;
          }

        printf ("   name        : %s\n",bep_pnt->NAME);
        printf ("   direction   : %c\n",bep_pnt->DIRECTION);
        printf ("   type        : %c\n",bep_pnt->TYPE);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_biablDFN):

	/* ###------------------------------------------------------### */
	/*			BIABL					*/
	/* ###------------------------------------------------------### */

        bbl_pnt = (struct biabl *)(cur_pnt.data);

        if (bbl_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bbl_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_biablDFN;
          }

        if (bbl_pnt->VALABL != NULL)
          {
          buffer=exprToCharInt (bbl_pnt->VALABL,1,buffer,&buff_size);
          printf ("   valabl      : %s\n",buffer);
          }
        else
          printf ("   valabl      :\n");
        buffer[0] = '\0';

        if (bbl_pnt->CNDABL != NULL)
          {
          buffer=exprToCharInt (bbl_pnt->CNDABL,1,buffer,&buff_size);
          printf ("   cndabl      : %s\n",buffer);
          }
        else
          printf ("   cndabl      :\n");
        buffer[0] = '\0';

        printf ("   label       : %s\n",bbl_pnt->LABEL);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_binodeDFN):

	/* ###------------------------------------------------------### */
	/*			BINODE					*/
	/* ###------------------------------------------------------### */

        bnd_pnt = (struct binode *)(cur_pnt.data);

        if (bnd_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)bnd_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_binodeDFN;
          }

        if (bnd_pnt->CNDNODE != NULL)
          {
          ptr_abl= bddToAbl (bnd_pnt->CNDNODE, cct_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   cndnode     : %s\n",buffer);
          }
        else
          printf ("   cndnode     :\n");
        buffer[0] = '\0';

        if (bnd_pnt->VALNODE != NULL)
          {
          ptr_abl= bddToAbl (bnd_pnt->VALNODE, cct_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   valnode     : %s\n",buffer);
          }
        else
          printf ("   valnode     :\n");
        buffer[0] = '\0';

        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_begenDFN):

	/* ###------------------------------------------------------### */
	/*			BEGEN					*/
	/* ###------------------------------------------------------### */

        beg_pnt = (struct begen *)(cur_pnt.data);

        if (beg_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)beg_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_begenDFN;
          }

        printf ("   name        : %s\n",beg_pnt->NAME);
        printf ("   value       : %ld\n",*((long *)beg_pnt->VALUE));
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;

      case (BEH_ptypeDFN):

	/* ###------------------------------------------------------### */
	/*			PTYPE					*/
	/* ###------------------------------------------------------### */

        pty_pnt = (struct ptype *)(cur_pnt.data);

        if (pty_pnt->DATA != NULL)
          {
          tab[BEH_dataDFN] = avail;
          nxt[BEH_dataDFN] = (void *)pty_pnt->DATA;
          switch (pty_pnt->TYPE)
            {
            case BEH_GENERIC :
              typ[BEH_dataDFN] = BEH_begenDFN ;
              break;
            }
          }

        if (pty_pnt->NEXT != NULL)
          {
          tab[BEH_nextDFN] = avail;
          nxt[BEH_nextDFN] = (void *)pty_pnt->NEXT;
          typ[BEH_nextDFN] = BEH_ptypeDFN;
          }

        printf ("   type        : %ld\n",pty_pnt->TYPE);
        printf ("-> data        : %s\n",tab[BEH_dataDFN]);
        printf ("-> next        : %s\n",tab[BEH_nextDFN]);

        break;
      }

	/* ###------------------------------------------------------### */
	/*    Reading new command					*/
	/* ###------------------------------------------------------### */

    readcmd = vhd_getcmd (readtab);

    for (i=0 ; i<BEH_MAXDFN ; i++)
      {
      if (readcmd == key[i])
        break;
      }
    if ((i != BEH_MAXDFN+1) && (tab[i] == avail))
      newsta0 = i;
    else
      newsta0 = BEH_errorDFN;

    if (newsta0 == BEH__setDFN)
      {
      readcmd = vhd_hash (readtab[1]);
      for (i=0 ; i<BEH_MAXDFN ; i++)
        {
        if (readcmd == key[i])
          break;
        }
      if (i != BEH_MAXDFN+1)
        newsta1 = i;
      else
        newsta1 = BEH_errorDFN;
      }

	/* ###------------------------------------------------------### */
	/*    Analysing new command					*/
	/* ###------------------------------------------------------### */

    switch (newsta0)
      {
      case (BEH__setDFN):
        switch (state)
          {
          case (BEH_bebusDFN):
          case (BEH_bebuxDFN):
            switch (newsta1)
              {
              case (BEH_typeDFN):
                beb_pnt->TYPE = readtab[2][0];
                break;
              }
            break;
          case (BEH_bemsgDFN):
            switch (newsta1)
              {
              case (BEH_levelDFN):
                bem_pnt->LEVEL = readtab[2][0];
                break;
              }
            break;
          case (BEH_beporDFN):
            switch (newsta1)
              {
              case (BEH_directionDFN):
                bep_pnt->DIRECTION = readtab[2][0];
                break;
              case (BEH_typeDFN):
                bep_pnt->TYPE = readtab[2][0];
                break;
              }
            break;
          }
        break;

      case (BEH__upDFN):
        cur_pnt        = stk[--stk_pnt] ;
        break;

      case (BEH__backDFN):
        while ((--stk_pnt != 0) && (stk[stk_pnt].mark != 1));
        cur_pnt        = stk[stk_pnt] ;
        break;

      case (BEH__stopDFN):
        cur_pnt.mark   = 1;
        break;

      case (BEH__topDFN):
        cur_pnt        = stk[0] ;
        stk_pnt        = 0 ;
        break;

      case (BEH__exitDFN):
        cur_pnt.data   = NULL;
        cur_pnt.type   = BEH__exitDFN;
        cur_pnt.mark   = 0;
        break;

      case (BEH_errorDFN):
        break;

      default:
        if (stk_pnt < BEH_STKSIZ)
          {
          stk[stk_pnt++] = cur_pnt;
          cur_pnt.type   = typ[newsta0];
          cur_pnt.mark   = 0;
          cur_pnt.data   = nxt[newsta0];
          }
        else
          printf ("==> STACK OVERFLOW -- STACK OVERFLOW <==\n");
        break;

      }

    state  = cur_pnt.type;
    }

  mbkfree (buffer);
  }
