
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: beh106.h						*/
/* date		: Sep  3 1993						*/
/* version	: v106							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* contents	: defines and structure definitions used in BEH library	*/
/*									*/
/* ###--------------------------------------------------------------### */

#ifndef BEH_BEHDEF
#define BEH_BEHDEF

	/* ###------------------------------------------------------### */
	/*    defines							*/
	/* ###------------------------------------------------------### */

#define BEH_GENERIC 203698	/* generic ptype code			*/
#define BEH_STABLE  0x01	/* description used STABLE attribute	*/

	/* ###------------------------------------------------------### */
	/*    structure definitions					*/
	/* ###------------------------------------------------------### */

typedef struct befig		/* behaviour figure			*/
  {
  struct befig      *NEXT;	/* next figure				*/
  char              *NAME;	/* figure's name			*/
  struct bereg      *BEREG;	/* list of internal signals (REGISTER)	*/
  struct bemsg      *BEMSG;	/* list of assert instructions		*/
  struct berin      *BERIN;	/* list of inputs (registers and ports)	*/
  struct beout      *BEOUT;	/* list of output ports			*/
  struct bebus      *BEBUS;	/* list of output ports (BUS)		*/
  struct beaux      *BEAUX;	/* list of internal signals		*/
  struct beaux      *BEDLY;	/* internal signals used for 'DELAYED	*/
  struct bebux      *BEBUX;	/* list of internal signals (BUS)	*/
  struct bepor      *BEPOR;	/* list of figure's port built in the	*/
				/* reverse order of the port clause	*/
  struct begen      *BEGEN; 	/* list of generic data			*/
  struct circuit    *CIRCUI;	/* Circuit pointer used during ABL to	*/
				/* BDD transformation			*/
  struct ptype      *USER;	/* reserved for user's applications	*/
  char               ERRFLG;	/* error flag				*/
  char               TYPE;	/* description type (not used)		*/
  }
befig_list;

typedef struct bereg		/* register				*/
  {
  struct bereg  *NEXT;		/* next register			*/
  char          *NAME;		/* register's name			*/
  struct biabl  *BIABL;		/* list of drivers (ABL)		*/
  struct binode *BINODE;	/* list of drivers (BDD)		*/
  }
bereg_list;

typedef struct bemsg		/* assert instruction			*/
  {
  struct bemsg 	*NEXT;		/* next assertion			*/
  char		 LEVEL;		/* severity level of the assertion	*/
  char		*LABEL;		/* instruction's label			*/
  char		*MESSAGE;	/* assertion's message			*/
  struct chain	*ABL;		/* assertion's condition (ABL)		*/
  struct node	*NODE;		/* assertion's condition (BDD)		*/
  }
bemsg_list;

typedef struct beout		/* output port				*/
  {
  struct beout	*NEXT;		/* next output				*/
  char		*NAME;		/* port's name				*/
  struct chain	*ABL;		/* port's equation (ABL)		*/
  struct node	*NODE;		/* port's equation (BDD)		*/
  }
beout_list;

typedef struct bebus		/* output port (BUS)			*/
  {
  struct bebus	*NEXT;		/* next bus port			*/
  char		*NAME;		/* port's name				*/
  struct biabl	*BIABL;		/* list of drivers (ABL)		*/
  struct binode	*BINODE;	/* list of drivers (BDD)		*/
  char		 TYPE;		/* port's type : W or M			*/
  }
bebus_list;

typedef struct beaux		/* auxiliary signal			*/
  {	
  struct beaux	*NEXT;		/* next signal				*/
  char		*NAME;		/* signal's name			*/
  struct chain	*ABL;		/* signal's equation (ABL)		*/
  struct node	*NODE;		/* signal's equation (BDD)		*/
  }
beaux_list;

typedef struct bebux		/* internal signal (BUS)		*/
  {	
  struct bebux	*NEXT;		/* next signal				*/
  char		*NAME;		/* signal's name			*/
  struct biabl	*BIABL;		/* list of drivers (ABL)		*/
  struct binode	*BINODE;	/* list of drivers (BDD)		*/
  char		 TYPE;		/* signal's type : W or M		*/
  }
bebux_list;

typedef struct bepor		/* port					*/
  {
  struct bepor *NEXT;		/* next port				*/
  char         *NAME;		/* port's name				*/
  char          DIRECTION;	/* port's mode (same as LOCON)		*/
  char          TYPE;		/* port's type (B, M or W)		*/
  }
bepor_list;

typedef struct biabl		/* couple of ABL			*/
  {
  struct biabl	*NEXT;		/* next couple				*/
  char          *LABEL;		/* driver's label			*/
  struct chain	*CNDABL;	/* driver's connection condition (ABL)	*/
  struct chain	*VALABL;	/* equation of driven value (ABL)	*/
  struct ptype  *USER;		/* user field				*/
  }
biabl_list;

typedef struct binode		/* couple of BDD			*/
  {
  struct binode	*NEXT;	 	/* next figure				*/
  struct node	*CNDNODE;	/* driver's connection condition (BDD)	*/
  struct node	*VALNODE;	/* equation of driven value (BDD)	*/
  }
binode_list;

typedef struct berin		/* primary inputs			*/
  {
  struct berin *NEXT;		/* next input				*/
  char         *NAME;		/* input's name				*/
  }
berin_list;

typedef struct begen		/* generic				*/
  {
  struct begen *NEXT;		/* next generic				*/
  char 	       *NAME;		/* generic`s name			*/
  char         *TYPE;		/* generic type`s name			*/
  void         *VALUE;		/* generic`s value			*/
  }
begen_list;

	/* ###------------------------------------------------------### */
	/*    functions							*/
	/* ###------------------------------------------------------### */

extern struct beaux  *beh_addbeaux ();
extern struct bebux  *beh_addbebux ();
extern struct bebus  *beh_addbebus ();
extern struct befig  *beh_addbefig ();
extern struct begen  *beh_addbegen ();
extern struct bemsg  *beh_addbemsg ();
extern struct beout  *beh_addbeout ();
extern struct bepor  *beh_addbepor ();
extern struct bereg  *beh_addbereg ();
extern struct berin  *beh_addberin ();
extern struct biabl  *beh_addbiabl ();
extern struct binode *beh_addbinode ();
extern struct beaux  *beh_delbeaux ();
extern struct bebux  *beh_delbebux ();
extern struct bebus  *beh_delbebus ();
extern struct befig  *beh_delbefig ();
extern struct begen  *beh_delbegen ();
extern struct bemsg  *beh_delbemsg ();
extern struct beout  *beh_delbeout ();
extern struct bepor  *beh_delbepor ();
extern struct bereg  *beh_delbereg ();
extern struct berin  *beh_delberin ();
extern struct biabl  *beh_delbiabl ();
extern struct binode *beh_delbinode ();
extern void           beh_frebeaux ();
extern void           beh_frebebux ();
extern void           beh_frebebus ();
extern void           beh_frebefig ();
extern void           beh_frebegen ();
extern void           beh_frebemsg ();
extern void           beh_frebeout ();
extern void           beh_frebepor ();
extern void           beh_frebereg ();
extern void           beh_freberin ();
extern void           beh_frebiabl ();
extern void           beh_frebinode ();
extern struct beaux  *beh_rmvbeaux ();
extern struct bebux  *beh_rmvbebux ();
extern struct bebus  *beh_rmvbebus ();
extern struct befig  *beh_rmvbefig ();
extern struct begen  *beh_rmvbegen ();
extern struct bemsg  *beh_rmvbemsg ();
extern struct beout  *beh_rmvbeout ();
extern struct bepor  *beh_rmvbepor ();
extern struct bereg  *beh_rmvbereg ();
extern struct berin  *beh_rmvberin ();

#endif
