/***
*   ERIC CHABOD
*   ANTOINE MARTIN
*   D.E.A. M.E.M.I. 1992
*
*   Laurent WINCKEL
*
*   PROJET BSG : Barrel Shifter Generator
*
*   NOM:     bsg_data.c
*   VERSION: 2.00
*	DATE:	 (06/01/1994)
*   OBJET:   generation du datasheet.
*/ 

static char *data_ident="@(#)(BSG) datasheet view generation, version 2.00 (06/01/1994)";

/*******************************************************************/

#define bsg_tech_name   ("PROL10")
#define bsg_tech_micron (0.875)    /* Width of one lambda in microns. */

/* Layers capacitances in pF/Lambda of minimal width segments. */

#define bsg_tech_capa_gate (1670e-6)
#define bsg_tech_capa_poly (160e-6)
#define bsg_tech_capa_alu1 (160e-6)
#define bsg_tech_capa_alu2 (160e-6)

/*******************************************************************/

static long cir_width()
{
	long	dbuf = WIDTH( "bsdbuf32_c" ),
	dand = WIDTH( NAME( "bsdand%d_c", r_size ) ),
	ssel = WIDTH( "bssselm32_c" ),
	snbl = WIDTH( "bssnblm32_c" ),
	lmux = WIDTH( "bslmuxm32_c" ),
	mlef = WIDTH( "bsmlef32_c" ),
	mmat = WIDTH( "bsmmat32_c" ),
	mrig = WIDTH( "bsmrig32_c" ),
	rmux = WIDTH( "bsrmux32_c" ),
	oout = WIDTH( "bsoout32_c" ),
	alim = WIDTH( "bsalim_c" );

	return (dbuf + dand + ssel + snbl + lmux + mlef + ( mmat * bs_size ) + ( ( size % 2 )?  mrig : 0 ) + rmux + oout + alim);
}

/*******************************************************************/


/* routine donnant la hauteur du circuit */
static long cir_height( virtual )
long virtual;
{
	return (HEIGHT( "bsdbuf32_c" ) * (bs_size+2) + ( virtual ? 0 : (4+3) + (4+3) ) );
}

/*******************************************************************/

static void gen_dsh( bits, virtual, msb0 )
long bits, virtual, msb0;
{
	long  b_width, b_height;

	float b_width_m, b_height_m;

    float nbr_t;

	FILE *fh;

	fh = stdout;

/********** Print block name. **********/

	fprintf( fh, "Name : \"%s\".\n\n", name );

/********** Print function. **********/

	fprintf( fh, "Function : " );

	fprintf( fh, "%ld bits barrel shifter.\n", size+1 );

	if(virtual)
		fprintf( fh, "\tDatapath connectors are multi-access.\n" );
	else
		fprintf( fh, "\tAll connectors are hard (one-access).\n" );
	if(msb0)
		fprintf( fh, "\tIndex 0 is gived to the most significant bit of each bus.\n\n" );
	else
		fprintf( fh, "\tIndex 0 is gived to the less significant bit of each bus.\n\n" );

/********** Print technology. **********/

	fprintf( fh, "Technology : \"%s\".\n\n", bsg_tech_name );

/********** Calculate width and height of block. **********/

	b_width= cir_width();
	b_height=cir_height( virtual );
	b_width_m=b_width*bsg_tech_micron;
	b_height_m=b_height*bsg_tech_micron;

	fprintf( fh, "Dimensions :\n");
	fprintf( fh, "              Height  Width      Area\n");
	fprintf( fh, "Lambdas        %5d  %5d%10d\n",
			b_height, b_width, b_height*b_width);
	fprintf( fh, "Microns        %5.0f  %5.0f%10.0f\n\n",
			b_height_m, b_width_m, b_height_m*b_width_m);

/********** Print number of transistors. **********/

    nbr_t=27.3787+56.23852*bits+1.00749187*bits*bits;
	fprintf( fh, "Number of transistors : %ld.\n\n", (long) nbr_t );

#if 0
/********** Liste of connectors. **********/

	fprintf( fh, "- Circuit interface :\n" );
	fprintf( fh, "  -------------------\n" );
	fprintf( fh, "   - Primary inputs : \n" );
	fprintf( fh, "     ----------------\n" );
	fprintf( fh, "        in_d[0...%2d]         ->    Data input.\n", size );
	fprintf( fh, "        in_s[0...%2d]         ->    Value of the shift.\n", ad_size );
	fprintf( fh, "        left                 ->    Shift direction control.\n" );
	fprintf( fh, "        rot                  ->    Rotation control.\n" );
	fprintf( fh, "        ext                  ->    Arithmetical right shift control.\n" );
	fprintf( fh, "        vdd0...%2d           ->    Power.\n", bs_size + 1 );
	fprintf( fh, "        vss0...%2d           ->    Ground.\n\n", bs_size + 2 );
	fprintf( fh, "   - Primary outputs : \n" );
	fprintf( fh, "     -----------------\n" );
	fprintf( fh, "        out_d[0...%2d]        ->    Data output.\n\n\n", size );
#endif

/********** Print input capacitances. **********/

	fprintf( fh, "Input capacitances :\n");

	fprintf( fh, "    - in_d = %.3f pF.\n",
			/* wire */
			b_width*bsg_tech_capa_alu2+

			/* bsdbuf32_c or bsdbufi32_c */
			48*bsg_tech_capa_alu1+

			/* bssnbli32_c + bslmuxi32_c */
			66*bsg_tech_capa_alu2+
			106*bsg_tech_capa_alu1+

			/* bslmuxi32_c, bslmuxm32_c or bslmuxt32_c */
			15*bsg_tech_capa_alu1+
			22*bsg_tech_capa_poly+
			12*bsg_tech_capa_gate+

			/* bshcmd32_c or bshcmdi32_c */
			31*bsg_tech_capa_alu1+
			14*bsg_tech_capa_poly+
			12*bsg_tech_capa_gate+

			/* bsrmux32_c or bsrmuxi32_c */
			9*bsg_tech_capa_alu1+
			17*bsg_tech_capa_poly+
			12*bsg_tech_capa_gate+

			/* bsoout32_c or bsoouti32_c */
			13*bsg_tech_capa_alu1);

	fprintf( fh, "    - in_s = %.3f pF.\n", 
			/* bsdbuf32_c or bsdbuf32_c */
			10*bsg_tech_capa_alu2+
			32*bsg_tech_capa_alu1+
			28*bsg_tech_capa_poly+
			30*bsg_tech_capa_gate);

	fprintf( fh, "    - left = %.3f pF.\n", 
			/* bshsel32_c or bshseli32_c */
			0*bsg_tech_capa_alu2+
			48*bsg_tech_capa_alu1+
			28*bsg_tech_capa_poly+
			30*bsg_tech_capa_gate);
	fprintf( fh, "    - rot  = %.3f pF.\n",
			/* bshcmd32_c or bshcmdi32_c */
			0*bsg_tech_capa_alu2+
			23*bsg_tech_capa_alu1+
			10*bsg_tech_capa_poly+
			18*bsg_tech_capa_gate);
	fprintf( fh, "    - ext  = %.3f pF.\n\n",
			/* bshcmd32_c or bshcmdi32_c */
			0*bsg_tech_capa_alu2+
			164*bsg_tech_capa_alu1+
			14*bsg_tech_capa_poly+
			12*bsg_tech_capa_gate);

/********** Print timing. **********/

	fprintf( fh, "Timing (slow, Cload in pF) :\n" );

    /* Time Propagation Address ->Data out. */
	fprintf( fh, "    - tpadlh = %.3f + %.3f * Cload ns.\n",
      (3.576 + 4.78847E-2*(size+1)), 3.24086);
	fprintf( fh, "    - tpadhl = %.3f + %.3f * Cload ns.\n",
      (3.99068 + 7.76446E-2*(size+1)), 2.41307);

    /* Time Propagation Command (left, rot, ext) -> Data out. */
	fprintf( fh, "    - tpcdlh = %.3f + %.3f * Cload ns.\n",
      (5.2842 + 8.0257E-2*(size+1)), 3.32183);
	fprintf( fh, "    - tpcdhl = %.3f + %.3f * Cload ns.\n",
      (4.74727 + 7.85344E-2*(size+1)), 2.43062);

    /* Time Propagation Data in -> Data out. */
	fprintf( fh, "    - tpddlh = %.3f + %.3f * Cload ns.\n",
      (3.05051 + 8.29658E-2*(size+1)), 3.32826);
	fprintf( fh, "    - tpddhl = %.3f + %.3f * Cload ns.\n\n",
      (3.15083 + 7.89285E-2*(size+1)), 2.41819);
}
