/***
*   Laurent WINCKEL
*
*	PROJET BSG : Barrel Shifter Generator
*
*	NOM:	 bsg_icon.c
*   VERSION: 2.00
*	DATE:	 (29/09/1993)
*	OBJET:	 generation de la vue icon.
*/

static char *icon_ident="@(#)(BSG) icon view generation, version 2.00 (29/09/1993)";

/*******************************************************************/

#include ICN_H
#include IAC_H
#include ICU_H

/*******************************************************************/

#define BSG_CON_OFFSET 50L
#define BSG_CON_STEP   50L
#define BSG_CON_LENGHT 20L
#define BSG_CON_CIRCLE 6L
#define BSG_CON_PTR    5L
#define BSG_CON_D_NAME (-28L)

/*******************************************************************/

#define ICON_SCALE_X SCALE_X
#define ICON_SCALE_Y (-SCALE_X)

#define BSG_ADDICONGATE(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) \
  addicongate(a, \
    (b)*ICON_SCALE_X, (c)*ICON_SCALE_Y, d, e, f, \
    (g)*ICON_SCALE_X, (h)*ICON_SCALE_Y, i, j, k, \
    (l)*ICON_SCALE_X, (m)*ICON_SCALE_Y, n, o, p)

#define BSG_ADDICONCON(a, b, c, d, e, f, g, h, i, j, k) \
  addiconcon(a, b, \
    (c)*ICON_SCALE_X, (d)*ICON_SCALE_Y, e, f, g, h, i, \
    (j)*ICON_SCALE_X, (k)*ICON_SCALE_Y)

#define BSG_ADDICONLINE(a, b, c, d, e) \
  addiconline(a, \
    (b)*ICON_SCALE_X, (c)*ICON_SCALE_Y, \
    (d)*ICON_SCALE_X, (e)*ICON_SCALE_Y)

#define BSG_ADDICONCOMP(a, b, c, d) \
  addiconcomp(a, b, \
    (c)*ICON_SCALE_X, (d)*ICON_SCALE_Y)

#define BSG_ADDICONCIRCLE(a, b, c, d, e) \
  addiconcircle(a, \
    (b)*ICON_SCALE_X, (c)*ICON_SCALE_Y, \
    (d)*ICON_SCALE_X, (e)*ICON_SCALE_Y)

/*******************************************************************/

static void gen_icon ( msb0 )
long msb0;
{
long          icon_width;
long          icon_hight;
long          x, y;

IconGate_list *icon;
IconComp_list *comp;

/********** Calculate size of icon. **********/

icon_width=300L-2*BSG_CON_LENGHT;
icon_hight=300L-2*BSG_CON_LENGHT;

/********** Create icon. **********/

x=(icon_width>>1);
y=(icon_hight-40L)>>1;
if((icon=BSG_ADDICONGATE(name, x, y+20L, SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL,
  x, y+0L, SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL,
  x, y+10L, SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL))==NULL)
  { (void) PRINTF("Error : unable to create icon !!!\n");
    EXIT(1); }

/********** Create connectors list. **********/

     /***** Add connector to list. *****/

x=(icon_width>>1)-BSG_CON_STEP;
y=icon_hight;
if(BSG_ADDICONCON(icon, "left",
  x, y+BSG_CON_LENGHT, SAX_NORTH, IN, SAX_CENTER, SAX_UP, SAX_HORIZONTAL,
  x, y+BSG_CON_LENGHT+BSG_CON_D_NAME)==NULL)
  { (void) PRINTF("Error : unable to create icon connector !!!\n");
    EXIT(1); }
if(BSG_ADDICONLINE(icon, x, y+BSG_CON_LENGHT, x, y)==NULL)
  { (void) PRINTF("Error : unable to create icon line !!!\n");
    EXIT(1); }

x=icon_width>>1;
y=icon_hight;
if(BSG_ADDICONCON(icon, "rot",
  x, y+BSG_CON_LENGHT, SAX_NORTH, IN, SAX_CENTER, SAX_UP, SAX_HORIZONTAL,
  x, y+BSG_CON_LENGHT+BSG_CON_D_NAME)==NULL)
  { (void) PRINTF("Error : unable to create icon connector !!!\n");
    EXIT(1); }
if(BSG_ADDICONLINE(icon, x, y+BSG_CON_LENGHT, x, y)==NULL)
  { (void) PRINTF("Error : unable to create icon line !!!\n");
    EXIT(1); }

x=(icon_width>>1)+BSG_CON_STEP;
y=icon_hight;
if(BSG_ADDICONCON(icon, "ext",
  x, y+BSG_CON_LENGHT, SAX_NORTH, IN, SAX_CENTER, SAX_UP, SAX_HORIZONTAL,
  x, y+BSG_CON_LENGHT+BSG_CON_D_NAME)==NULL)
  { (void) PRINTF("Error : unable to create icon connector !!!\n");
    EXIT(1); }
if(BSG_ADDICONLINE(icon, x, y+BSG_CON_LENGHT, x, y)==NULL)
  { (void) PRINTF("Error : unable to create icon line !!!\n");
    EXIT(1); }

x=0L;
y=(icon_hight+BSG_CON_STEP)>>1;
if(BSG_ADDICONCON(icon, NAME( "in_s[%d:%d]", msb0 ? 0 : ad_size, msb0 ? ad_size : 0 ),
  x-BSG_CON_LENGHT, y, SAX_WEST, IN, SAX_LEFT, SAX_CENTER, SAX_HORIZONTAL,
  x-BSG_CON_LENGHT-BSG_CON_D_NAME, y)==NULL)
  { (void) PRINTF("Error : unable to create icon connector !!!\n");
    EXIT(1); }
if(BSG_ADDICONLINE(icon, x-BSG_CON_LENGHT, y, x, y)==NULL)
  { (void) PRINTF("Error : unable to create icon line !!!\n");
    EXIT(1); }

x=0L;
y=(icon_hight-BSG_CON_STEP)>>1;
if(BSG_ADDICONCON(icon, NAME( "in_d[%d:%d]",  msb0 ? 0 : size,  msb0 ? size : 0 ),
  x-BSG_CON_LENGHT, y, SAX_WEST, IN, SAX_LEFT, SAX_CENTER, SAX_HORIZONTAL,
  x-BSG_CON_LENGHT-BSG_CON_D_NAME, y)==NULL)
  { (void) PRINTF("Error : unable to create icon connector !!!\n");
  EXIT(1); }
if(BSG_ADDICONLINE(icon, x-BSG_CON_LENGHT, y, x, y)==NULL)
  { (void) PRINTF("Error : unable to create icon line !!!\n");
    EXIT(1); }

x=icon_width;
y=icon_hight>>1;
if(BSG_ADDICONCON(icon, NAME( "out_d[%d:%d]", msb0 ? 0 : size, msb0 ? size : 0 ),
  x+BSG_CON_LENGHT, y, SAX_EAST, OUT, SAX_RIGHT, SAX_CENTER, SAX_HORIZONTAL,
  x+BSG_CON_LENGHT+BSG_CON_D_NAME, y)==NULL)
  { (void) PRINTF("Error : unable to create icon connector !!!\n");
    EXIT(1); }
if(BSG_ADDICONLINE(icon, x, y, x+BSG_CON_LENGHT, y)==NULL)
  { (void) PRINTF("Error : unable to create icon line !!!\n");
    EXIT(1); }

/********** Create and draw shape. **********/

if((comp=BSG_ADDICONCOMP((IconComp_list *) NULL, COMP_ISLINE, 0L, 0L))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }
if((comp=BSG_ADDICONCOMP(comp, COMP_ISLINE, 0L, icon_hight))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }
if((comp=BSG_ADDICONCOMP(comp, COMP_ISLINE, icon_width, icon_hight))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }
if((comp=BSG_ADDICONCOMP(comp, COMP_ISLINE, icon_width, 0L))==NULL)
  { (void) PRINTF("Error : unable to create icon shape component !!!\n");
    EXIT(1); }

if(addiconshape(icon, comp)==NULL)
  { (void) PRINTF("Error : unable to create icon shape !!!\n");
    EXIT(1); }

/********** Save icon. **********/

update_icon(icon);

saveicon(icon);
}

/*******************************************************************/
