/********************************************************************
*                                                                   *
* Laboratoire MASI CAO-VLSI, UPMC, Copyright 1991 1992 1993 1994    *
*                                                                   *
* Software support Email : cao-vlsi@masi.ibp.fr                     *
*                                                                   *
* Authors : Zouina AKTOUF &                                         *
*           El Arabi RHOMARI &                                      *
*           Jose MARTINS DOS SANTOS                                 *
*                                                                   *
* Supervision & Modifications : Lotfi BEN AMMAR                     *
*                                                                   *
********************************************************************/
#include "dpr_R.h"
 
DPP_SPACE *tab[MAXLIN][MAXCOL];
DPP_DATAPATH *ptdatapath;

/********************************************************************/
/*add():fonction realisant les addphins des instances du 1er niveau */   
/********************************************************************/
void  add(pt, figname, insname, sym, x, y)
phfig_list *pt;
char *figname;
char *insname;
char sym;
long x;
long y;
{
phins_list *ptins=NULL;
  for(ptins=pt->PHINS;ptins;ptins=ptins->NEXT)
     {
     if(strcmp(ptins->INSNAME,insname)==0)              
        break;
     }
  if(ptins==NULL)   
     {
     addphins(pt,figname,insname, sym, x, y);
     }
  }
   
/*******************************************************************/
/*     addphfig_level1():Creation des modeles physiques en         */   
/*                    memoire des instances du 1er niveau          */
/*******************************************************************/
phfig_list *addphfig_level1(figname)
char *figname;
{
loins_list *ptloins=NULL;
phfig_list *ptfig=NULL;
phfig_list *phfigins=NULL;

for(ptfig=HEAD_PHFIG;ptfig;ptfig=ptfig->NEXT)
   if(ptfig->NAME==figname)
    break;
    phfigins=ptfig;
if(ptfig==NULL)
  {
   phfigins=addphfig(figname); 
  }
return(phfigins);
}
/****************************************************************/
/*    Parcours du tableau pour inserer les bonnes coordonnees  */   
/****************************************************************/
void coord(pt,lig,col)
phfig_list *pt;
int lig;
int col;
{
phfig_list *ptfig1=NULL;
DPP_SPACE *ptspace=NULL;
DPP_SPACE *ptspace_temp=NULL;
int i, j;
int fig=0;
int maxXg=0;
int maxX=0;
int y=0;
int x=0;
int ymax=0;
int flag=0;
int ind=0;
int ord=0;
int ordo=0;
int height=0;
int yabut_max=0;
int ordonnee=0;
int level;
char *upfig=NULL;
char *upins=NULL;
char *name=NULL;

/*Parcours du tableau ligne par ligne pour les ordonneees*/
for(i=0;i<lig;i++)
   {
   flag=0;
   for(j=1;j<=col;j++)
      {
      ptspace=tab[i][j];
      if(tab[i][j]!=NULL)
        {
        flag=1;/*indicateur de presence de cellules dans un bit slice*/
        ptspace->Y=y;
        ord=ptspace->HEIGHT;
        }  
      }
    y=y + ord;
   }

/*Parcours du tableau colonne par colonne pour les abscisses*/
for(j=1;j<=col;j++)
   {
   fig=0;
   maxX=0;
   ymax=0;
   ordo=0;
   for(i=0;i<lig;i++)
      {
      ptspace=tab[i][j];
      if(tab[i][j]!=NULL)
        {
        if(strcmp(ptspace->UPFIG,pt->NAME)==0 && name!=namealloc(ptspace->INSNAME))
          {
          name=ptspace->INSNAME;
          ptfig1=getphfig(ptspace->FIGNAME,'A');
          ordo=ptspace->Y;
          }
        else
          {
          if(fig==0)
            {
            ptfig1=addphfig_level1(ptspace->UPFIG);
            ordo=ptspace->Y;
            fig=1;
            }
          }
          ptspace->X=x;
          maxXg=ptspace->WIDTH;
          height=(ptspace->Y + ptspace->HEIGHT);
          if(maxXg > maxX) maxX=maxXg;
          if(height>ymax) ymax=height;
          if(ptspace->Y < ordo) ordo=ptspace->Y;
        }
      }
      if(ptfig1->USER==NULL)
        {
         ptfig1->XAB1=x;
         x=x + maxX;
         ptfig1->XAB2=x;
         ptfig1->YAB2=ymax;
         ptfig1->USER=(ptype_list *)addchain((chain_list *)NULL, (void *)x);
        }
      else x=x+maxX;
      if(ymax>yabut_max) yabut_max=ymax;
   }
pt->XAB1=0;
pt->YAB1=0;
pt->XAB2=x;
pt->YAB2=yabut_max;
/*coordonnees du coin inferieur gauche des instances non terminales du 1er niveau*/
for(j=1;j<=col;j++)
   {
   flag=0;
   level=1;
   for(i=0;i<lig;i++)
      {
      ptspace=tab[i][j];
      if(ptspace!=NULL)
        {
         if(strcmp(ptspace->UPFIG,pt->NAME)!=0)
            {
            level=2;
            if(flag==0)
              {
              ordonnee=ptspace->Y;
              flag=1; 
              }
	    upfig = ptspace->UPFIG;
	    upins = ptspace->UPINS;
            x=ptspace->X;
            ptspace_temp=ptspace;
            if(ptspace->Y < ordonnee) ordonnee=ptspace->Y;
            }
           else level=1;
        }
      }
   if(level==2) add(pt,upfig, upins, NOSYM, x, pt->YAB1);
   }
          
}         
/****************************************************************/
/*       add_ph():fonction realisant les addphins              */   
/****************************************************************/
void  add_ph(ptspace, pt, figname, insname, sym, x, y)
DPP_SPACE *ptspace;
phfig_list *pt;
char *figname;
char *insname;
char sym;
long x;
long y;
{
phins_list *ptins=NULL;
for(ptins=pt->PHINS;ptins;ptins=ptins->NEXT)
   {
   if(strcmp(ptins->INSNAME,ptspace->INSNAME)==0)              
      break;
   }
if(ptins==NULL)   
   {
   addphins(pt,figname,insname, sym, x, y);
   }
}
/****************************************************************/
/*       Creation de la figure physique en memoire              */   
/****************************************************************/
void create_physical(pt, lig, col)
phfig_list *pt;
int lig;
int col;
{
int i, j, p;
int mask=1;
DPP_SPACE *ptspace;
phfig_list *ptph=NULL;
phfig_list *ptphins=NULL;
phins_list *ptins=NULL;
loins_list *ptloins=NULL;
locon_list *ptlocon=NULL;


for(j=1;j<=col;j++)
   {
    for(i=0;i<lig;i++)
      {
      ptspace=tab[i][j];
      if(ptspace !=NULL)
        {                                  
         if((mask & i)==0)
          {
           ptphins=getphfig(ptspace->UPFIG,'A');
           add_ph(ptspace,ptphins,ptspace->FIGNAME,ptspace->INSNAME,NOSYM,
                    ptspace->X,ptspace->Y);
          }
        else
          {
           ptphins=getphfig(ptspace->UPFIG,'A');
           add_ph(ptspace,ptphins,ptspace->FIGNAME,ptspace->INSNAME,SYM_Y,
                 ptspace->X,ptspace->Y);
         }
        }
      }
   }
for(ptins=pt->PHINS;ptins;ptins=ptins->NEXT)
    {
    if (incatalog(ptins->FIGNAME)==0)
       {
       savephfig(getphfig(ptins->FIGNAME),'A');
       }
    }
addphcon_fig(pt, col);
savephfig(pt);
}  
  
