/*------------------------------------------------------------\
|                                                             |
| Tool    :                    DRUC                           |
|                                                             |
| File    :                  VMCDEFINE.C                      |
|                                                             |
| Authors :                Renaud Patrick                     |
|                                                             |
| Date    :                   11/01/94                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include MPH_H
#include MUT_H
#include RDS_H
#include RUT_H
#include RTL_H
#include RWI_H
#include RFM_H
#include RPR_H

#include "drucutil.h"
#include "vmctools.h"
#include "vmcdefin.h"
/*------------------------------------------------------------\
|                                                             |
|                       VmcDefine Fonctions                   |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         DrucChaineCompose                   |
| Accroche le rectangle source au rectangle dest par le champ |
| NEXT_DEFINE pour connaite la liste des rectangles ayant     |
| contribue a la creation du rectangle dest                   |
| on chaine des structures PlusRect entre elles a chaque      |
| nouveau rectangle composant le layer virtuel                |
| Le champ NEXT_EQUI de la structure ajoutee sert a retrouver |
| le rectangle ayant ete utilise pour composer le rectangle   |
| dest                                                        |
\------------------------------------------------------------*/

void DrucChaineCompose ( RectangleDest ,
                         RectangleSource,
                         IndexLayer
                       )

     rdsrec_list *RectangleDest;
     rdsrec_list *RectangleSource;
     int          IndexLayer;

{

DrucTypeStructPlusRect *TmpPlusRec;

  TmpPlusRec = ( DrucTypeStructPlusRect *)rdsalloc ( MACRO_PLUS_TAILLE ,
                                                     DRUC_ON_HEAP
                                                   );

  TmpPlusRec->NEXT_EQUI               = RectangleDest;
  TmpPlusRec->NOMBRE                  = IndexLayer;
  TmpPlusRec->NEXT_DEFINE             = MACRO_NEXT_DEFINE ( RectangleDest );
  MACRO_NEXT_DEFINE ( RectangleDest ) = TmpPlusRec;
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucInclusionRectangle              |
| Cree     la copie du rectangle 2 s'il est inclus entierement|
| dans le rectangle 1 puis chaine les 2 rectangles source     |
| par le pointeur USER au rectangle cree                      |
| ou retoune NULL                                             |
\------------------------------------------------------------*/

void DrucInclusionRectangle ( DrucFigureRds,
                              DrucRdsWindow,
                              DrucInstructionCourante,
                              Rectangle1,
                              Rectangle2
                            )

              rdsfig_list               *DrucFigureRds;
              rdswindow                 *DrucRdsWindow;
              DrucTypeStructInstruction *DrucInstructionCourante;
     register rdsrec_list               *Rectangle1;
     register rdsrec_list               *Rectangle2;

{

register int          TmpLayerDest    = DrucInstructionCourante->LAYER_DEST;
         rdsrec_list *TmpRectangleDest;

  if ( ( ( Rectangle1->X                  <=
           Rectangle2->X                     ) &&
         ( Rectangle1->X + Rectangle1->DX >=
           Rectangle2->X + Rectangle2->DX    )    ) &&
       ( ( Rectangle1->Y                  <=
           Rectangle2->Y                     ) &&
         ( Rectangle1->Y + Rectangle1->DY >=
           Rectangle2->Y + Rectangle2->DY    )    )
     )
  {
    TmpRectangleDest       = allocrdsrec( sizeof ( DrucTypeStructPlusRect ));
    TmpRectangleDest->X    = Rectangle2->X;
    TmpRectangleDest->Y    = Rectangle2->Y;
    TmpRectangleDest->DX   = Rectangle2->DX;
    TmpRectangleDest->DY   = Rectangle2->DY;

    SetRdsLayer       ( TmpRectangleDest ,
                        TmpLayerDest
                      );
    DrucChaineCompose ( TmpRectangleDest ,
                        Rectangle1,
                        DrucInstructionCourante->LAYER_2
                      );
    DrucChaineCompose ( TmpRectangleDest ,
                        Rectangle2,
                        DrucInstructionCourante->LAYER_1
                      );
    addrdsrecwindow   ( TmpRectangleDest,
                        DrucRdsWindow
                      );
    DrucAddRecFigure  ( TmpRectangleDest ,
                        DrucFigureRds ,
                        TmpLayerDest
                      );
  }
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucIntersectRectangle              |
| Cree un rectangle de dimensions et coordonnees              |
| correspondant a l'intersection des 2 rectangles passes en   |
| parametre                                                   |
| ou retoune NULL si les 2 rectangles ne sont pas en          |
| intersection                                                |
\------------------------------------------------------------*/

void DrucIntersectRectangle ( DrucFigureRds,
                              DrucRdsWindow,
                              DrucInstructionCourante,
                              Rectangle1,
                              Rectangle2
                            )
              rdsfig_list               *DrucFigureRds;

              rdswindow                 *DrucRdsWindow;
              DrucTypeStructInstruction *DrucInstructionCourante;
     register rdsrec_list               *Rectangle1;
     register rdsrec_list               *Rectangle2;

{

register long         TmpDx1          = Rectangle1->X + Rectangle1->DX;
register long         TmpDy1          = Rectangle1->Y + Rectangle1->DY;
register long         TmpDx2          = Rectangle2->X + Rectangle2->DX;
register long         TmpDy2          = Rectangle2->Y + Rectangle2->DY;
register int          TmpLayerDest    = DrucInstructionCourante->LAYER_DEST;
         rdsrec_list *TmpRectangleDest;

  if ( ( TmpDx1 < Rectangle2->X ) ||
       ( TmpDx2 < Rectangle1->X )
     )
  {
    return;
  }

  if ( ( TmpDy1 < Rectangle2->Y ) ||
       ( TmpDy2 < Rectangle1->Y )
     )
  {
    return;
  }

  TmpRectangleDest       = allocrdsrec( sizeof 
                                        ( DrucTypeStructPlusRect )
                                      );

  TmpRectangleDest->X    = ( ( Rectangle1->X < Rectangle2->X ) ?
                             Rectangle2->X :
                             Rectangle1->X
                           );

  TmpRectangleDest->Y    = ( ( Rectangle1->Y < Rectangle2->Y ) ?
                             Rectangle2->Y :
                             Rectangle1->Y
                           );

  TmpRectangleDest->DX   = ( ( TmpDx1 < TmpDx2 ) ?
                             TmpDx1 - TmpRectangleDest->X :
                             TmpDx2 - TmpRectangleDest->X
                           );
  TmpRectangleDest->DY   = ( ( TmpDy1 < TmpDy2 ) ?
                             TmpDy1 - TmpRectangleDest->Y :
                             TmpDy2 - TmpRectangleDest->Y
                           );
  SetRdsLayer       ( TmpRectangleDest ,
                      TmpLayerDest
                    );
  DrucChaineCompose ( TmpRectangleDest ,
                      Rectangle1,
                      DrucInstructionCourante->LAYER_1
                    );
  DrucChaineCompose ( TmpRectangleDest ,
                      Rectangle2,
                      DrucInstructionCourante->LAYER_2
                    );
  addrdsrecwindow   ( TmpRectangleDest ,
                      DrucRdsWindow
                    );
  DrucAddRecFigure  ( TmpRectangleDest ,
                      DrucFigureRds ,
                      TmpLayerDest
                    );
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucExclusionRectangle              |
| Retourne la copie du rectangle 2 si il n'est pas en         |
| intersection ou en contact avec le rectangle 1              |
| ou retoune NULL                                             |
\------------------------------------------------------------*/

void DrucExclusionRectangle ( DrucFigureRds,
                              DrucRdsWindow,
                              DrucInstructionCourante
                            )
     rdsfig_list               *DrucFigureRds;
     rdswindow                 *DrucRdsWindow;
     DrucTypeStructInstruction *DrucInstructionCourante;

{

register rdsrec_list *TmpRectangleDest;
register rdsrec_list *TmpRectangle1;
register int          TmpLayerDest    = DrucInstructionCourante->LAYER_DEST;
register int          TmpLayerSource  = DrucInstructionCourante->LAYER_1;

  for ( TmpRectangle1  = DrucFigureRds->LAYERTAB [ DrucInstructionCourante->LAYER_1 ];
        TmpRectangle1 != (rdsrec_list *)NULL;
        TmpRectangle1  = TmpRectangle1->NEXT
      )
  {
    if ( ( TmpRectangle1->FLAGS &
           DRUC_FLAG_REC_INCLUS   ) == DRUC_NOFLAGS
       )
    {
      TmpRectangleDest       = allocrdsrec( sizeof ( DrucTypeStructPlusRect ));
      TmpRectangleDest->X    = TmpRectangle1->X ;
      TmpRectangleDest->Y    = TmpRectangle1->Y ;
      TmpRectangleDest->DX   = TmpRectangle1->DX ;
      TmpRectangleDest->DY   = TmpRectangle1->DY ;

      SetRdsLayer       ( TmpRectangleDest ,
                          TmpLayerDest
                        );
      DrucChaineCompose ( TmpRectangleDest ,
                          TmpRectangle1,
                          TmpLayerSource
                        );
      addrdsrecwindow   ( TmpRectangleDest ,
                          DrucRdsWindow
                        );
      DrucAddRecFigure  ( TmpRectangleDest ,
                          DrucFigureRds ,
                          TmpLayerDest
                        );
    }
  }
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucMarqueInclusion                 |
| Marque le rectangle 1 si il est en contact avec             |
|      le rectangle 2                                         |
\------------------------------------------------------------*/

void DrucMarqueInclusion ( Rectangle1,
                           Rectangle2
                         )
     register rdsrec_list *Rectangle1;
     register rdsrec_list *Rectangle2;

{

register long TmpDx1 = Rectangle1->X + Rectangle1->DX;
register long TmpDy1 = Rectangle1->Y + Rectangle1->DY;
register long TmpDx2 = Rectangle2->X + Rectangle2->DX;
register long TmpDy2 = Rectangle2->Y + Rectangle2->DY;

  if ( ( TmpDx1 < Rectangle2->X ) ||
       ( TmpDx2 < Rectangle1->X )
     )
  {
    return;
  }

  if ( ( TmpDy1 < Rectangle2->Y ) ||
       ( TmpDy2 < Rectangle1->Y )
     )
  {
    return;
  }

  Rectangle1->FLAGS |= DRUC_FLAG_REC_INCLUS;
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucDefineExclusion                 |
| Definit un layer temporaire caracterise par l'operateur     |
| contenu dans l'instruction ayant les deux layers source     |
| comme operandes                                             |
| range le resultat dans le tableau des layers userdefini par |
| l'instruction                                               |
\------------------------------------------------------------*/

void DrucDefineExclusion ( DrucFigureRds,
                           DrucRdsWindow,
                           DrucInstructionCourante
                         )
     rdsfig_list               *DrucFigureRds;
     rdswindow                 *DrucRdsWindow;
     DrucTypeStructInstruction *DrucInstructionCourante;

{

         rdsrec_list     *TmpRectangleSource;
         rdsrecwin_list  *TmpWindowSource2;
register int              TabIndex2;
register rdswinrec_list  *TabRectangleSource2 = NULL;

  for ( TmpRectangleSource  = DrucFigureRds->LAYERTAB [ DrucInstructionCourante->LAYER_1 ];
        TmpRectangleSource != (rdsrec_list *)NULL;
        TmpRectangleSource  = TmpRectangleSource->NEXT
      )
  {
   /*\
    *  recuperer toutes les fenetres liees au rectangle, marquer le rectangle visite
   \*/
    TmpWindowSource2 = DrucChercheWindow ( TmpRectangleSource
                                         );
    /*\
     * parcours de chaque fenetre
    \*/
    while ( TmpWindowSource2 != (rdsrecwin_list *)NULL
          )
    {
      TabRectangleSource2 = ( TmpWindowSource2->WINDOW )->LAYERTAB
                                 [ DrucInstructionCourante->LAYER_2 ];
      /*\
       * parcours des tableaux de la fenetre du layer 2
      \*/
      while ( TabRectangleSource2 != (rdswinrec_list *)NULL
            )
      {
        /*\
         * parcourir tous les rectangles du layer B
        \*/
        TabIndex2 = 0;

        while ( TabIndex2 < RWI_MAX_REC
              )
        {
          if ( MACRO_RECT_SOURCE2 [ TabIndex2 ] != ( rdsrec_list *)NULL )
          {
            DrucMarqueInclusion ( TmpRectangleSource,
                                  MACRO_RECT_SOURCE2 [ TabIndex2 ]
                                );
          }

          TabIndex2 ++;
        } /* while les rectangles d'un tableau du layer 2 */
        TabRectangleSource2 = TabRectangleSource2->NEXT;
      } /* while les tableaux du layer 2 */
      TmpWindowSource2 = TmpWindowSource2->NEXT;
    } /* while les fenetres du layer 2 */
  } /* for le parcours des rectangles du layer 1 */

  DrucExclusionRectangle ( DrucFigureRds,
                           DrucRdsWindow,
                           DrucInstructionCourante
                         );
  DrucClearFlag          ( DrucFigureRds->LAYERTAB[ DrucInstructionCourante->LAYER_1 ],
                           DRUC_FLAG_REC_INCLUS
                         );
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucDefineInclusion                 |
| Definit un layer temporaire caracterise par l'operateur     |
| contenu dans l'instruction ayant les deux layers source     |
| comme operandes                                             |
| range le resultat dans le tableau des layers userdefini par |
| l'instruction                                               |
\------------------------------------------------------------*/

void DrucDefineInclusion ( DrucFigureRds,
                           DrucRdsWindow,
                           DrucInstructionCourante
                         )
     rdsfig_list               *DrucFigureRds;
     rdswindow                 *DrucRdsWindow;
     DrucTypeStructInstruction *DrucInstructionCourante;

{

         rdsrec_list     *TmpRectangleSource;
         rdsrecwin_list  *TmpWindowSource2;
register int              TabIndex2;
register rdswinrec_list  *TabRectangleSource2 = NULL;

  for ( TmpRectangleSource  = DrucFigureRds->LAYERTAB [ DrucInstructionCourante->LAYER_2 ];
        TmpRectangleSource != (rdsrec_list *)NULL;
        TmpRectangleSource  = TmpRectangleSource->NEXT
      )
  {
   /*\
    *  recuperer toutes les fenetres liees au rectangle, marquer le rectangle visite
   \*/
    TmpWindowSource2 = DrucChercheWindow ( TmpRectangleSource
                                         );
    /*\
     * parcours de chaque fenetre
    \*/
    while ( TmpWindowSource2 != (rdsrecwin_list *)NULL
          )
    {
      TabRectangleSource2 = ( TmpWindowSource2->WINDOW )->LAYERTAB
                                 [ DrucInstructionCourante->LAYER_1 ];
      /*\
       * parcours des tableaux de la fenetre du layer 1
      \*/
      while ( TabRectangleSource2 != (rdswinrec_list *)NULL
            )
      {
        /*\
         * parcourir tous les rectangles du layer 1
        \*/
        TabIndex2 = 0;

        while ( TabIndex2 < RWI_MAX_REC
              )
        {
          if ( MACRO_RECT_SOURCE2 [ TabIndex2 ] != ( rdsrec_list *)NULL )
          {
            DrucInclusionRectangle ( DrucFigureRds,
                                     DrucRdsWindow,
                                     DrucInstructionCourante,
                                     TmpRectangleSource,
                                     MACRO_RECT_SOURCE2 [ TabIndex2 ]
                                   );
          }

          TabIndex2 ++;
        } /* while les rectangles d'un tableau du layer 2 */
        TabRectangleSource2 = TabRectangleSource2->NEXT;
      } /* while les tableaux du layer 2 */
      TmpWindowSource2 = TmpWindowSource2->NEXT;
    } /* while les fenetres du layer 2 */
  } /* for des rectangles du layer 1 */
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucDefineIntersection              |
| Definit un layer temporaire caracterise par l'operateur     |
| contenu dans l'instruction ayant les deux layers source     |
| comme operandes                                             |
| range le resultat dans le tableau des layers userdefini par |
| l'instruction                                               |
\------------------------------------------------------------*/

void DrucDefineIntersection ( DrucFigureRds,
                              DrucRdsWindow,
                              DrucInstructionCourante
                            )
     rdsfig_list               *DrucFigureRds;
     rdswindow                 *DrucRdsWindow;
     DrucTypeStructInstruction *DrucInstructionCourante;

{

         rdsrec_list     *TmpRectangleSource;
         rdsrecwin_list  *TmpWindowSource2;
register int              TabIndex2;
register rdswinrec_list  *TabRectangleSource2 = NULL;

  for ( TmpRectangleSource  = DrucFigureRds->LAYERTAB [ DrucInstructionCourante->LAYER_2 ];
        TmpRectangleSource != (rdsrec_list *)NULL;
        TmpRectangleSource  = TmpRectangleSource->NEXT
      )
  {
   /*\
    *  recuperer toutes les fenetres liees au rectangle, marquer le rectangle visite
   \*/
    TmpWindowSource2 = DrucChercheWindow ( TmpRectangleSource 
                                         );
    /*\
     * parcours de chaque fenetre
    \*/
    while ( TmpWindowSource2 != (rdsrecwin_list *)NULL
          )
    {
      TabRectangleSource2 = ( TmpWindowSource2->WINDOW )->LAYERTAB
                                 [ DrucInstructionCourante->LAYER_1 ];
      /*\
       * parcours des tableaux de la fenetre du layer 2
      \*/
      while ( TabRectangleSource2 != (rdswinrec_list *)NULL
            )
      {
        /*\
         * parcourir tous les rectangles du layer B
        \*/
        TabIndex2 = 0;

        while ( TabIndex2 < RWI_MAX_REC
              )
        {
          if ( MACRO_RECT_SOURCE2 [ TabIndex2 ] != ( rdsrec_list *)NULL )
          {
            DrucIntersectRectangle ( DrucFigureRds,
                                     DrucRdsWindow,
                                     DrucInstructionCourante,
                                     MACRO_RECT_SOURCE2 [ TabIndex2 ],
                                     TmpRectangleSource
                                   );
          }

          TabIndex2 ++;
        } /* while les rectangles d'un tableau du layer 2 */
        TabRectangleSource2 = TabRectangleSource2->NEXT;
      } /* while les tableaux du layer 2 */
      TmpWindowSource2 = TmpWindowSource2->NEXT;
    } /* while les fenetres du layer 2 */
  } /* for le parcours des rectangles du layer 1 */
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucDefineEquipot                   |
| Definit un layer temporaire caracterise par l'union         |
| des deux layers source                                      |
| range le resultat dans le tableau des layers user defini par|
| l'instruction                                               |
\------------------------------------------------------------*/

void DrucDefineUnion ( DrucFigureRds,
                       DrucRdsWindow ,
                       DrucInstructionCourante
                     )
     rdsfig_list               *DrucFigureRds;
     rdswindow                 *DrucRdsWindow;
     DrucTypeStructInstruction *DrucInstructionCourante;

{

         int          TmpLayerDest;
         int          TmpLayerSource1;
         int          TmpLayerSource2;
register rdsrec_list *TmpRectangleSource;
register rdsrec_list *TmpRectangleDest;

  TmpLayerDest    = DrucInstructionCourante->LAYER_DEST;
  TmpLayerSource1 = DrucInstructionCourante->LAYER_1;
  TmpLayerSource2 = DrucInstructionCourante->LAYER_2;
  /*\
   * dupliquer tous les rectangles du layer source 1
  \*/
  for ( TmpRectangleSource  = DrucFigureRds->LAYERTAB[ TmpLayerSource1 ];
        TmpRectangleSource != (rdsrec_list *)NULL;
        TmpRectangleSource  = TmpRectangleSource->NEXT
      )
  {
    TmpRectangleDest         = allocrdsrec ( sizeof ( DrucTypeStructPlusRect ));
    TmpRectangleDest->NEXT   = ( rdsrec_list *)NULL;
    TmpRectangleDest->X      = TmpRectangleSource->X;
    TmpRectangleDest->Y      = TmpRectangleSource->Y;
    TmpRectangleDest->DX     = TmpRectangleSource->DX;
    TmpRectangleDest->DY     = TmpRectangleSource->DY;
    TmpRectangleDest->USER   = ( rdsrec_list *)NULL;
    TmpRectangleDest->NAME   = TmpRectangleSource->NAME;

    SetRdsLayer       ( TmpRectangleDest ,
                        TmpLayerDest
                      );
    MACRO_NEXT_EQUI   ( TmpRectangleDest ) = (rdsrec_list *)NULL;
    DrucChaineCompose ( TmpRectangleDest ,
                        TmpRectangleSource,
                        TmpLayerSource1
                      );
    addrdsrecwindow   ( TmpRectangleDest ,
                        DrucRdsWindow
                      );
    DrucAddRecFigure  ( TmpRectangleDest ,
                        DrucFigureRds ,
                        TmpLayerDest
                      );
  }
  /*\
   * dupliquer tous les rectangles du layer source 2
  \*/

  for ( TmpRectangleSource  = DrucFigureRds->LAYERTAB[ TmpLayerSource2 ];
        TmpRectangleSource != (rdsrec_list *)NULL;
        TmpRectangleSource  = TmpRectangleSource->NEXT
      )
  {
    TmpRectangleDest       = allocrdsrec ( sizeof ( DrucTypeStructPlusRect ));
    TmpRectangleDest->NEXT = ( rdsrec_list *)NULL;
    TmpRectangleDest->X    = TmpRectangleSource->X;
    TmpRectangleDest->Y    = TmpRectangleSource->Y;
    TmpRectangleDest->DX   = TmpRectangleSource->DX;
    TmpRectangleDest->DY   = TmpRectangleSource->DY;
    TmpRectangleDest->USER = (rdsrec_list *)NULL;
    TmpRectangleDest->NAME = TmpRectangleSource->NAME;

    SetRdsLayer       ( TmpRectangleDest ,
                        TmpLayerDest
                      );
    MACRO_NEXT_EQUI   ( TmpRectangleDest ) = (rdsrec_list *)NULL;
    DrucChaineCompose ( TmpRectangleDest ,
                        TmpRectangleSource,
                        TmpLayerSource2
                      );
    addrdsrecwindow   ( TmpRectangleDest ,
                        DrucRdsWindow
                      );
    DrucAddRecFigure  ( TmpRectangleDest ,
                        DrucFigureRds ,
                        TmpLayerDest
                      );
  }
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucDefine                          |
| Definit un layer temporaire caracterise par les parametres  |
| contenus dans la StructInstruction pointee par son numero   |
| puis chaine le layer en equipotentielles                    |
\------------------------------------------------------------*/

void DrucDefine ( DrucFigureRds,
                  DrucRdsWindow ,
                  DrucInstructionCourante
                )
     rdsfig_list               *DrucFigureRds;
     rdswindow                 *DrucRdsWindow;
     DrucTypeStructInstruction *DrucInstructionCourante;

{

  switch ( DrucInstructionCourante->OP_COMPOSE )
  {
  case DRUC_COMPOSE_UNION :
    {
      DrucDefineUnion ( DrucFigureRds,
                        DrucRdsWindow ,
                        DrucInstructionCourante
                      );
      break;
    }
  case DRUC_COMPOSE_INTERSECT :
    {
      DrucDefineIntersection ( DrucFigureRds,
                               DrucRdsWindow,
                               DrucInstructionCourante
                             );
      break;
    }
  case DRUC_COMPOSE_EXCLUSION :
    {
      DrucDefineExclusion ( DrucFigureRds,
                            DrucRdsWindow,
                            DrucInstructionCourante
                          );
      break;
    }
  case DRUC_COMPOSE_INCLUSION :
    {
      DrucDefineInclusion ( DrucFigureRds,
                            DrucRdsWindow,
                            DrucInstructionCourante
                          );
      break;
    }
  }/* switch */

  DrucComputeEquiLayer ( DrucFigureRds ,
                         DrucInstructionCourante->LAYER_DEST
                       );
/*\
DrucViewString      (" DEFINE: COMPUTE EQUI AVANT UNIFICATION \n"
                    );
DrucVerifEquiLayer  ( DrucFigureRds,
                      DrucInstructionCourante->LAYER_DEST
                    );
DrucViewString      (" DEFINE: FIN COMPUTE EQUI AVANT UNIFICATION \n"
                    );
\*/


  DrucStructRdsLayer [ DrucInstructionCourante->LAYER_DEST ].WIDTH = 
          ( DrucStructRdsLayer [ DrucInstructionCourante->LAYER_1 ].WIDTH > 
               DrucStructRdsLayer [ DrucInstructionCourante->LAYER_2 ].WIDTH ? 
            DrucStructRdsLayer [ DrucInstructionCourante->LAYER_1 ].WIDTH :
            DrucStructRdsLayer [ DrucInstructionCourante->LAYER_2 ].WIDTH 
          );

  DrucStructRdsLayer [ DrucInstructionCourante->LAYER_DEST ].CTM = 
          ( DrucStructRdsLayer [ DrucInstructionCourante->LAYER_1 ].CTM > 
               DrucStructRdsLayer [ DrucInstructionCourante->LAYER_2 ].CTM ? 
            DrucStructRdsLayer [ DrucInstructionCourante->LAYER_1 ].CTM :
            DrucStructRdsLayer [ DrucInstructionCourante->LAYER_2 ].CTM 
          );

  DrucUnifyLayer         ( DrucFigureRds,
                           DrucRdsWindow,
                           DrucInstructionCourante->LAYER_DEST
                         );
  DrucDestroyLayerWindow ( DrucFigureRds,
                           DrucRdsWindow,
                           DrucInstructionCourante->LAYER_DEST
                         );
  DrucBuiltLayerWindow   ( DrucFigureRds,
                           DrucRdsWindow,
                           DrucInstructionCourante->LAYER_DEST
                         ); 
/*\
 *  On reconstruit les equi car l'unificateur a modifie les rectangles
 *  il en a modifie, detruit et cree
\*/
  DrucComputeEquiLayer   ( DrucFigureRds ,
                           DrucInstructionCourante->LAYER_DEST
                         );
/*\
DrucViewString     (" DEFINE: COMPUTE EQUI APRES UNIFICATION \n"
                   );
DrucViewString     ( RDS_LAYER_NAME[DrucInstructionCourante->LAYER_1]
                   );
DrucViewString     (": c'est le Layer source \n");
DrucViewString     ( RDS_LAYER_NAME[DrucInstructionCourante->LAYER_2]
                   );
DrucViewString     (": c'est le Layer source \n");

DrucVerifEquiLayer ( DrucFigureRds,
                     DrucInstructionCourante->LAYER_DEST
                   );
DrucViewString     (" DEFINE: FIN COMPUTE EQUI APRES UNIFICATION \n");
\*/
}

/*------------------------------------------------------------\
|                                                             |
|                         DrucUndefine                        |
| Detruit le layer temporaire caracterise par les parametres  |
| contenus dans la StructInstruction pointee par son numero   |
| on parcourt tous les rectangles du layer defini dans la     |
|   fenetre et on les remet dans le tas gere par rdswin       |
\------------------------------------------------------------*/

void DrucUndefine ( DrucFigureRds ,
                    DrucRdsWindow,
                    DrucInstructionCourante
                  )
     rdsfig_list               *DrucFigureRds;
     rdswindow                 *DrucRdsWindow;
     DrucTypeStructInstruction *DrucInstructionCourante;

{

register rdsrec_list            *TmpRectangleDest;
register rdsrec_list            *TmpRectangleSuivant;
register rdsrecwin_list         *RecWin;
register rdsrecwin_list         *DelRecWin;
         DrucTypeStructPlusRect *TmpPlusRec;
         DrucTypeStructPlusRect *TmpPlusRecSuivant;
  /*\
   * detruire la window associee au layer
  \*/
  for ( TmpRectangleDest  = DrucFigureRds->LAYERTAB[ DrucInstructionCourante->LAYER_1 ];
        TmpRectangleDest != (rdsrec_list *)NULL;
        TmpRectangleDest  = TmpRectangleDest->NEXT 
      )
  {
    delrdsrecwindow ( TmpRectangleDest, 
                      DrucRdsWindow 
                    );
  }
  /*\
   * detruire les rectangles du layer
  \*/
  TmpRectangleDest  = DrucFigureRds->LAYERTAB[ DrucInstructionCourante->LAYER_1 ];

  while ( TmpRectangleDest != (rdsrec_list *)NULL 
        )
  {
    if ( MACRO_NEXT_DEFINE ( TmpRectangleDest ) != ( DrucTypeStructPlusRect *)NULL
       )
    {
      /*\
       * destruction des StructPlusRect du rectangle scourant
      \*/
      TmpPlusRec = MACRO_NEXT_DEFINE ( TmpRectangleDest );

      while ( TmpPlusRec != ( DrucTypeStructPlusRect *)NULL
            )
      {
        TmpPlusRecSuivant = TmpPlusRec->NEXT_DEFINE;

        rdsfree ( TmpPlusRec ,
                  MACRO_PLUS_TAILLE
                );

        TmpPlusRec = TmpPlusRecSuivant;
      }
    }
    TmpRectangleSuivant = TmpRectangleDest->NEXT;

      /*\
       * destruction du rectangle courant dans la fenetre
      \*/
    delrdsrecwindow ( TmpRectangleDest,
                      DrucRdsWindow
                    );
      /*\
       * destruction du rectangle courant dans la figure
      \*/
    freerdsrec ( TmpRectangleDest,
                 sizeof ( DrucTypeStructPlusRect )
               );

    TmpRectangleDest = TmpRectangleSuivant;
  }

  DrucFigureRds->LAYERTAB[ DrucInstructionCourante->LAYER_1 ] = 
  
      (rdsrec_list *)NULL;
}
/*
 * algo de NotInclus:
 * 
 * Pour tout rectangle a
 *  si a n,est pas marque
 *   alors
 *    Pour tout rectangle b
 *      si a est entierement inclus dans b
 *       alors
 *        je le marque
 *      fsi
 *   fpour b
 *  fsi
 *  si a n'est pas marque 
 *   alors 
 *     je le met dans le layer utilisateur
 * fpour a
 */
