/*------------------------------------------------------------\
|                                                             |
| Tool    :                    DRUC                           |
|                                                             |
| File    :                  VMCMESUR.C                       |
|                                                             |
| Authors :                Renaud Patrick                     |
|                                                             |
| Date    :                   11/01/94                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include MPH_H
#include MUT_H
#include RDS_H
#include RUT_H
#include RTL_H
#include RWI_H
#include RFM_H
#include RPR_H

#include "drucutil.h"
#include "vmctools.h"
#include "vmcerror.h"
#include "vmcmesur.h"
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Fonctions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          DrucRelationSetDistance            |
|                                                             |
\------------------------------------------------------------*/
void DrucRelationSetDistance ( DrucStructMesure,
                               Mesure1,
                               Mesure2
                             )
     DrucTypeStructMesure *DrucStructMesure;
     long                  Mesure1;
     long                  Mesure2;
{
  if ( Mesure1 > Mesure2 )
  {
    MACRO_LONG_DISTANCE    = Mesure1;
    if ( Mesure2 >= 0 )
    {
      MACRO_LARGE_DISTANCE = Mesure2;
    }
    else
    {
      MACRO_LARGE_DISTANCE = Mesure1;
    }
  }
  else
  {
    MACRO_LONG_DISTANCE    = Mesure2;
    if ( Mesure1 >= 0 )
    {
      MACRO_LARGE_DISTANCE = Mesure1;
    }
    else
    {
      MACRO_LARGE_DISTANCE = Mesure2;
    }
  }
}
/*------------------------------------------------------------\
|                                                             |
|                                                             |
|    +--+     +--------+    +--------+      +--------+        |
|    |A |     |B       |    |B       |      |       B|        |
| +--|..|--+  |    +------+ |  +--+  |  +-------+    |        |
| |  |  |  |  |    |   . A| |  |  |  |  |A  .   |    |        |
| |  +--+  |  |    +------+ +--|..|--+  +-------+    |        |
| |B       |  |        |       | A|         |        |        |
| +--------+  +--------+       +--+         +--------+        |
|   cas 2        cas 8        cas 5           cas 7           |
|                                                             |
| +---+           +-----+   +----+           +-----+          |
| |A  |           |    A|   |B   |           |    B|          |
| | ..|--+     +--|...  |   | +-----+    +-----+   |          |
| | . |  |     |  |  .  |   | |  .  |    |   . |   |          |
| +---+  |     |  +-----+   +-|...  |    |   ..|---+          |
|   |   B|     |B    |        |    A|    |A    |              |
|   +----+     +-----+        +-----+    +-----+              |
|   cas 1         cas 3        cas 6       cas 4              |
|                                                             |
|                                                             |
|    +--+     +--------+    +--------+      +--------+        |
|    |B |     |A       |    |A       |      |       A|        |
| +--|..|--+  |    +------+ |  +--+  |  +-------+    |        |
| |  |  |  |  |    |   . B| |  |  |  |  |B  .   |    |        |
| |  +--+  |  |    +------+ +--|..|--+  +-------+    |        |
| |A       |  |        |       | B|         |        |        |
| +--------+  +--------+       +--+         +--------+        |
|   cas 2        cas 8        cas 5           cas 7           |
|                                                             |
|   +--+          +-----+   +----+           +-----+          |
|   |  |          |    A|   |B   |           |    B|          |
|   |  |       +--------+   | +-----+    +-----+   |          |
|   |  |       |        |   | |  .  |    |   . |   |          |
|   |  |       +--------+   +-|...  |    |   ..|---+          |
|   |  |       |  +-----+   +-|...  |    |   ..|---+          |
|   |  |       |B    |        |    A|    |A    |              |
|   +--+       +-----+        +-----+    +-----+              |
|   cas 1         cas 3        cas 6       cas 4              |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          DrucRelationMesure                 |
|                                                             |
\------------------------------------------------------------*/
void DrucRelationMesure ( DrucStructMesure
                        )
     DrucTypeStructMesure *DrucStructMesure;
{
long XA          =         MACRO_RECTANGLE1->X;
long YA          =         MACRO_RECTANGLE1->Y;
long XB          =         MACRO_RECTANGLE2->X;
long YB          =         MACRO_RECTANGLE2->Y;
long DXA         =         MACRO_RECTANGLE1->DX;
long DYA         =         MACRO_RECTANGLE1->DY;
long DXB         =         MACRO_RECTANGLE2->DX;
long DYB         =         MACRO_RECTANGLE2->DY;
long FinXA       = XA    + DXA;
long FinXB       = XB    + DXB;
long FinYA       = YA    + DYA;
long FinYB       = YB    + DYB;
long ExtenXAXB   = XA    - XB;
long ExtenDXAXB  = FinXA - XB;
long ExtenDXADXB = FinXA - FinXB;
long ExtenYAYB   = YA    - YB;
long ExtenDYAYB  = FinYA - YB;
long ExtenDYADYB = FinYA - FinYB;
long ExtenXBXA   =       - ExtenXAXB;
long ExtenDXBXA  = FinXB - XA;
long ExtenYBYA   =       - ExtenYAYB;
long ExtenDYBYA  = FinYB - YA;
long ExtenXADXB  = XA    - FinXB;
long ExtenYADYB  = YA    - FinYB;
long ExtenXBDXA  = XB    - FinXA;
long ExtenYBDYA  = YB    - FinYA;
int  TmpCas;

  TmpCas = 0;
  if ( XA >= XB )
  {
    TmpCas |= 1;
  }
  if ( FinXA <= FinXB )
  {
    TmpCas |= 2;
  }
  if ( YA >= YB )
  {
    TmpCas |= 4;
  }
  if ( FinYA <= FinYB )
  {
    TmpCas |= 8;
  }
  MACRO_TOPOLOGIE = TmpCas;
  switch ( TmpCas )
  {
  case 0  :
    { /* B inclus dans A */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_ENVELOPPE;
      MACRO_SURFACE_INTER = DXB * DYB;
      if ( DXB > DYB )
      {
        MACRO_LONG_INTER  = DXB;
        MACRO_LARGE_INTER = DYB;
        if ( ExtenDYADYB  > ExtenYBYA )
        {
          MACRO_LONG_MAX  = ExtenDYADYB;
          MACRO_LONG_MIN  = ExtenYBYA;
        }
        else
        {
          MACRO_LONG_MIN  = ExtenDYADYB;
          MACRO_LONG_MAX  = ExtenYBYA;
        }
        if ( ExtenDXADXB  > ExtenXBXA )
        {
          MACRO_LARGE_MAX = ExtenDXADXB;
          MACRO_LARGE_MIN = ExtenXBXA;
        }
        else
        {
          MACRO_LARGE_MIN = ExtenDXADXB;
          MACRO_LARGE_MAX = ExtenXBXA;
        }
      }
      else
      {
        MACRO_LONG_INTER  = DYB;
        MACRO_LARGE_INTER = DXB;
        if ( ExtenDXADXB  > ExtenXBXA )
        {
          MACRO_LONG_MAX  = ExtenDXADXB;
          MACRO_LONG_MIN  = ExtenXBXA;
        }
        else
        {
          MACRO_LONG_MIN  = ExtenDXADXB;
          MACRO_LONG_MAX  = ExtenXBXA;
        }
        if ( ExtenDYADYB  > ExtenYBYA )
        {
          MACRO_LARGE_MAX = ExtenDYADYB;
          MACRO_LARGE_MIN = ExtenYBYA;
        }
        else
        {
          MACRO_LARGE_MIN = ExtenDYADYB;
          MACRO_LARGE_MAX = ExtenYBYA;
        }
      }
      MACRO_SUP           =  ( MACRO_LONG_MAX  >
                               MACRO_LARGE_MAX   ?
                               MACRO_LONG_MAX    :
                               MACRO_LARGE_MAX
                             );
      MACRO_INF           =  ( MACRO_LONG_MIN  <
                               MACRO_LARGE_MIN   ?
                               MACRO_LONG_MIN    :
                               MACRO_LARGE_MIN
                             );
      break;
    }
  case 1  :
    { /* B penetre A par X */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_MARGE;
      MACRO_SURFACE_INTER = ExtenDXBXA * DYB;
      MACRO_FRONT         = ExtenDXADXB;
      MACRO_LONG_DISTANCE = ExtenXADXB;
      MACRO_PENETRE_INTER = ExtenDXBXA;
      if ( ExtenDXBXA     > DYB )
      {
        MACRO_LONG_INTER  = ExtenDXBXA;
        MACRO_LARGE_INTER = DYB;
        MACRO_LARGE_MIN   = ExtenDXADXB;
        MACRO_LARGE_MAX   = ExtenDXADXB;
        if ( ExtenDYADYB  > ExtenYBYA )
        {
          MACRO_LATER_MAX = ExtenDYADYB;
          MACRO_LATER_MIN = ExtenYBYA;
          MACRO_LONG_MAX  = ExtenDYADYB;
          MACRO_LONG_MIN  = ExtenYBYA;
        }
        else
        {
          MACRO_LATER_MIN = ExtenDYADYB;
          MACRO_LATER_MAX = ExtenYBYA;
          MACRO_LONG_MIN  = ExtenDYADYB;
          MACRO_LONG_MAX  = ExtenYBYA;
        }
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXBXA;
        MACRO_LONG_INTER  = DYB;
        MACRO_LONG_MIN    = ExtenDXADXB;
        MACRO_LONG_MAX    = ExtenDXADXB;
        if ( ExtenDYADYB  > ExtenYBYA )
        {
          MACRO_LATER_MAX = ExtenDYADYB;
          MACRO_LATER_MIN = ExtenYBYA;
          MACRO_LARGE_MAX = ExtenDYADYB;
          MACRO_LARGE_MIN = ExtenYBYA;
        }
        else
        {
          MACRO_LATER_MIN = ExtenDYADYB;
          MACRO_LATER_MAX = ExtenYBYA;
          MACRO_LARGE_MIN = ExtenDYADYB;
          MACRO_LARGE_MAX = ExtenYBYA;
        }
      }
      MACRO_SUP           =  ( MACRO_FRONT      >
                               MACRO_LATER_MAX  ?
                               MACRO_FRONT        :
                               MACRO_LARGE_MAX
                             );
      MACRO_INF           =  ( MACRO_FRONT      <
                               MACRO_LATER_MIN  ?
                               MACRO_FRONT        :
                               MACRO_LATER_MIN
                             );
      break;
    }
  case 2  :
    { /* B penetre A par DX */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_MARGE;
      MACRO_SURFACE_INTER = ExtenDXAXB * DYB;
      MACRO_FRONT         = ExtenXBXA;
      MACRO_LONG_DISTANCE = ExtenXBDXA;
      MACRO_PENETRE_INTER = ExtenDXAXB;
      if ( ExtenDXAXB     > DYB )
      {
        MACRO_LONG_INTER  = ExtenDXAXB;
        MACRO_LARGE_INTER = DYB;
        MACRO_LARGE_MIN   = ExtenXBXA;
        MACRO_LARGE_MAX   = ExtenXBXA;
        if ( ExtenDYADYB  > ExtenYBYA )
        {
          MACRO_LATER_MAX = ExtenDYADYB;
          MACRO_LATER_MIN = ExtenYBYA;
          MACRO_LONG_MAX  = ExtenDYADYB;
          MACRO_LONG_MIN  = ExtenYBYA;
        }
        else
        {
          MACRO_LATER_MIN = ExtenDYADYB;
          MACRO_LATER_MAX = ExtenYBYA;
          MACRO_LONG_MIN  = ExtenDYADYB;
          MACRO_LONG_MAX  = ExtenYBYA;
        }
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXAXB;
        MACRO_LONG_INTER  = DYB;
        MACRO_LONG_MIN    = ExtenXBXA;
        MACRO_LONG_MAX    = ExtenXBXA;
        if ( ExtenDYADYB  > ExtenYBYA )
        {
          MACRO_LATER_MAX = ExtenDYADYB;
          MACRO_LATER_MIN = ExtenYBYA;
          MACRO_LARGE_MAX = ExtenDYADYB;
          MACRO_LARGE_MIN = ExtenYBYA;
        }
        else
        {
          MACRO_LATER_MIN = ExtenDYADYB;
          MACRO_LATER_MAX = ExtenYBYA;
          MACRO_LARGE_MIN = ExtenDYADYB;
          MACRO_LARGE_MAX = ExtenYBYA;
        }
      }
      MACRO_SUP           =  ( MACRO_FRONT       >
                               MACRO_LATER_MAX   ?
                               MACRO_FRONT          :
                               MACRO_LARGE_MAX
                             );
      MACRO_INF           =  ( MACRO_FRONT       <
                               MACRO_LATER_MIN   ?
                               MACRO_FRONT          :
                               MACRO_LATER_MIN
                             );
      break;
    }
  case 3  :
    { /* B penetre et ressort de A par X */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_CROIX;
      MACRO_SURFACE_INTER = DXA * DYB;
      MACRO_PARAL_INTER   = DYB;
      MACRO_PERPEN_INTER  = DXA;
      if ( ExtenDYADYB  > ExtenYBYA )
      {
        MACRO_LONG_MAX  = ExtenDYADYB;
        MACRO_LONG_MIN  = ExtenYBYA;
      }
      else
      {
        MACRO_LONG_MIN  = ExtenDYADYB;
        MACRO_LONG_MAX  = ExtenYBYA;
      }
      if ( DXA            > DYB )
      {
        MACRO_LONG_INTER  = DXA;
        MACRO_LARGE_INTER = DYB;
      }
      else
      {
        MACRO_LARGE_INTER = DXA;
        MACRO_LONG_INTER  = DYB;
      }
      break;
    }
  case 4  :
    { /* B penetre A par Y */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_MARGE;
      MACRO_SURFACE_INTER = ExtenDYBYA * DXB;
      MACRO_FRONT         = ExtenDYADYB;
      MACRO_LONG_DISTANCE = ExtenYADYB;
      MACRO_PENETRE_INTER = ExtenDYBYA;
      if ( ExtenDYBYA     > DXB )
      {
        MACRO_LONG_INTER  = ExtenDYBYA;
        MACRO_LARGE_INTER = DXB;
        MACRO_LARGE_MIN   = ExtenDYADYB;
        MACRO_LARGE_MAX   = ExtenDYADYB;
        if ( ExtenDXADXB  > ExtenXBXA )
        {
          MACRO_LATER_MAX = ExtenDXADXB;
          MACRO_LATER_MIN = ExtenXBXA;
          MACRO_LONG_MAX  = ExtenDXADXB;
          MACRO_LONG_MIN  = ExtenXBXA;
        }
        else
        {
          MACRO_LATER_MIN = ExtenDXADXB;
          MACRO_LATER_MAX = ExtenXBXA;
          MACRO_LONG_MIN  = ExtenDXADXB;
          MACRO_LONG_MAX  = ExtenXBXA;
        }
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDYADYB;
        MACRO_LONG_INTER  = DXB;
        MACRO_LONG_MIN    = ExtenDYADYB;
        MACRO_LONG_MAX    = ExtenDYADYB;
        if ( ExtenDXADXB  > ExtenXBXA )
        {
          MACRO_LATER_MAX = ExtenDXADXB;
          MACRO_LATER_MIN = ExtenXBXA;
          MACRO_LARGE_MAX = ExtenDXADXB;
          MACRO_LARGE_MIN = ExtenXBXA;
        }
        else
        {
          MACRO_LONG_MIN  = ExtenDXADXB;
          MACRO_LONG_MAX  = ExtenXBXA;
          MACRO_LARGE_MIN = ExtenDXADXB;
          MACRO_LARGE_MAX = ExtenXBXA;
        }
      }
      MACRO_SUP           =  ( MACRO_FRONT       >
                               MACRO_LATER_MAX   ?
                               MACRO_FRONT          :
                               MACRO_LARGE_MAX
                             );
      MACRO_INF           =  ( MACRO_FRONT       <
                               MACRO_LATER_MIN   ?
                               MACRO_FRONT          :
                               MACRO_LATER_MIN
                             );
      break;
    }
  case 5  :
    { /* B penetre A par XY */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_INTERSECTION;
      MACRO_SURFACE_INTER = ExtenDXBXA * ExtenDYBYA;
      if ( ExtenDXBXA     > ExtenDYBYA )
      {
        MACRO_LONG_INTER  = ExtenDXBXA;
        MACRO_LARGE_INTER = ExtenDYBYA;
        MACRO_LONG_MAX    = ExtenDYADYB;
        MACRO_LARGE_MAX   = ExtenDXADXB;
        MACRO_SUP         = ExtenDYADYB;
        MACRO_INF         = ExtenDXADXB;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXBXA;
        MACRO_LONG_INTER  = ExtenDYBYA;
        MACRO_LONG_MAX    = ExtenDXADXB;
        MACRO_LARGE_MAX   = ExtenDYADYB;
        MACRO_SUP         = ExtenDXADXB;
        MACRO_INF         = ExtenDYADYB;
      }
      DrucRelationSetDistance ( DrucStructMesure,
                                ExtenXADXB,
                                ExtenYADYB
                              );
      break;
    }
  case 6  :
    { /* B penetre A par DXY */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_INTERSECTION;
      MACRO_SURFACE_INTER = ExtenDXAXB * ExtenDYBYA;
      if ( ExtenDXAXB     > ExtenDYBYA )
      {
        MACRO_LONG_INTER  = ExtenDXAXB;
        MACRO_LARGE_INTER = ExtenDYBYA;
        MACRO_LONG_MAX    = ExtenDYADYB;
        MACRO_LARGE_MAX   = ExtenXBXA;
        MACRO_SUP         = ExtenDYADYB;
        MACRO_INF         = ExtenXBXA;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXAXB;
        MACRO_LONG_INTER  = ExtenDYBYA;
        MACRO_LONG_MAX    = ExtenXBXA;
        MACRO_LARGE_MAX   = ExtenDYADYB;
        MACRO_SUP         = ExtenXBXA;
        MACRO_INF         = ExtenDYADYB;
      }
      DrucRelationSetDistance ( DrucStructMesure,
                                ExtenXBDXA,
                                ExtenYADYB
                              );
      break;
    }
  case 7  :
    { /* A penetre B par DY */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_EXTENSION;
      MACRO_SURFACE_INTER = ExtenDYBYA * DXA;
      MACRO_LONG_DISTANCE = ExtenYADYB;
      MACRO_LONG_MAX      = ExtenDYADYB;
      MACRO_PENETRE_INTER = ExtenDYBYA;
      if ( ExtenDYBYA     > DXA )
      {
        MACRO_LONG_INTER  = ExtenDYBYA;
        MACRO_LARGE_INTER = DXA;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDYBYA;
        MACRO_LONG_INTER  = DXA;
      }
      break;
    }
  case 8  :
    { /* B penetre A par DY */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_MARGE;
      MACRO_SURFACE_INTER = ExtenDYAYB * DXB;
      MACRO_FRONT         = ExtenYBYA;
      MACRO_LONG_DISTANCE = ExtenYBDYA;
      MACRO_PENETRE_INTER = ExtenDYAYB;
      if ( ExtenDYAYB     > DXB )
      {
        MACRO_LONG_INTER  = ExtenDYAYB;
        MACRO_LARGE_INTER = DXB;
        MACRO_LARGE_MIN   = ExtenYBYA;
        MACRO_LARGE_MAX   = ExtenYBYA;
        if ( ExtenDXADXB  > ExtenXBXA )
        {
          MACRO_LATER_MAX = ExtenDXADXB;
          MACRO_LATER_MIN = ExtenXBXA;
          MACRO_LONG_MAX  = ExtenDXADXB;
          MACRO_LONG_MIN  = ExtenXBXA;
        }
        else
        {
          MACRO_LATER_MIN = ExtenDXADXB;
          MACRO_LATER_MAX = ExtenXBXA;
          MACRO_LONG_MIN  = ExtenDXADXB;
          MACRO_LONG_MAX  = ExtenXBXA;
        }
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDYAYB;
        MACRO_LONG_INTER  = DXB;
        MACRO_LONG_MIN    = ExtenYBYA;
        MACRO_LONG_MAX    = ExtenYBYA;
        if ( ExtenDXADXB  > ExtenXBXA )
        {
          MACRO_LATER_MAX = ExtenDXADXB;
          MACRO_LATER_MIN = ExtenXBXA;
          MACRO_LARGE_MAX = ExtenDXADXB;
          MACRO_LARGE_MIN = ExtenXBXA;
        }
        else
        {
          MACRO_LATER_MIN = ExtenDXADXB;
          MACRO_LATER_MAX = ExtenXBXA;
          MACRO_LARGE_MIN = ExtenDXADXB;
          MACRO_LARGE_MAX = ExtenXBXA;
        }
      }
      break;
    }
  case 9  :
    { /* B penetre A par XDY */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_INTERSECTION;
      MACRO_SURFACE_INTER = ExtenDXBXA * ExtenDYAYB;
      if ( ExtenDXBXA     > ExtenDYAYB )
      {
        MACRO_LONG_INTER  = ExtenDXBXA;
        MACRO_LARGE_INTER = ExtenDYAYB;
        MACRO_LONG_MAX    = ExtenYBYA;
        MACRO_LARGE_MAX   = ExtenDXADXB;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXBXA;
        MACRO_LONG_INTER  = ExtenDYAYB;
        MACRO_LONG_MAX    = ExtenDXADXB;
        MACRO_LARGE_MAX   = ExtenYBYA;
      }
      DrucRelationSetDistance ( DrucStructMesure,
                                ExtenXADXB,
                                ExtenYBDYA
                              );
      break;
    }
  case 10 :
    { /* B penetre A par DXDY */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_INTERSECTION;
      MACRO_SURFACE_INTER = ExtenDXAXB * ExtenDYAYB;
      if ( ExtenDXAXB     > ExtenDYAYB )
      {
        MACRO_LONG_INTER  = ExtenDXAXB;
        MACRO_LARGE_INTER = ExtenDYAYB;
        MACRO_LARGE_MAX   = ExtenXBXA;
        MACRO_LONG_MAX    = ExtenYBYA;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXAXB;
        MACRO_LONG_INTER  = ExtenDYAYB;
        MACRO_LONG_MAX    = ExtenXBXA;
        MACRO_LARGE_MAX   = ExtenYBYA;
      }
      DrucRelationSetDistance ( DrucStructMesure,
                                ExtenYBDYA,
                                ExtenXBDXA
                              );
      break;
    }
  case 11 :
    { /* A penetre B par Y */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_EXTENSION;
      MACRO_SURFACE_INTER = ExtenDYAYB * DXA;
      MACRO_LONG_DISTANCE = ExtenYBDYA;
      MACRO_LONG_MAX      = ExtenYBYA;
      MACRO_PENETRE_INTER = ExtenDYAYB;
      if ( ExtenDYAYB     > DXA )
      {
        MACRO_LONG_INTER  = ExtenDYAYB;
        MACRO_LARGE_INTER = DXA;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDYAYB;
        MACRO_LONG_INTER  = DXA;
      }
      break;
    }
  case 12 :
    { /* B penetre et ressort de A par Y */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_CROIX;
      MACRO_SURFACE_INTER = DXA * DYB;
      MACRO_PARAL_INTER   = DXB;
      MACRO_PERPEN_INTER  = DYA;
      if ( DXA            > DYB )
      {
        MACRO_LONG_INTER  = DXA;
        MACRO_LARGE_INTER = DYB;
      }
      else
      {
        MACRO_LARGE_INTER = DXA;
        MACRO_LONG_INTER  = DYB;
      }
      if ( ExtenDXADXB  > ExtenXBXA )
      {
        MACRO_LONG_MAX  = ExtenDXADXB;
        MACRO_LONG_MIN  = ExtenXBXA;
      }
      else
      {
        MACRO_LONG_MIN  = ExtenDXADXB;
        MACRO_LONG_MAX  = ExtenXBXA;
      }
      break;
    }
  case 13 :
    { /* B penetre A par XYDY */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_EXTENSION;
      MACRO_SURFACE_INTER = ExtenDXBXA * DYA;
      MACRO_LONG_MAX      = ExtenDXADXB;
      MACRO_LONG_DISTANCE = ExtenXADXB;
      MACRO_PENETRE_INTER = ExtenDXBXA;
      if ( ExtenDXBXA     > DYA )
      {
        MACRO_LONG_INTER  = ExtenDXBXA;
        MACRO_LARGE_INTER = DYA;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXBXA;
        MACRO_LONG_INTER  = DYA;
      }
      break;
    }
  case 14 :
    { /* A penetre B par X */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_EXTENSION;
      MACRO_SURFACE_INTER = ExtenDXAXB * DYA;
      MACRO_LONG_MAX      = ExtenXBXA;
      MACRO_LONG_DISTANCE = ExtenXBDXA;
      MACRO_PENETRE_INTER = ExtenDXAXB;
      if ( ExtenDXAXB     > DYA )
      {
        MACRO_LONG_INTER  = ExtenDXAXB;
        MACRO_LARGE_INTER = DYA;
      }
      else
      {
        MACRO_LARGE_INTER = ExtenDXAXB;
        MACRO_LONG_INTER  = DYA;
      }
      break;
    }
  case 15 :
    { /* A penetre B par X */
      MACRO_ORIENTATION   = DRUC_ORIENTATION_INCLUSION;
      MACRO_SURFACE_INTER = DXA * DYA;
      if ( DXA            > DYA )
      {
        MACRO_LONG_INTER  = DXA;
        MACRO_LARGE_INTER = DYA;
      }
      else
      {
        MACRO_LARGE_INTER = DXA;
        MACRO_LONG_INTER  = DYA;
      }
    }
  }/* switch */
}
/*------------------------------------------------------------\
|                                                             |
|                          DrucRelationTeste                  |
|                                                             |
\------------------------------------------------------------*/
void DrucRelationTeste ( DrucStructMesure,
                         DrucInstructionCourante,
                         IndexMesure,
                         Mesure
                       )
     DrucTypeStructMesure      *DrucStructMesure;
     DrucTypeStructInstruction *DrucInstructionCourante;
     int                        IndexMesure;
     long                       Mesure;
{

  DrucStructMesure->MESURE_EFFECTIVE = Mesure;
  switch ( DrucInstructionCourante->OP_COMPARE [ IndexMesure ] )
  {
  case DRUC_OPERATION_INF :
    {
      if ( Mesure >= DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_INFEQ :
    {
      if ( Mesure > DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_SUP :
    {
      if ( Mesure <= DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_SUPEQ :
    {
      if ( Mesure < DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_DIFF :
    {
      if ( Mesure == DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_MIN :
    {
      if ( Mesure < DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_MAX :
    {
      if ( Mesure > DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  } /* switch */
}

/*------------------------------------------------------------\
|                                                             |
|                          DrucRelationTesteDistance          |
|                                                             |
\------------------------------------------------------------*/
void DrucRelationTesteDistance ( DrucStructMesure,
                                 DrucInstructionCourante,
                                 IndexMesure,
                                 Mesure
                               )
     DrucTypeStructMesure      *DrucStructMesure;
     DrucTypeStructInstruction *DrucInstructionCourante;
     int                        IndexMesure;
     long                       Mesure;
{

  DrucStructMesure->MESURE_EFFECTIVE = Mesure;
  switch ( DrucInstructionCourante->OP_COMPARE [ IndexMesure ] )
  {
  case DRUC_OPERATION_INF :
    {
      if ( Mesure >= DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_INFEQ :
    {
      if ( Mesure > DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_SUP :
    {
      if ( Mesure <= DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_SUPEQ :
    {
      if ( Mesure < DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_DIFF :
    {
      if ( Mesure == DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_MIN :
    {
/*\
printf ("\nDRUC_OPERATION_MIN: %d  %d\n",Mesure,DrucInstructionCourante->VALEUR [ IndexMesure ]);
\*/
      if ( Mesure < DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucIsPositionInclusInEqui ( DrucStructMesure,
                                     DrucInstructionCourante,
                                     IndexMesure,
                                     MACRO_RECTANGLE2->X,
                                     MACRO_RECTANGLE2->Y,
                                     MACRO_RECTANGLE2->X + MACRO_RECTANGLE2->DX,
                                     MACRO_RECTANGLE2->Y + MACRO_RECTANGLE2->DY
                                   );
      }
      break;
    }
  case DRUC_OPERATION_MAX :
    {
      if ( Mesure > DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucIsPositionInclusInEqui ( DrucStructMesure,
                                     DrucInstructionCourante,
                                     IndexMesure,
                                     MACRO_RECTANGLE2->X,
                                     MACRO_RECTANGLE2->Y,
                                     MACRO_RECTANGLE2->X + MACRO_RECTANGLE2->DX,
                                     MACRO_RECTANGLE2->Y + MACRO_RECTANGLE2->DY
                                   );
      }
      break;
    }
  } /* switch */
}

/*------------------------------------------------------------\
|                                                             |
|                          DrucRelationTesteInter             |
|                                                             |
\------------------------------------------------------------*/
void DrucMesureTesteInter ( DrucStructMesure,
                            DrucInstructionCourante,
                            IndexMesure
                          )
     DrucTypeStructMesure      *DrucStructMesure;
     DrucTypeStructInstruction *DrucInstructionCourante;
     int                        IndexMesure;
{
rdsrec_list            *RectangleSource;
long PositionX;
long PositionY;
long PositionDX;
long PositionDY;

  RectangleSource            = DrucStructMesure->RECTANGLE1;
  switch ( MACRO_TOPOLOGIE )
  {
    case 0:
    {
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = PositionX + MACRO_RECTANGLE2->DX;
      PositionDY = PositionY + MACRO_RECTANGLE2->DY;
      break;
    }
    case 1:
    {
      PositionX  = RectangleSource->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = MACRO_RECTANGLE2->X + MACRO_RECTANGLE2->DX;
      PositionDY = PositionY + MACRO_RECTANGLE2->DY;
      break;
    }
    case 2:
    {
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = RectangleSource->X + RectangleSource->DX;
      PositionDY = PositionY + MACRO_RECTANGLE2->DY;
      break; 
    }
    case 3:
    {
      PositionX  = RectangleSource->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = RectangleSource->X + RectangleSource->DX;
      PositionDY = PositionY + MACRO_RECTANGLE2->DY;
      break; 
    }
    case 4:
    { 
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = RectangleSource->Y;
      PositionDX = PositionX + MACRO_RECTANGLE2->DX;
      PositionDY = MACRO_RECTANGLE2->Y + MACRO_RECTANGLE2->DY;
      break; 
    }
    case 5:
    {
      PositionX  = RectangleSource->X;
      PositionY  = RectangleSource->Y;
      PositionDX = MACRO_RECTANGLE2->X + MACRO_RECTANGLE2->DX;
      PositionDY = MACRO_RECTANGLE2->Y + MACRO_RECTANGLE2->DY;
      break; 
    }
    case 6:
    {
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = RectangleSource->Y;
      PositionDX = RectangleSource->X + RectangleSource->DX;
      PositionDY = MACRO_RECTANGLE2->Y + MACRO_RECTANGLE2->DY;
      break;
    }
    case 7:
    {
      PositionX  = RectangleSource->X;
      PositionY  = RectangleSource->Y;
      PositionDX = PositionX + RectangleSource->DX;
      PositionDY = MACRO_RECTANGLE2->Y + MACRO_RECTANGLE2->DY;
      break;  
    }
    case 8:
    {
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = PositionX + MACRO_RECTANGLE2->DX;
      PositionDY = RectangleSource->Y + RectangleSource->DY;
      break; 
    }
    case 9:
    {
      PositionX  = RectangleSource->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = MACRO_RECTANGLE2->X + MACRO_RECTANGLE2->DX;
      PositionDY = RectangleSource->Y + RectangleSource->DY;
      break;
    }
    case 10:
    {
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = RectangleSource->X + RectangleSource->DX;
      PositionDY = RectangleSource->Y + RectangleSource->DY;
      break;
    }
    case 11:
    {
      PositionX  = RectangleSource->X;
      PositionY  = MACRO_RECTANGLE2->Y;
      PositionDX = PositionX + RectangleSource->DX;
      PositionDY = RectangleSource->Y + RectangleSource->DY;
      break;  
    }
    case 12:
    {
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = RectangleSource->Y;
      PositionDX = PositionX + MACRO_RECTANGLE2->DX;
      PositionDY = PositionY + RectangleSource->DY;
      break;  
    }
    case 13:
    {
      PositionX  = RectangleSource->X;
      PositionY  = RectangleSource->Y;
      PositionDX = MACRO_RECTANGLE2->X + MACRO_RECTANGLE2->DX;
      PositionDY = PositionY + RectangleSource->DY;
      break;
    }
    case 14:
    {
      PositionX  = MACRO_RECTANGLE2->X;
      PositionY  = RectangleSource->Y;
      PositionDX = RectangleSource->X + RectangleSource->DX;
      PositionDY = PositionY + RectangleSource->DY;
      break; 
    }
    case 15:
    {
      PositionX  = RectangleSource->X;
      PositionY  = RectangleSource->Y;
      PositionDX = RectangleSource->X + RectangleSource->DX;
      PositionDY = PositionY + RectangleSource->DY;
      break; 
    }
  }
  DrucIsPositionInclusInEqui ( DrucStructMesure,
                               DrucInstructionCourante,
                               IndexMesure,
                               PositionX,
                               PositionY,
                               PositionDX,
                               PositionDY
                             );
}
/*------------------------------------------------------------\
|                                                             |
|                          DrucRelationSurfaceInter           |
|                                                             |
\------------------------------------------------------------*/
void DrucMesureInter ( DrucStructMesure,
                       DrucInstructionCourante,
                       IndexMesure,
                       Mesure
                     )
     DrucTypeStructMesure      *DrucStructMesure;
     DrucTypeStructInstruction *DrucInstructionCourante;
     int                        IndexMesure;
     long                       Mesure;
{

  DrucStructMesure->MESURE_EFFECTIVE = Mesure;
  switch ( DrucInstructionCourante->OP_COMPARE [ IndexMesure ] )
  {
  case DRUC_OPERATION_INF :
    {
      if ( Mesure >= DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_INFEQ :
    {
      if ( Mesure > DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_SUP :
    {
      if ( Mesure <= DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_SUPEQ :
    {
      if ( Mesure < DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_DIFF :
    {
      if ( Mesure == DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
        DrucErreurDeuxCorps ( DrucStructMesure,
                              DrucInstructionCourante,
                              IndexMesure
                            );
      }
      break;
    }
  case DRUC_OPERATION_MIN :
    {
      if ( Mesure < DrucInstructionCourante->VALEUR [ IndexMesure ] )
      {
          DrucMesureTesteInter ( DrucStructMesure,
                                 DrucInstructionCourante,
                                 IndexMesure
                               );
      }
      break;
    }
  case DRUC_OPERATION_MAX :
    {
      if ( ( MACRO_RECTANGLE1->FLAGS & DRUC_FLAG_REC_ISEQUI ) != DRUC_FLAG_REC_ISEQUI
         )
      {
        if ( Mesure > DrucInstructionCourante->VALEUR [ IndexMesure ] )
        {
        DrucMesureTesteInter ( DrucStructMesure,
                               DrucInstructionCourante,
                               IndexMesure
                             );   
        }
      }
      break;
    }
  } /* switch */
}
