#include  <time.h>
#include  <stdio.h>
#include  <string.h>

#include  <genlib.h>

#include   DUT_H
#include  "dplimits.h"
#include  "npl1.h"


/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  module  :  "npl1.c"                                           */


/* Module internal constants. */
#define        E_NPL1_WIDTH         2
#define        E_NPL1_SLICE         3
#define        E_NPL1_NOVIEW        4
#define        E_NPL1_OPENVBE       5
#define        E_NPL1_MODELNAME     6


/* Names of tristate leaf cells. */
static char *TablLeafCellNpl1[2] = { "pl1b0_fp",
									"npl1a0_fp"};


/* Interface function of module.
   extern       char *Dgn_DispachNpl1();
   */

/* Internal functions of module. */
static       void  Dgn_ErrorNpl1();
static       void  Dgn_VhdlNpl1();
static       void  Dgn_NetlistNpl1();


/*  Function  :  'Dgn_DispatchNpl1'                                */
/* -------------------------------------------------------------- */
/*  Interface one input latch.                                    */

extern char *Dgn_DispatchNpl1(npl1_modelname,
							  npl1_width    ,
							  npl1_slice    ,
							  npl1_msb0     ,
							  npl1_vhdl     ,
							  npl1_netlist  ,
							  npl1_icon     )
	char *npl1_modelname;  /* Model name.                    */
	long  npl1_width;      /* Bus wide.                      */
	long  npl1_slice;      /* LSB starting slice.            */
	long  npl1_msb0;       /* Zero as MSB index.             */
	long  npl1_vhdl;       /* Generation of behavioral view. */
	long  npl1_netlist;    /* Generation of netlist view.    */
	long  npl1_icon;       /* Generation of icon.            */
{
	static short  DispachNpl1_FirstCall = FALSE;
	static  char  ModelName[C_SUPP_MBKSZNAME];

	/* The first time the generator is call : */
	/*     - Load specific errors.            */
	if (!DispachNpl1_FirstCall)
	{
		Dgn_ErrorNpl1();
		DispachNpl1_FirstCall = TRUE;
	}

	/* Check if, at least, one view is asked. */
	if (   (npl1_netlist == FALSE)
		 &&(npl1_vhdl    == FALSE)
		 &&(npl1_icon    == FALSE) )
		Dut_PrintError( E_NPL1_ERROR, E_NPL1_NOVIEW);

	/* Check the bus wide. */
	if ((npl1_width < 2) || (npl1_width > DP_WIDTH))
		Dut_PrintError( E_NPL1_ERROR, E_NPL1_WIDTH, npl1_width);

	/* Check the LSB starting slice. */
	if ((npl1_slice < 0) || ( npl1_slice
							 +npl1_width > DP_WIDTH))
		Dut_PrintError( E_NPL1_ERROR, E_NPL1_SLICE, npl1_slice);

	/* Check the model name. */
	if (npl1_modelname == (char*)NULL)
		/* Build a more explicit model name. */
		(void*)sprintf( ModelName, "npl1_%ldx%ldx%ld%c_cl"  ,
					                   DP_WIDTH              ,
					                npl1_width              ,
					                npl1_slice              ,
					              ((npl1_msb0 ) ? 'm' : 'l'));
	else
		strcpy( ModelName, npl1_modelname);

	/* Generation of behaviorial view. */
	if (npl1_vhdl)
		Dgn_VhdlNpl1(ModelName  ,
					 npl1_width,
					 npl1_slice,
					 npl1_msb0 );

	/* Generation of netlist view. */
	if (npl1_netlist)
		Dgn_NetlistNpl1(ModelName  ,
						npl1_width,
						npl1_slice,
						npl1_msb0 );

	/* Generation of icon. */
	/* if (npl1_icon) */
	
	/* Return name of the generated model. */
	return((npl1_modelname == (char*)NULL) ?      ModelName 
		                                   : npl1_modelname);
}


/*  Function  :  'Dgn_ErrorNpl1'                                  */
/* -------------------------------------------------------------- */
/*  Adds generator specific errors to the main errors data base.  */

static void  Dgn_ErrorNpl1()
{
	Dut_AddError( E_NPL1_ERROR, E_NPL1_WIDTH,
				  "invalid bus width : %ld.");
	Dut_AddError( E_NPL1_ERROR, E_NPL1_SLICE,
				  "invalid LSB starting slice : %ld.");
	Dut_AddError( E_NPL1_ERROR, E_NPL1_MODELNAME,
				  "Missing model name.");
	Dut_AddError( E_NPL1_ERROR, E_NPL1_NOVIEW,
				  "No view to generate.");
	Dut_AddError( E_NPL1_ERROR, E_NPL1_OPENVBE,
				  "Unable to create file : \"%s\".");
}


/*  Function  :  'Dgn_VhdlNpl1'                                   */
/* -------------------------------------------------------------- */
/*  Generation scannable D flip-flops behavioral view.            */

static void  Dgn_VhdlNpl1(npl1_modelname,
						  npl1_width    ,
						  npl1_slice    ,
						  npl1_msb0     )
	char *npl1_modelname;  /* Model name.         */
	long  npl1_width;      /* Bus width.          */
	long  npl1_slice;      /* LSB starting slice. */
	long  npl1_msb0;       /* Zero as MSB index.  */
{
	FILE *Npl1File;
	long  ConIndex;
	long  BitIndex,     LenString,      TmpTime;
	char  BusWide[  256], TmpString[256];

	/* *** Creating the file holding behavioral view. *** */
	if ((Npl1File=mbkfopen(npl1_modelname,
						              "vbe",
						         WRITE_TEXT)) == (FILE*)NULL)
		Dut_PrintError( E_NPL1_ERROR, E_NPL1_OPENVBE,
					                   npl1_modelname);


	/* *** Write an identification header *** */

	/* Standart begin of header. */
	fprintf( Npl1File, 
"-- ###-------------------------------------------------------------###\n"
			);
	fprintf( Npl1File, 
"-- #                                                                 #\n"
			);
	fprintf( Npl1File,
"-- #    Alliance CAD System 2.0                                      #\n"
			);
    fprintf( Npl1File,
"-- #      FITPATH Package 0.0                                        #\n"
			);
    fprintf( Npl1File,
"-- #                                                                 #\n"
			);
    fprintf( Npl1File,
"-- # Author :     Jean-Paul CHAPUT                                   #\n" 
			);
    fprintf( Npl1File,
"-- # E-mail : cao-vlsi@masi.ibp.fr                                   #\n"
			);
	fprintf( Npl1File, 
"-- # *************************************************************** #\n"
			);
	fprintf( Npl1File,
"-- #                                                                 #\n"
			);
    fprintf( Npl1File,
"-- # Generator : \"npl1g\" (Scannable D Flip-Flop)                      #\n"
			);
	fprintf( Npl1File, 
"-- # --------------------------------------------------------------- #\n"
			);

	/* Print name of the generated file. */
	sprintf(  TmpString, "\"%s.vbe\"."            ,npl1_modelname);
    fprintf( Npl1File  , "-- # File : %-55s  #\n",      TmpString);
	fprintf( Npl1File,
"-- #                                                                 #\n"
			);

	/* Print date of generation. */
	TmpTime                = time((time_t*)NULL);
	sprintf( TmpString, "%s", asctime(localtime(&TmpTime)) );
	LenString              = strlen( TmpString);
	TmpString[LenString-1] = (char)0;
    fprintf( Npl1File  , "-- #           Date : %-45s  #\n", TmpString);

	/* Give the call used to generate the model. */
	sprintf(  TmpString, "\"npl1g %ld %ld %ld%s -vhdl -o %s\"" ,
			                      DP_WIDTH                      ,
			                   npl1_width                      ,
			                   npl1_slice                      ,
			                  (npl1_msb0     ) ? " -msb0"  : "",
			                   npl1_modelname                  );
    fprintf( Npl1File  , "-- # Generator Call : %-45s  #\n", TmpString);

	fprintf( Npl1File, 
"-- ###-------------------------------------------------------------###\n"
			);


	/* Select terminals (and signals) bus indexation. */
	/* (depending to the flag "npl1_msb0")            */
	if (!npl1_msb0)
	{
		sprintf( BusWide ,  "(%ld downto %ld)", npl1_width-1
				                               +npl1_slice  ,
				                                npl1_slice  );
	}
	else
	{
		sprintf( BusWide  ,   "(%ld to %ld)", DP_WIDTH-npl1_slice
				                                      -npl1_width  ,
				                              DP_WIDTH-npl1_slice-1);
	}


	/* *** Interface description. *** */
	fprintf( Npl1File, "\nENTITY %s IS\n\tPORT(\n", npl1_modelname);

	/* Controls terminals. */
	fprintf( Npl1File, "%14s : in    BIT;\n",    "ck");

	/* Terminals of data npl1s. */
	fprintf( Npl1File, "%14s : in    BIT_VECTOR%s;\n",  "d", BusWide  );
	fprintf( Npl1File, "%14s :   out BIT_VECTOR%s;\n",  "q", BusWide );

	/* Supplies terminals. */
	fprintf( Npl1File, "%14s :  in BIT;\n", "vdd");
	fprintf( Npl1File, "%14s :  in BIT\n" , "vss");

	/* *** End of interface description *** */
	fprintf( Npl1File, "\t);\nEND %s;\n\n\n", npl1_modelname);


	/* *** Behavioral view *** */
	fprintf( Npl1File, "ARCHITECTURE behaviour_data_flow OF %s IS\n\n",
			                                            npl1_modelname);
	
	/* Internal register declaration. */
	for( BitIndex=npl1_slice; 
		 BitIndex<npl1_slice+npl1_width; BitIndex++)
	{
		fprintf( Npl1File, "\tSIGNAL inst_npl1_%ld_mem_s", BitIndex);
	    fprintf( Npl1File, ": REG_BIT REGISTER;\n"      );
	}

	fprintf( Npl1File, "\nBEGIN\n\n");

	/* *** Write Latch *** */
	fprintf( Npl1File, "\twl:BLOCK(ck) BEGIN\n");
	/* Loop on bus wide. */
	for( BitIndex=npl1_slice; 
		 BitIndex<npl1_slice+npl1_width; BitIndex++)
	{
		if (!npl1_msb0) ConIndex =              BitIndex;
		else           ConIndex = DP_WIDTH -1 -BitIndex;

		fprintf( Npl1File, "\t\tinst_npl1_%ld_mem_s <= GUARDED ", ConIndex);
		fprintf( Npl1File,            "d(%ld);\n"              , ConIndex);
	}
	fprintf( Npl1File, "\tEND BLOCK wl;\n\n");

	/* *** Affect the outputs. *** */

	/* Loop on bus wide. */
	for( BitIndex=npl1_slice; 
		 BitIndex<npl1_slice+npl1_width; BitIndex++)
	{
		if (!npl1_msb0) ConIndex =              BitIndex;
		else           ConIndex = DP_WIDTH -1 -BitIndex;

		fprintf( Npl1File, "\t q(%ld) <= not inst_npl1_%ld_mem_s;\n",
				                                      ConIndex,
				                                      ConIndex);
	}


	/* Check supplies connections. */
	fprintf( Npl1File, "\n\t-- ****************>");
	fprintf( Npl1File,   " Supplies Check "      );
	fprintf( Npl1File,   "<****************\n\n" );

	fprintf( Npl1File, "\tASSERT ((vdd = '1') and (vss = '0'))\n");
	fprintf( Npl1File, "\t\tREPORT \"Power supply is missing on %s.\"\n",
			                                              npl1_modelname);
	fprintf( Npl1File, "\t\tSEVERITY WARNING;\n\n");

	/* *** End of behavioral view *** */
	fprintf( Npl1File, "END behaviour_data_flow;\n");

	/* *** Close the file holding the behavioral view *** */
	fclose( Npl1File);
}


/*  Fonction  :  'Dgn_NetListNpl1'                                */
/* -------------------------------------------------------------- */
/*  Generation of Scannable D Flip-Flop Netlist.                  */

static void  Dgn_NetlistNpl1(npl1_modelname,
							 npl1_width    ,
							 npl1_slice    ,
							 npl1_msb0     )
	char *npl1_modelname;  /* Model name.         */
	long  npl1_width;      /* Bus wide.           */
	long  npl1_slice;      /* LSB starting slice. */
	long  npl1_msb0;       /* Zero as MSB index.  */
{
	long       BusIndex;
	long  LeafCellIndex;

	char *LeafCellSliceName;
	char *LeafCellBuffrName;
	char  LeafCellInstaName[C_SUPP_MBKSZNAME];

	char  BusNameD[  C_SUPP_MBKSZNAME];
	char  BusNameQ[  C_SUPP_MBKSZNAME];
	char  PinNameD[  C_SUPP_MBKSZNAME];
	char  PinNameQ[  C_SUPP_MBKSZNAME];


	/* Model names (slices and buffer). */

	/* Creation of the new logical figure. */
	DEF_LOFIG( npl1_modelname);

	/* Name of data bus terminals. */
	if (!npl1_msb0)
	{
		sprintf( BusNameD , "d[%ld:%ld]", npl1_width-1
				                         +npl1_slice  , 
				                          npl1_slice  );
		sprintf( BusNameQ , "q[%ld:%ld]", npl1_width-1
				                         +npl1_slice  ,
				                          npl1_slice  );
	}
	else
	{
		sprintf( BusNameD , "d[%ld:%ld]", DP_WIDTH-npl1_slice
				                                  -npl1_width  ,
				                          DP_WIDTH-npl1_slice-1);
		sprintf( BusNameQ , "q[%ld:%ld]", DP_WIDTH-npl1_slice
				                                  -npl1_width  ,
				                          DP_WIDTH-npl1_slice-1);
	}
 
	/* Creation of figure terminals. */
	/* **** Control terminals **** */
	LOCON(      "ck", IN   ,       "ck");

	/* **** Data bus terminals **** */
	LOCON( BusNameD , IN   , BusNameD );
	LOCON( BusNameQ ,   OUT, BusNameQ );

	/* **** Supply terminals **** */
	LOCON(     "vdd", INOUT,      "vdd"); 
	LOCON(     "vss", INOUT,      "vss"); 


	/* Instance of bottom column. */	
	LeafCellIndex=npl1_slice;

	/* Select leaf cell model name. */
	LeafCellSliceName = TablLeafCellNpl1[1];

	/* Creation of leaf cells instances. */
	/* ("normals" cells of column)       */
	for( LeafCellIndex=npl1_slice; 
		 LeafCellIndex<npl1_slice+npl1_width; LeafCellIndex++)
	{
		/* Build leaf cell name. */
		sprintf( LeafCellInstaName, "npl1_%ld", LeafCellIndex);
		
		/* Compute terminal index. */
		if (!npl1_msb0) BusIndex =              LeafCellIndex;
		else           BusIndex = DP_WIDTH -1 -LeafCellIndex;

		/* Build signals names. */
		sprintf( PinNameD  ,   "d[%ld]", BusIndex  );
		sprintf( PinNameQ  ,   "q[%ld]", BusIndex  );

		/* Leaf cell instanciation. */
		LOINS( LeafCellSliceName,
			   LeafCellInstaName,
			          PinNameD  ,
			               "ckl",
			          PinNameQ  , "vdd", "vss", EOL);
	}


	/* Creation of buffer instance. */

	/* Select buffer model name. */
	LeafCellBuffrName = TablLeafCellNpl1[0];
	/* Build buffer instance name. */
	sprintf( LeafCellInstaName, "bnpl1_%ld", DP_WIDTH);

	/* Buffer instanciation. */
	LOINS( LeafCellBuffrName,
		   LeafCellInstaName,
		               "ck" ,
		               "ckl", "vdd", "vss", "vss", EOL);

	/* Ends and write to disk the new figure. */
	SAVE_LOFIG();
}
