#include  <stdio.h>
#include  <string.h>
#include  <varargs.h>

#include   MUT_H
#include   MLO_H
#include   MPH_H
#include   MGN_H
#include   DUT_H
#include   DGN_H
#include  "FpgenMBK.h"
#include  "FpgenMGN.h"


/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  module  :  "FpgenMGN.c"                                       */




/*  Function  :  'DP_DEFLOFIG'.                                   */
/* -------------------------------------------------------------- */
/*  Open a new Data-Path logical figure.                          */

extern void  DP_DEFLOFIG(aFigName ,
						 aMaxWidth,
						 aMsb0    ,
						 aType    )
	char *aFigName;  /* Name of the newly created logical figure. */
	long  aMaxWidth; /* Maximum width of the data-path buses.     */
	long  aMsb0;     /* Index zero for the MSB.                   */
	long  aType;     /* Data-Path type : termainal or block.      */
{
	static char  FuncName[]     = "DP_DEFLOFIG";

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Actualize the number of calls to "DP_DEFLOFIG". */
	fpgen_Glob.CallDefLo += 1;

	/* Check the number of call to the function. */
	if (fpgen_Glob.CallDefLo != fpgen_Glob.CallSavLo+1)
		Dut_PrintError(E_FPGEN_ERROR    ,
					   E_FPGEN_DEFLOCall);
	
	/* First call to "DP_DEFLOFIG". */
	if (fpgen_Glob.CallDefLo == 1L)
	{
		/* Load errors and warnings of FPGEN and SUPPORT. */
		DmlMBK_ErrorFpgen();
		DmlMBK_WarngFpgen();
		Dut_InitSupport();
	}

	/* Check of argument "MaxWidth". */
	if (   (aMaxWidth < 1                  )
		|| (aMaxWidth > C_DPLIMITS_MAXSLICE))
		Dut_PrintError(E_FPGEN_ERROR        ,
					   E_FPGEN_DEFLOWidthMax,
					               aMaxWidth);

	/* Check the parity of "MaxWidth". */
	if (aMaxWidth%2)
		Dut_PrintError(E_FPGEN_ERROR         ,
					   E_FPGEN_DEFLOWidthEven,
					                aMaxWidth);

	/* Set global variable "DP_WIDTH". */
	DP_WIDTH = aMaxWidth;

	/* Set global variable "Msb0". */
	switch( aMsb0 )
	{
		case LSB_INDEX_ZERO :
		case MSB_INDEX_ZERO :
			fpgen_Glob.Msb0 = aMsb0;
			break;
		default:
			Dut_PrintError(E_FPGEN_ERROR      ,
						   E_FPGEN_DEFLOLsbPos,
						   aMsb0              );
	}

	/* Set mode of CTRL terminals management. */
	/* (default mode : EXPLICIT)              */
	fpgen_Glob.ConMode = C_FPGEN_ConModeEXPLICIT;

	switch( aType )
	{
	    case C_FPGEN_DataTypeTerminal:
	        fpgen_Glob.TypeDP = C_SUPP_DataTypeTerminal;
			break;
	    case C_FPGEN_DataTypeBlock:
	        fpgen_Glob.TypeDP = C_SUPP_DataTypeBlock;
	        break;
	    default:
			Dut_PrintError(E_FPGEN_ERROR       ,
						   E_FPGEN_DEFLOBadType,
						                  aType);
	}

	/* Set the current "lofig".                     */
	/* (copy of the GENLIB's WORK_LOFIG for checks) */
	DEF_LOFIG(aFigName);

	/* Perform additionnal MBK operations of DP_DEFLOFIG.  */
	DmlMBK_DefLoFig();
}


/*  Function  :  'DP_SAVLOFIG'.                                   */
/* -------------------------------------------------------------- */
/*  Close and save on disk the previously generated Data-Path.    */

extern void  DP_SAVLOFIG()
{
	static char  FuncName[]     = "DP_SAVLOFIG";

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;


	/* Actualize the number of calls to "DP_SAVLOFIG". */
	fpgen_Glob.CallSavLo += 1;

	/* If the function has been call before "DP_DEFLOFIG"       */
	/*    - Load 'FPGEN' specific error table.                  */
	/*    - Process error : "No previous call to "DP_DEFLOFIG". */
	if (fpgen_Glob.CallDefLo == 0)
	{
		DmlMBK_ErrorFpgen();
		Dut_PrintError(E_FPGEN_ERROR          ,
					   E_FPGEN_COMMONMissDefLo,
					     fpgen_Glob.CurrFunc  );
	}

	/* Check the number of call to the function. */
	if (fpgen_Glob.CallDefLo != fpgen_Glob.CallSavLo)
		Dut_PrintError(E_FPGEN_ERROR    ,
					   E_FPGEN_SAVLOCall);

	/* Perform MBK additionnal operations of DP_SAVLOFIG. */
	DmlMBK_SavLoFig();

	DP_FLATTEN();
	SAVE_LOFIG();
}


/*  Fonction  :  'DP_CONMODE'.                                    */
/* -------------------------------------------------------------- */
/*  Reset the management mode of CTRL terminals after the first
	call to "DP_DEFLOFIG".
	*/

extern void  DP_CONMODE(aConMode)
	long  aConMode;
{
	static char  FuncName[] = "DP_CONMODE";

	/* Set the current function name. */
	fpgen_Glob.CurrFunc = FuncName;

	/* If the function has been call before "DP_DEFLOFIG"       */
	/*    - Load 'fpgen' specific error table.                  */
	/*    - Process error : "No previous call to "DP_DEFLOFIG". */
	if (fpgen_Glob.CallDefLo == 0)
	{
		DmlMBK_ErrorFpgen();
		Dut_PrintError(E_FPGEN_ERROR          ,
					   E_FPGEN_COMMONMissDefLo,
					     fpgen_Glob.CurrFunc  );
	}

	switch( aConMode )
	{
		case C_FPGEN_ConModeDEFAULT  :
	 	case C_FPGEN_ConModeEXPLICIT :
		case C_FPGEN_ConModeIMPLICIT :
			fpgen_Glob.ConMode = aConMode;
			break;
		default :
			Dut_PrintError(E_FPGEN_ERROR        ,
						   E_FPGEN_CONMODEUnknow,
						     fpgen_Glob.CurrFunc, aConMode);
	}
}


/*  Function  :  'DP_LOCON'.                                      */
/* -------------------------------------------------------------- */
/*  Add a new logical connector to the current figure.            */

extern void  DP_LOCON(aConName,
                      aConDir ,
					  aConSig ,
					  aConSide)
	char *aConName;  /* Name of the connector (vectors allowed). */
	char  aConDir;   /* Direction of the connector.              */
	char *aConSig;   /* Signal associated to the connector.      */
	long  aConSide;  /* Side where the connector will be set.    */
{
	static char  FuncName[] = "DP_LOCON";


	/* Set the current function name. */
	fpgen_Glob.CurrFunc = FuncName;

    /* If the function have been call before DP_DEFLO :      */
	/*     - Initialisation of error data base.              */
	/*     - Process error : "no previous call to DP_DEFLO". */
	if (fpgen_Glob.CallDefLo == 0)
	{
		DmlMBK_ErrorFpgen();
		Dut_PrintError(E_FPGEN_ERROR          ,
					   E_FPGEN_COMMONMissDefLo,
					   fpgen_Glob.CurrFunc    );
	}

	/* Detect power supplies. */
	if (!DmlMBK_LoConPower(aConName))
	{
	    /* Encapsulated GENLIB LOCON function call. */
	    LOCON(aConName, aConDir, aConSig);

		/* Perform MBK additionnal operations of DP_LOCON. */
		DmlMBK_LoCon(aConName, aConSide);
	}
}


/*  Fonction  :  'DP_IMPORT'.                                     */
/* -------------------------------------------------------------- */
/*  Instanciate a data-path or a column in the current data-path.
	    It must have his data terminals build with virtual 
    connectors. Implicits terminals are automatically detect and
    added to the interface.
    */

extern void  DP_IMPORT(va_alist)
	va_dcl
{
	static       char  FuncName[] = "DP_IMPORT";

			  va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

    /* If the function have been call before DP_DEFLO :      */
	/*     - Initialisation of error data base.              */
	/*     - Process error : "no previous call to DP_DEFLO". */
	if (fpgen_Glob.CallDefLo == 0)
	{
		DmlMBK_ErrorFpgen();
		Dut_PrintError(E_FPGEN_ERROR          ,
					   E_FPGEN_COMMONMissDefLo,
					     fpgen_Glob.CurrFunc  );
	}

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call to the importation function. */
	DmlMBK_Import( ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_FLATTEN'.                                    */
/* -------------------------------------------------------------- */
/*  Flatten the current logical figure to a normalized 2 levels
	netlist. It is just an encapsulation of the Data-Path UTili-
	ties function 'Dut-HierarchFlatten'.
    */

extern void  DP_FLATTEN()
{ 
	static char          FuncName[] = "DP_FLATTEN";

	/* Set the current function name. */
	fpgen_Glob.CurrFunc = FuncName;

    /* If the function have been call before DP_DEFLO :      */
	/*     - Initialisation of error data base.              */
	/*     - Process error : "no previous call to DP_DEFLO". */
	if (fpgen_Glob.CallDefLo == 0)
	{
		DmlMBK_ErrorFpgen();
		Dut_PrintError(E_FPGEN_ERROR          ,
					   E_FPGEN_COMMONMissDefLo,
					   fpgen_Glob.CurrFunc    );
	}

	/* Call to flatten function. */
	DmlMBK_Flatten();
}


/*  Function  :  'DP_INV'.                                        */
/* -------------------------------------------------------------- */
/*  Inverter/Driver generator.                                    */

extern void  DP_INV(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_INV";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameInv, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_AND2'.                                       */
/* -------------------------------------------------------------- */
/*  And2 generator.                                               */

extern void  DP_AND2(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_AND2";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameAnd2, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_AND3'.                                       */
/* -------------------------------------------------------------- */
/*  And3 generator.                                               */

extern void  DP_AND3(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_AND3";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameAnd3, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_NAND2'.                                      */
/* -------------------------------------------------------------- */
/*  Nand2 generator.                                              */

extern void  DP_NAND2(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NAND2";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameNand2, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_NAND3'.                                      */
/* -------------------------------------------------------------- */
/*  Nand3 generator.                                              */

extern void  DP_NAND3(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NAND3";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameNand3, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_OR2'.                                        */
/* -------------------------------------------------------------- */
/*  Or2 generator.                                                */

extern void  DP_OR2(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_OR2";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameOr2, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_OR3'.                                        */
/* -------------------------------------------------------------- */
/*  Or3 generator.                                                */

extern void  DP_OR3(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_OR3";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameOr3, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_NOR2'.                                       */
/* -------------------------------------------------------------- */
/*  Nor2 generator.                                               */

extern void  DP_NOR2(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NOR2";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameNor2, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_NOR3'.                                       */
/* -------------------------------------------------------------- */
/*  Nor3 generator.                                               */

extern void  DP_NOR3(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NOR3";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameNor3, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_XOR2'.                                       */
/* -------------------------------------------------------------- */
/*  Xor2 generator.                                               */

extern void  DP_XOR2(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_XOR2";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameXor2, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_XNOR2'.                                      */
/* -------------------------------------------------------------- */
/*  Nxor2 generator.                                              */

extern void  DP_XNOR2(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_XNOR2";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBool( C_FPGEN_RootNameXnor2, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_NOR2MASK'.                                   */
/* -------------------------------------------------------------- */

extern void  DP_NOR2MASK(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NOR2MASK";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic mask generator. */
	DmlMBK_GenericMask( C_FPGEN_RootNameNor2mask, ArgList);

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_XNOR2MASK'.                                  */
/* -------------------------------------------------------------- */

extern void  DP_XNOR2MASK(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_XNOR2MASK";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic mask generator. */
	DmlMBK_GenericMask( C_FPGEN_RootNameXnor2mask, ArgList);

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_NAND2MASK'.                                  */
/* -------------------------------------------------------------- */

extern void  DP_NAND2MASK(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NAND2MASK";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic mask generator. */
	DmlMBK_GenericMask( C_FPGEN_RootNameNand2mask, ArgList);

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_NMUX2CS'.                                    */
/* -------------------------------------------------------------- */

extern void  DP_NMUX2CS(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NMUX2CS";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericMux(
		C_FPGEN_RootNameNmux2cs,  /* Tells the name radix. */
					    ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_MUX2CS'.                                     */
/* -------------------------------------------------------------- */

extern void  DP_MUX2CS(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_MUX2CS";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericMux(
		C_FPGEN_RootNameMux2cs,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_MUX3CD'.                                     */
/* -------------------------------------------------------------- */

extern void  DP_MUX3CD(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_MUX3CD";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericMux(
		C_FPGEN_RootNameMux3cd,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_BUSE'.                                       */
/* -------------------------------------------------------------- */
/*  Non inverter tristate generator.                              */

extern void  DP_BUSE(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_BUSE";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBuse( C_FPGEN_RootNameBuse, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);
}


/*  Function  :  'DP_NBUSE'.                                      */
/* -------------------------------------------------------------- */
/*  Non inverter tristate generator.                              */

extern void  DP_NBUSE(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NBUSE";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic boolean operators generator. */
	DmlMBK_GenericBuse( C_FPGEN_RootNameNbuse, ArgList);

	/* Clean the list of variable arguments. */
	va_end( ArgList);

}


/*  Function  :  'DP_ADD2F'.                                      */
/* -------------------------------------------------------------- */

extern void  DP_ADD2F(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_ADD2F";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericAddf(
		C_FPGEN_RootNameAdd2f ,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_ADSB2F'.                                     */
/* -------------------------------------------------------------- */

extern void  DP_ADSB2F(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_ADSB2F";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericAddf(
		C_FPGEN_RootNameAdsb2f,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_SHIFT'.                                      */
/* -------------------------------------------------------------- */

extern void  DP_SHIFT(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_SHIFT";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericShift(
		C_FPGEN_RootNameShift,  /* Tells the name radix. */
					  ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_CONST'.                                      */
/* -------------------------------------------------------------- */

extern void  DP_CONST(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_CONST";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericConst(
		C_FPGEN_RootNameConst,  /* Tells the name radix. */
					  ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_NUL'.                                        */
/* -------------------------------------------------------------- */

extern void  DP_NUL(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NUL";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericComp(
		C_FPGEN_RootNameNul,  /* Tells the name radix. */
					ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_PLATCH1'.                                    */
/* -------------------------------------------------------------- */

extern void  DP_PLATCH1(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_PLATCH1";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericDff(
		C_FPGEN_RootNamePlatch1 ,  /* Tells the name radix. */
					     ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_NPLATCH1'.                                   */
/* -------------------------------------------------------------- */

extern void  DP_NPLATCH1(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_NPLATCH1";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericDff(
		C_FPGEN_RootNameNplatch1,  /* Tells the name radix. */
					     ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_PMS'.                                        */
/* -------------------------------------------------------------- */

extern void  DP_PMS(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_PMS";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericDff(
		C_FPGEN_RootNamePms ,  /* Tells the name radix. */
					 ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_PDFF'.                                       */
/* -------------------------------------------------------------- */

extern void  DP_PDFF(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_PDFF";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericDff(
		C_FPGEN_RootNamePdff ,  /* Tells the name radix. */
					  ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_PDFFT'.                                      */
/* -------------------------------------------------------------- */

extern void  DP_PDFFT(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_PDFFT";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericDff(
		C_FPGEN_RootNamePdfft ,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_RFG1C0'.                                     */
/* -------------------------------------------------------------- */

extern void  DP_RFG1C0(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_RFG1C0";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericRfg(
		C_FPGEN_RootNameRfg1c0,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_RFG1CC'.                                     */
/* -------------------------------------------------------------- */

extern void  DP_RFG1CC(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_RFG1CC";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericRfg(
		C_FPGEN_RootNameRfg1cc,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_RFG2CC'.                                     */
/* -------------------------------------------------------------- */

extern void  DP_RFG2CC(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_RFG2CC";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericRfg(
		C_FPGEN_RootNameRfg2cc,  /* Tells the name radix. */
					   ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}


/*  Function  :  'DP_RFG2C0'.                                     */
/* -------------------------------------------------------------- */

extern void  DP_RFG2C0(va_alist)
	va_dcl
{
	static    char  FuncName[] = "DP_RFG2C0";

	       va_list  ArgList;

	/* Set name of current function. */
	fpgen_Glob.CurrFunc = FuncName;

	/* Get the list of variable arguments. */
	va_start( ArgList);

	/* Call the generic register file generator. */
	DmlMBK_GenericRfg(
		 C_FPGEN_RootNameRfg2c0,  /* Tells the name radix. */
					    ArgList); /* Other arguments.      */

	/* Clean the list of variable arguments. */
	va_end(   ArgList);
}
