

/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  Header  :  "support.h"                                        */


#ifndef  _SUPPORT_
#define  _SUPPORT_

/* Constants of module "support.c". */
#define               TRUE                     1
#define               FALSE                    0

#define               EOL                      ((char*)NULL)

/* Generic error codes of modules.         */
/* (one constant for each separate module) */
#define          E_SUPP_ERROR                  2
#define         E_FPGEN_ERROR                  3

#define          E_BUFF_ERROR                  4
#define           E_INV_ERROR                  5
#define           E_OR2_ERROR                  6
#define          E_NOR2_ERROR                  7
#define           E_OR3_ERROR                  8
#define          E_NOR3_ERROR                  9
#define          E_AND2_ERROR                  10
#define         E_NAND2_ERROR                  11
#define          E_AND3_ERROR                  12
#define         E_NAND3_ERROR                  13
#define          E_XOR2_ERROR                  14
#define         E_XNOR2_ERROR                  15
#define     E_NAND2MASK_ERROR                  16
#define      E_NOR2MASK_ERROR                  17
#define     E_XNOR2MASK_ERROR                  18
#define       E_NMUX2CS_ERROR                  19
#define        E_MUX2CS_ERROR                  20
#define        E_MUX3CD_ERROR                  21
#define       E_NMUX2FS_ERROR                  22
#define        E_MUX2FS_ERROR                  23
#define        E_MUX3FD_ERROR                  24
#define          E_BUSE_ERROR                  25
#define         E_NBUSE_ERROR                  26
#define         E_ADD2S_ERROR                  27
#define         E_ADD3S_ERROR                  28
#define         E_SUB2S_ERROR                  29
#define        E_ADSB2S_ERROR                  30
#define         E_CONST_ERROR                  31
#define           E_NUL_ERROR                  32
#define          E_PDFF_ERROR                  33
#define           E_PL1_ERROR                  34
#define          E_NPL1_ERROR                  35
#define           E_PMS_ERROR                  36
#define          E_PMST_ERROR                  37
#define         E_PDFFT_ERROR                  38

#define        E_DPBUFF_ERROR                  1024
#define         E_DPINV_ERROR                  1025
#define         E_DPOR2_ERROR                  1026
#define        E_DPNOR2_ERROR                  1027
#define         E_DPOR3_ERROR                  1028
#define        E_DPNOR3_ERROR                  1029
#define        E_DPAND2_ERROR                  1030
#define       E_DPNAND2_ERROR                  1031
#define        E_DPAND3_ERROR                  1032
#define       E_DPNAND3_ERROR                  1033
#define        E_DPXOR2_ERROR                  1034
#define       E_DPXNOR2_ERROR                  1035
#define   E_DPNAND2MASK_ERROR                  1036
#define    E_DPNOR2MASK_ERROR                  1037
#define   E_DPXNOR2MASK_ERROR                  1038
#define     E_DPNMUX2CS_ERROR                  1039
#define      E_DPMUX2CS_ERROR                  1040
#define      E_DPMUX3CD_ERROR                  1041
#define     E_DPNMUX2FS_ERROR                  1042
#define      E_DPMUX2FS_ERROR                  1043
#define      E_DPMUX3FD_ERROR                  1044
#define        E_DPBUSE_ERROR                  1045
#define       E_DPNBUSE_ERROR                  1046
#define       E_DPADD2S_ERROR                  1047
#define       E_DPADD3S_ERROR                  1048
#define       E_DPSUB2S_ERROR                  1049
#define      E_DPADSB2S_ERROR                  1050
#define       E_DPCONST_ERROR                  1051
#define         E_DPNUL_ERROR                  1052
#define        E_DPPDFF_ERROR                  1053
#define         E_DPPL1_ERROR                  1054
#define        E_DPNPL1_ERROR                  1055
#define         E_DPPMS_ERROR                  1056
#define        E_DPPMST_ERROR                  1057
#define       E_DPPDFFT_ERROR                  1058

#define       E_POSTDPP_ERROR                  2048

/* Specific error codes of module "support.h". */
#define        E_SUPP_NOERR                    2
#define        E_SUPP_UNKERR                   3

#define        E_SUPP_DEFAULT                  4
#define        E_SUPP_BADARG                   5
#define        E_SUPP_DUPARG                   6
#define        E_SUPP_MISSARG                  7
#define        E_SUPP_ARGGET                   8
#define        E_SUPP_DUPPOSARG                9
#define        E_SUPP_DUPNAMEARG              10
#define        E_SUPP_CHECKNAMESpace          11
#define        E_SUPP_CHECKNAMEOpenBracket    12
#define        E_SUPP_CHECKNAMECloseBracket   13
#define        E_SUPP_StackOverflow           14
#define        E_SUPP_StackUnderflow          15
#define        E_SUPP_ConGetLoFig             16
#define        E_SUPP_ConGetPhFig             17
#define        E_SUPP_ConDupName              18
#define        E_SUPP_OpenUdp                 19
#define        E_SUPP_ParserSyntax            20

/* Generic warning codes of modules.       */
/* (one constant for each separate module) */
#define        W_FPGEN_WARNG                   2

/* Specific warning codes of module "support.h". */
#define        W_SUPP_WARNG                    2
#define        W_SUPP_NOWARN                   3
#define        W_SUPP_UNKWARN                  4
#define        W_SUPP_HiddenHLevel             5
#define        W_SUPP_ColumnEmpty              6
#define        W_SUPP_ColumnMixed              7
#define        W_SUPP_ColumnUnexpectedLeafCell 8
#define        W_SUPP_FlattenLeafCell          9
#define        W_SUPP_FlattenColumn            10
#define        W_SUPP_XlStrNullPtr             11
#define        W_SUPP_XlStrOverflow            12
#define        W_SUPP_InvalidDigit             13
#define        W_SUPP_IllegalDigit             14
#define        W_SUPP_ConSideIllegal           15
#define        W_SUPP_MovConUnknow             16
#define        W_SUPP_MovPhConUnable           17

#define        C_SUPP_MaxLenString             16384
#define        C_SUPP_ARGLC_SW                 2
#define        C_SUPP_ARGLC_VL                 3
#define        C_SUPP_ARGLC_FLOATPOS           0
#define        C_SUPP_MBKSZNAME                64
#define        C_SUPP_MBKNOCAPA                0.0
#define        C_SUPP_UserDPCon                0
#define        C_SUPP_UserDPData               1
#define        C_SUPP_UserTypeSig              2
#define        C_SUPP_UserMaxTdupl             4
#define        C_SUPP_DataTypeTerminal        ((char)0)
#define        C_SUPP_DataTypeBlock           ((char)1)
#define        C_SUPP_DataTypeUnknow          ((char)64)
#define        C_SUPP_ConSideDefault          ((char)0)
#define        C_SUPP_ConSideNorth            ((char)1)
#define        C_SUPP_ConSideSouth            ((char)2)
#define        C_SUPP_ConSideEast             ((char)3)
#define        C_SUPP_ConSideWest             ((char)4)
#define        C_SUPP_ConSideUnknow           ((char)64)
#define        C_SUPP_ImplicitConNoIndex      -1
#define        C_SUPP_TypeConImplicit          2
#define        C_SUPP_TypeConVdd               3
#define        C_SUPP_TypeConVss               4
#define        C_SUPP_TypeConNormal            5
#define        C_SUPP_TypeModelUnknow          0
#define        C_SUPP_TypeModelDefault         1
#define        C_SUPP_TypeModelGenerator       2
#define        C_SUPP_TypeModelDplib           3
#define        C_SUPP_TypeModelFplib           4
#define        C_SUPP_XLSIZE                   4  /* 128 bits. */
#define        C_SUPP_BaseOctal                3
#define        C_SUPP_BaseBinary               1
#define        C_SUPP_BaseHexadecimal          4

#define        F_SUPP_UCREAT                   1

#define        S_SUPP_TypeConImplicit          "ic"
#define        S_SUPP_TypeModelFplib           "fp"
#define        S_SUPP_TypeModelDplib           "dp"
#define        S_SUPP_TypeModelGenerator       "c"



/* Definition des types. */

/* Structure contenant les erreurs. */
typedef struct error {
			long  TYPE;  /* Type (famille) de l'erreur.     */
			long  CODE;  /* Valeur du code de l'erreur.     */
			char *MESS;  /* Message affiche par l'erreur.   */
	struct error *NEXT;  /* Pointeur sur l'erreur suivante. */
	} error_list;


/* Structure contenant les avertissements. */
typedef struct warng {
			long  TYPE;  /* Type (famille) de l'avertissement.     */
			long  CODE;  /* Valeur du code de l'avertissement.     */
			char *MESS;  /* Message affiche par l'avertissement.   */
	struct warng *NEXT;  /* Pointeur sur l'avertissement suivante. */
	} warng_list;


/* Structure contenant les arguments de la ligne de commande. */
typedef struct arglc {
			long  TYPE;  /* Parmis ARGLC_SW ou ARGLC_VL.     */
			long  POS;   /* Position de l'argument.          */
			long  FLAG;  /* Indique si l'argument a ete lu.  */
			char *NAME;  /* Nom de l'argument.               */
			char *VALUE; /* Valeur lue (si pas un SWITCH).   */
	struct arglc *NEXT;  /* Pointeur sur l'argument suivant. */
	} arglc_list;


typedef struct {
	char TYPE;
	} udpdata;

/* Structure holding specific informations for data-path
   connectors placement. */
typedef struct udpcon {
	         char *NAME; /* Name of the connector.                   */
	         char  SIDE; /* Side where the terminal will be set.     */
	struct udpcon *NEXT; /* Pointer to the next element of the list. */
	} udpcon_list;


/* Variables externes au module. */
extern long  DP_WIDTH;
extern char  DP_SEPAR;
extern char  DP_IC[C_SUPP_MBKSZNAME];


/* Manipulation des erreurs. */
extern void  Dut_AddError();
extern void  Dut_PrintError();

/* Manipulation des avertissements. */
extern void  Dut_AddWarng();
extern void  Dut_PrintWarng();
/* "support.c" specific errors amd warnings loaders. */
extern void  Dut_ErrorSupport();
extern void  Dut_WarngSupport();
extern void  Dut_InitSupport();

/* Manipulation des arguments de la ligne de commande. */
extern       void  Dut_AddArgLc();
extern       void  Dut_SetArgLc();
extern       long  Dut_GetArgLcFlag();
extern       char *Dut_GetArgLcValue();
extern       void  Dut_PrintArgLc();

/* String to numerical value conversion functions. */
extern       long *Dut_XlAlloc();
extern       void  Dut_XlFree();
extern       void  Dut_XlSetLong();
extern       long  Dut_XlGetBit();
extern       long  Dut_XlStrCheck();
extern       void  Dut_XlStrToXl();
extern       char *Dut_XlToStr();
extern       char *Dut_XlToStrVHDL();

/* Manipulations of MBK signals names. */
#ifndef  ANSI_PROTO
extern       char *Dut_ConcatName();
extern       char *Dut_CheckName();
extern       char *Dut_DecodMBKSigName();
#else
extern char *Dut_DecodMBKSigName(char *aMBKSigName,
								 long *aPtSigIndex);
#endif

/* Hierarchical analisys. */
extern       char *Dut_MakeImplicitConName();
extern       char *Dut_MakeCrunchModelName();
extern       long  Dut_TypeConName();
extern       void  Dut_HierarchCheck();
extern       void  Dut_HierarchFlatten();

# ifdef  MLO
/* Functions handling the USER fields of LOFIGs. */
#  ifndef  ANSI_PROTO
extern  ptype_list *Dut_GetLoUser();
extern  ptype_list *Dut_DelLoUser();
extern        long  Dut_SetLoUser();
extern        void  Dut_DupLoUser();
extern  lofig_list *Dut_LoadLoFig();

extern udpdata     *Dut_AddUdpData();
extern udpcon_list *Dut_AddUdpCon();
extern        void  Dut_LoadUdp();
extern        void  Dut_SaveUdp();
extern        void  Dut_MovLsPhCon();
extern        void  Dut_SetABTerminal();
extern  locon_list *Dut_GetLoConBySig();
#  else
extern  locon_list *Dut_GetLoConBySig(lofig_list *aLoFig,
									  losig_list *aLoSig);
#  endif
# endif

# ifdef  MPH
/* Manipulation du champs USER des figures physiques. */
extern ptype_list *Dut_GetPhUser();
extern ptype_list *Dut_DelPhUser();
extern       long  Dut_SetPhUser();
extern       void  Dut_DupPhUser();
# endif
#endif
