/************************************************************************/
/* module   : declar.c							*/
/* date     : 02/09/93							*/
/* auteurs  : RENAUD & VENOT & PITON					*/
/************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include PAT_H
#include "libpat_l.h"

/* ###--------------------------------------------------------------### */
/* function     : DECLAR						*/
/* description  : create PAIOL or PAGRP structs according to parameter	*/
/* called func. :  Erreur, CreatePaiol, CreatePagrp, KillEsp, atoi	*/
/*        DefileParam, CheckIdent, TraiterChaine, CheckWidth, FindIdent */
/*        EmpileParam, CheckSeparate, CheckFormat			*/
/* ###--------------------------------------------------------------### */


void DECLAR (ident,space,format,mode,size)
char *ident;
char *space;
char *format;
char *mode;
char *size;
{
char     buffer [80];
char     name [80];
char     blk,base,i_o;
short    dim=0;
int      i,borne_g,borne_d,sens;
struct   alpha_num decomp;

    if (racine_paseq == NULL)
      Erreur ("DECLAR must declare output file's name first\n");

    if (GNP_TAB_PAIOL_CREE == GNP_ACTIF)
      Erreur ("DECLAR already in descriptive part\n");

    if (space == NULL)
      Erreur ("DECLAR unvalid parameter\n");
    strcpy (buffer,space);
    KillEsp (buffer);
    blk = CheckSeparate(buffer);

    if (format == NULL)
      Erreur ("DECLAR unvalid parameter\n");
    strcpy (buffer,format);
    base = CheckFormat (buffer);

    if (mode == NULL)
      Erreur ("DECLAR unvalid parameter\n");
    strcpy (buffer,mode);
    i_o = CheckType (buffer);

    if (ident == NULL)
      Erreur ("DECLAR unvalid parameter\n");
    strcpy (name,ident);
    KillEsp (name);
    CheckIdent (name);

    if  ( FindIdent (name,hash_paiol) != -1) 
        Erreur ("DECLAR duplicate declared identifier\n");
    if  ( FindIdent (name,hash_pagrp) != -1) 
        Erreur ("DECLAR yet declared identifier as a pagrp\n");

    if (size == NULL)
      Erreur ("DECLAR unvalid parameter\n");
    strcpy (buffer,size);
    TraiterChaine(buffer,&decomp);
    CheckWidth (&decomp);
    if (strlen (decomp.gauche) == 0)
        dim = 0;
    else 
    {
           if (strlen(decomp.alpha) ==0)
                dim = 1;
           else 
           {
                borne_g = atoi (decomp.gauche);
                borne_d = atoi (decomp.droite);
                if ( borne_g > borne_d ) 
		{
                    borne_d--;
                    sens = -1;
                    dim = borne_g - borne_d;
                }
                else 
                {
                    borne_d++;
                    sens = 1;
                    dim = borne_d - borne_g;
                }
           }
    }
    switch (dim) 
    {
        case 0: 
        {
	    if ( base != 'B' )
		Erreur ("DECLAR illegal format for one bit identifier\n");
            CreatePaiol (base,name,i_o,blk);
            break;
        }
        case 1: 
	{
	    char x[80];
            sprintf(x," %d",decomp.gauche);
	    strcat(name,x);
            if  ( FindIdent (name,hash_paiol) != -1) 
                Erreur ("DECLAR duplicate declared identifier\n");
	    if ( base != 'B' )
		Erreur ("DECLAR illegal format for one bit identifier\n");
            CreatePaiol (base,name,i_o,blk);
            break;
        }
        default: 
	{
            for (i = borne_g; i != borne_d; i = i + sens) 
            {
		char x[80];
                sprintf (x," %d",  i);
		strcpy(buffer,name);
		strcat(buffer,x);
                if  ( FindIdent (buffer,hash_paiol) != -1) 
                    Erreur ("DECLAR duplicate declared identifier\n");
                CreatePaiol (base,buffer,i_o,blk);
            }
        }
    }
    if (dim > 1)
        CreatePagrp (name,dim,sens,GNP_VECTEUR_EFFECTIF);
}
