/************************************************************************/
/* module   : m_declar.c						*/
/* date     : 02/09/93							*/
/* auteurs  : RENAUD & VENOT & PITON					*/
/************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <malloc.h>
#include <varargs.h>

#include PAT_H
#include "libpat_l.h"

/* ###--------------------------------------------------------------### */
/* function     : M_DECLAR						*/
/* description  : create PAIOL or PAGRP structs according to parameter	*/
/* called func. :  Erreur, CreatePaiol, CreatePagrp, KillEsp, atoi	*/
/*        DefileParam, CheckIdent, TraiterChaine, CheckWidth, FindIdent */
/*        EmpileParam, CheckSeparate, CheckFormat			*/
/* ###--------------------------------------------------------------### */


void M_DECLAR (va_alist)
va_dcl

{
va_list  pa;
char    *param;
char     buffer [80];
char     name [80];
char     blk,base,i_o;
short    dim=0;
int      i,borne_g,borne_d,sens;
struct   alpha_num decomp;

    if (racine_paseq == NULL)
      Erreur ("DECLAR must declare output file's name first\n");

    if (GNP_TAB_PAIOL_CREE == GNP_ACTIF)
      Erreur ("DECLAR already in descriptive part\n");

    va_start(pa);

    param = va_arg(pa, char *);
    if (param  == NULL) 
       Erreur ("DECLAR needs any parameters\n");

    strcpy (buffer,param);
    KillEsp (buffer);

    sp_pile_param = 0;
    while ( *buffer != ':') 
    {
        CheckIdent (param);
        if  ( FindIdent (param,hash_paiol) != -1) 
            Erreur ("DECLAR duplicate declared identifier\n");
        if  ( FindIdent (param,hash_pagrp) != -1) 
            Erreur ("DECLAR yet declared identifier as a pagrp\n");
        EmpileParam(param);

        param = va_arg(pa, char *);
        if (param  == NULL) 
           Erreur ("DECLAR needs more parameters\n");

        strcpy (buffer,param);
        KillEsp (buffer);
    }
    blk = CheckSeparate(buffer);

    param = va_arg(pa, char *);
    if (param  == NULL) 
      Erreur ("DECLAR needs more parameters\n");
    strcpy (buffer,param);
    base = CheckFormat (buffer);

    param     = va_arg(pa, char *);
    if (param  == NULL) 
      Erreur ("DECLAR needs more parameters\n");
    strcpy (buffer,param);
    i_o = CheckType (buffer);

    param    = va_arg(pa, char *);

    va_end (pa);

    if ( param != NULL ) 
    {
       strcpy (buffer,param);
       TraiterChaine(buffer,&decomp);
       CheckWidth (&decomp);
       if (strlen (decomp.gauche) == 0)
           dim = 0;
       else 
       {
           if (strlen(decomp.alpha) ==0)
                dim = 1;
           else 
           {
                borne_g = atoi (decomp.gauche);
                borne_d = atoi (decomp.droite);
                if ( borne_g > borne_d ) 
		{
                    borne_d--;
                    sens = -1;
                    dim = borne_g - borne_d;
                }
                else 
                {
                    borne_d++;
                    sens = 1;
                    dim = borne_d - borne_g;
                }
           }
       }
    }
    sp_file_param = 0;
    while (sp_file_param < sp_pile_param) 
    {
        param = DefileParam();
	strcpy(buffer,param);
	KillEsp(buffer);
 	strcpy(name,buffer);
        switch (dim) 
        {
        case 0: 
        {
	    if ( base != 'B' )
		Erreur ("DECLAR illegal format for one bit identifier\n");
            CreatePaiol (base,param,i_o,blk);
            break;
        }
        case 1: 
	{
	    char x[80];
            sprintf(x," %d",decomp.gauche);
	    strcat(buffer,x);
            if  ( FindIdent (buffer,hash_paiol) != -1) 
                Erreur ("DECLAR duplicate declared identifier\n");
	    if ( base != 'B' )
		Erreur ("DECLAR illegal format for one bit identifier\n");
            CreatePaiol (base,buffer,i_o,blk);
            break;
        }
        default: 
	{
            for (i = borne_g; i != borne_d; i = i + sens) 
            {
		char x[80];
                sprintf (x," %d",  i);
		strcpy(buffer,name);
		strcat(buffer,x);
                if  ( FindIdent (buffer,hash_paiol) != -1) 
                    Erreur ("DECLAR duplicate declared identifier\n");
                CreatePaiol (base,buffer,i_o,blk);
            }
        }
        }
        if (dim > 1)
            CreatePagrp (name,dim,sens,GNP_VECTEUR_EFFECTIF);
    }
}
