/***************************************************************/
/* module   : libpat_l.h				       */
/* date     : 12/04/92                                         */
/* auteurs  : RENAUD & VENOT                                   */
/***************************************************************/

/*------------------------------------------------------------
 *      CONSTANTES
 *------------------------------------------------------------*/
#define GNP_MAXPILE_PARAM   40
#define GNP_PARAM_COURANT (sp_file_param - 1) /* sp_.. pointe tjrs sur le suivant */
#define GNP_MAXTAB_IDENT   500
#define GNP_MAXTAB_PAIOL   500
#define GNP_NO_DUPLICATE    -1
#define GNP_NOT_FOUND       -1
#define GNP_ACTIF 1
#define GNP_INACTIF 0
#define GNP_VECTEUR_VIRTUEL 1
#define GNP_VECTEUR_EFFECTIF 0
#define GNP_UP 1
#define GNP_DO -1

/*------------------------------------------------------------
 *      STRUCTURE PAT
 *------------------------------------------------------------*/
#define racine_pagrp  (racine_paseq->PAGRP)
#define racine_paiol  (racine_paseq->PAIOL)
#define racine_papat  (racine_paseq->CURPAT)
#define racine_pacom  (racine_paseq->CURCOM)
#define racine_paevt  (racine_paseq->CURPAT->PAEVT)
#define racine_paini  (racine_paseq->CURPAT->PAINI)
#define PATNUMBER     (racine_paseq->PATNBR)
#define IOLNUMBER     (racine_paseq->IOLNBR)

extern struct  paseq  *racine_paseq;
/*------------------------------------------------------------
 *      NUMERO DE PATTERN COURANT
 *------------------------------------------------------------*/
extern int GNP_PATTERN_COURANT;
/*------------------------------------------------------------
 *       TAILLE DU MAX. LABEL 
 *------------------------------------------------------------*/
extern unsigned int   MAX_LABEL;
/*------------------------------------------------------------
 *      TABLE DES PAIOLs
 *------------------------------------------------------------*/
extern struct paiol *tab_paiol[];
extern int      GNP_PAIOL_INDEX;
extern int GNP_TAB_PAIOL_CREE;
/*------------------------------------------------------------
 *      GESTION DES PARAMETRES A NOMBRE INDETERMINE
 *------------------------------------------------------------*/
struct  alpha_num {
                   char gauche[6];
                   char droite[6];
                   char alpha[7];
                  };
extern char    *pile_param[];
extern int      sp_pile_param ;
extern int      sp_file_param ;
extern FILE    *fp;
/*------------------------------------------------------------
 *      TABLE DES IDENTIFICATEURS
 *------------------------------------------------------------*/
typedef struct {
          int duplicate;
          int num_paiol;
          void * pointeur;
          } Tptab_ident;

extern Tptab_ident tab_ident[];
extern int     ind_tab_ident;

/*------------------------------------------------------------*
 *      CONSTANTES DE LA LIBRAIRIE                            *
 *------------------------------------------------------------*/
#define GNP_HASHSIZE  29
/*------------------------------------------------------------*
 *      TABLES DE HACHAGE                                     *
 *------------------------------------------------------------*/
typedef struct _elt
                  {
                    char *name;
                    int  num_index;
                    int  sens;  /* definit l'ordre de declaration des poids
                                                  des elements d'un vecteur */
                    struct _elt *next;
                  }elt;

extern elt    *hash_paiol[GNP_HASHSIZE];
extern elt    *hash_pagrp[GNP_HASHSIZE];

/*------------------------------------------------------------*
 *      FONCTIONS DE LA LIBRAIRIE                             *
 *------------------------------------------------------------*/
extern void		 InitHash    		();
extern elt  		*ExisteIdent 		();
extern elt  		*SymbAlloc   		();
extern int   		 FindIdent   		();

extern void		 Erreur	       		();

extern void              KillEsp       		();

extern void              CheckIdent    		();
extern char              CheckSeparate 		();
extern char              CheckFormat   		();
extern char              CheckType     		();
extern void              CheckPattern  		();
extern void              CheckWidth    		();

extern void              DupPaiol      		();

extern void		 TraiterChaine 		();
extern void              SplitIdent    		();

extern void              FormatValue     	();

extern char             *DefileParam   		();
extern void              EmpileParam   		();

extern void              CreatePapat   		();
extern void              CreatePaiol   		();
extern void              CreatePagrp   		();
extern void              CreateAction  		();
extern struct paevt     *CreatePaevt   		();

extern struct paevt     *FusionPaevt   		();
extern struct paini     *FusionPaini   		();


extern char             *Conv			();
extern void              MajPatternCourant 	();
