/* calls to genlib's or standard's functions library */
#ifdef pc
#undef pc
#endif

#include <stdio.h>
#include <string.h>
#include MUT_H
#include MPH_H
#include MPU_H
#include MLO_H
#include MLU_H
#include MGN_H
#include "mbk_extern.h"

#include "d_interp_lib.h"
#include "d_fonc.h"
#include "d_asm.h"
#include "g_visu.h"
#include "g_extern.c"

/* unused */
#define PREND_SHORT(X)  *((short*)(&(X)))
#define PREND_INT(X)    *((int*)(&(X)))
#define PREND_FLOAT(X)  *((float*)(&(X)))
#define PREND_DOUBLE(X) *((double*)(&(X)))

#define READ_SHORT(X)   *((short*)(X))
#define READ_INT(X)     *((int*)(X))
#define READ_FLOAT(X)   *((float*)(X))
#define READ_DOUBLE(X)  *((double*)(X))

#define QI 0            /* code QI 0 */
#define HI 1            /* code HI 1 */
#define SI 2            /* code SI 2 */
#define DF 3            /* code DF 3 */
#define SF 4            /* code SF 4 */

extern int I_pc;        /* program counter */
extern int I_cc0;       /* code condition  */
extern char *I_sp;      /* stack        */
extern int I_reg[];     /* registers    */

extern int taille_code;

/* Internally known functions. Alphanumerical ASCII order */
#define NB_FONC_LIB 51 /* number of entries in the dictionnary */

int taille_TabFonc = NB_FONC_LIB;

FONC TabFonc[NB_FONC_LIB + 1] = {
		"__flsbuf", app_flsbuf,
		"_atoi", app_atoi,
		"_bcopy", app_bcopy,
		"_genCOPY_UP_ALL_CON", app_COPY_UP_ALL_CON,
		"_genCOPY_UP_ALL_REF", app_COPY_UP_ALL_REF,
		"_genCOPY_UP_CON", app_COPY_UP_CON,
		"_genCOPY_UP_CON_FACE", app_COPY_UP_CON_FACE,
		"_genCOPY_UP_REF", app_COPY_UP_REF,
		"_genCOPY_UP_SEG", app_COPY_UP_SEG,
		"_genDEF_AB", app_DEF_AB,
		"_genDEF_PHFIG", app_DEF_PHFIG,
		"_genDEF_PHINS", app_DEF_PHINS,
		"_genFLATTEN_ALL_PHINS", app_FLATTEN_ALL_PHINS,
		"_genFLATTEN_PHFIG", app_FLATTEN_PHFIG,
		"_genGET_CON_X", app_GET_CON_X,
		"_genGET_CON_Y", app_GET_CON_Y,
		"_genGET_INS_X", app_GET_INS_X,
		"_genGET_INS_Y", app_GET_INS_Y,
		"_genGET_REF_X", app_GET_REF_X,
		"_genGET_REF_Y", app_GET_REF_Y,
		"_genHEIGHT", app_HEIGHT,
		"_genNAME", app_NAME,
		"_genPHCON", app_PHCON,
		"_genPHREF", app_PHREF,
		"_genPHSEG", app_PHSEG,
		"_genPHVIA", app_PHVIA,
		"_genPLACE", app_PLACE,
		"_genPLACE_BOTTOM", app_PLACE_BOTTOM,
		"_genPLACE_CON_REF", app_PLACE_CON_REF,
		"_genPLACE_LEFT", app_PLACE_LEFT,
		"_genPLACE_ON", app_PLACE_ON,
		"_genPLACE_REF", app_PLACE_REF,
		"_genPLACE_RIGHT", app_PLACE_RIGHT,
		"_genPLACE_SEG_REF", app_PLACE_SEG_REF,
		"_genPLACE_TOP", app_PLACE_TOP,
		"_genPLACE_VIA_REF", app_PLACE_VIA_REF,
		"_genSAVE_PHFIG", (int(*)())genSAVE_PHFIG,
		"_genTHRU_CON_H", app_THRU_CON_H,
		"_genTHRU_CON_V", app_THRU_CON_V,
		"_genTHRU_H", app_THRU_H,
		"_genTHRU_V", app_THRU_V,
		"_genWIDTH", app_WIDTH,
		"_genWIRE1", app_WIRE1,
		"_genWIRE2", app_WIRE2,
		"_genWIRE3", app_WIRE3,
		"_malloc", app_malloc,
		"_namealloc", app_namealloc,
		"_printf", app_printf,
		"_sprintf", app_sprintf,
		"_strcmp", app_strcmp,
		"_strlen", app_strlen,
		"~", NULL};


/*	retrieve a parameter from the stack :
   Needs the position of the parameter in the stack - word aligned - and its
   type.
   The MULT_TYP contains either the value of the parameter or its absolute
   address in memory. */
MULT_TYP
	GetParam(pos_param, type_param)
int pos_param;
int type_param;
{
MULT_TYP res;

	switch (type_param) {
		case INT:
			res.ent = READ_INT(I_reg[31] + pos_param);
			return res;
		case REAL:
			res.real = READ_DOUBLE(I_reg[31] + pos_param);
			return res;
		case PTR:
			res.ptr = (char *)READ_INT(I_reg[31] + pos_param);
			return res;
		default:
			Erreur("Internal error -> GetParam : Uknown type\n");
	}
	/*NOTREACHED*/
}

int app_atoi()
{
MULT_TYP param;
char *str;

	param = GetParam(0, PTR);
	str = param.ptr;
	I_reg[25] = atoi(str);
}

int app_malloc()
{
MULT_TYP param;
int taille;
char *ptr;

	param = GetParam(0, INT);
	taille = param.ent;
	ptr = (char *)mbkalloc(taille);
	I_reg[25] =(int)ptr;
}

/*	gcc requirement :
   When copying structures into structures, the compiler generates calls to
   bcopy, so we must have one at hand. */
app_bcopy()
{
char *src, *dest;
int taille;
MULT_TYP param;

	param = GetParam(0, PTR);
	src = param.ptr;
	param = GetParam(4, PTR);
	dest = param.ptr;
	param = GetParam(8, INT);
	taille = param.ent;
	bcopy(src, dest, taille);
}

/* standart io requirements :
   flsbuf is called under certain circumstances, I was told!
   I'd like to know when. */
app_flsbuf()
{
int car;
char *fp;
MULT_TYP param;

	param = GetParam(0, INT);
	car = param.ent;
	param = GetParam(4, PTR);
	fp = param.ptr;
	I_reg[25] = _flsbuf(car, fp);
}

/* user requirements :
   In order to handle strings, two functions are available.
   If more is needed, then add them. */
app_strlen()
{
MULT_TYP param;
char *str;

	param = GetParam(0, PTR);
	str = param.ptr;
	I_reg[25] =(int)strlen(str);
}

app_strcmp()
{
MULT_TYP param;
char *str1, *str2;

	param = GetParam(0, PTR);
	str1 = param.ptr;
	param = GetParam(4, PTR);
	str2 = param.ptr;
	I_reg[25] =(int)strcmp(str1, str2);
}

app_namealloc()
{
MULT_TYP param;
char *name;
char *namealloc();

	param = GetParam(0, PTR);
	name = param.ptr;
	I_reg[25] =(int)namealloc(name);
}

/* printf emulation functions :
   the following functions fake the behavior of the printf and sprintf
   functions. */

/* Octal conversion :
   An octal constant, given in a string, is converted to it's decimal
   equivalent. */
void
	ConvOct(resu, str)
char *resu, *str;
{
int dep = 0;
int dep_res = 0;
int cste = 0;

	while (str[dep]) {
		if (str[dep] == '\\') {
			if (str[dep + 1] == '\\') {
				resu[dep_res] = '\\';
				dep_res++;
				dep += 2;
			} else if (str[dep + 1] >= '0' && str[dep + 1] <= '9') {
			/* octal constant */ 
				cste = 0;
				cste = 8 * ((8 * (str[dep + 1] - '0')) +
				(str[dep + 2] - '0')) + (str[dep + 3] - '0');
				resu[dep_res] = cste;
				dep_res++;
				dep += 4;
			} else {
				resu[dep_res] = str[dep + 1];
				dep_res++;
				dep += 2;
			}
		} else {
			resu[dep_res] = str[dep];
			dep_res++;
			dep++;
		}
	}
	resu[dep_res] = '\0';
}

/* partial printf :
   This does a sprintf with a single argument. */ 
EffectuePrintf(resu, format, dep_in_pile)
char *resu, *format;
int *dep_in_pile;
{
MULT_TYP param;
int dep = 0;
int lg = strlen(format);
char res[80];

	while (format[dep] && format[dep] != '%')
		dep++;

	if (dep == lg)
		strcpy(resu, format);
	else {
		while (format[dep]) {
			switch (format[dep]) {
				case 'd':
				case 'u':
				case 'o':
				case 'c':
				case 'x':
				case 'D':
				case 'O':
				case 'X':
					param = GetParam(*dep_in_pile, INT);
					sprintf(resu, format, param.ent);
					dep = lg;
					*dep_in_pile += 4;
					continue;
				case 's':
					param = GetParam(*dep_in_pile, PTR);
					ConvOct(res, param.ptr);
					sprintf(resu, format, res);
					dep = lg;
					*dep_in_pile += 4;
					continue;
				case 'f':
				case 'e':
				case 'g':
				case 'E':
				case 'G':
					param = GetParam(*dep_in_pile, REAL);
					sprintf(resu, format, param.real);
					dep = lg;
					*dep_in_pile += 8;
					continue;
				default:
					break;
			}
			dep++;
		}
	}
	ConvOct(resu, resu);
}

/* basical interface to printf :
   The dep parameter is the start of the stack where to find the printf
   arguments.
   It scans the string for '%' and does the corresponding sprintfs. */
char *
	base_printf(dep)
int dep;
{
MULT_TYP param;
char *format, sous_format[81], resu[100], resu_tot[250];
char *resultat;
int deb = 0, fin = 0;
int dep_in_pile = 0;
int i, j;

	param = GetParam(dep, PTR);
	dep_in_pile += 4 + dep;
	format = param.ptr;
	resu_tot[0] = '\0';
	sous_format[0] = '\0';

	while (1) {
		if (!format[fin] || format[fin] == '%' || fin - deb == 80) {
			for (j = 0, i = deb; i < fin; i++, j++)
				sous_format[j] = format[i];
			sous_format[j] = '\0';

			EffectuePrintf(resu, sous_format, &dep_in_pile);
			deb = fin;
			strcat(resu_tot, resu);
			if (!format[fin])
				break;
		}
		fin++;
	}
	resultat = mbkalloc(strlen(resu_tot) + 1);
	strcpy(resultat, resu_tot);
	return resultat;
}

app_printf()
{
char *resu;

	resu = base_printf(0);
	T_print(resu);
	mbkfree(resu);
}

app_sprintf()
{
MULT_TYP param;
char *resu_base, *dest;

	param = GetParam(0, PTR);
	dest = param.ptr;

	resu_base = base_printf(4);

	strcpy(dest, resu_base);
	mbkfree(resu_base);
	I_reg[25] = (int)dest;
}

/* genlib calls :
   this are the encapsulated versions of the genlib's calls. */

app_NAME()
{
	MULT_TYP param;
	char *resu;

	resu = base_printf(0);
	I_reg[25] = (int)resu;
}

app_DEF_PHFIG()
{
MULT_TYP param;

	param = GetParam(0, PTR);
	genDEF_PHFIG(param.ptr);
	/* genDEF_PHFIG reinitializes the TERM signal handler.
      I must trap it my way, so I've got to call it again. */
	unix_trap();
	init_fig();
}

app_DEF_PHINS()
{
MULT_TYP param;

	param = GetParam(0, PTR);
	genDEF_PHINS(param.ptr);
	new_insref();
}

app_DEF_AB()
{
MULT_TYP param;
long dx1, dy1, dx2, dy2;

	param = GetParam(0, INT);
	dx1 = param.ent;
	param = GetParam(4, INT);
	dy1 = param.ent;
	param = GetParam(8, INT);
	dx2 = param.ent;
	param = GetParam(12, INT);
	dy2 = param.ent;

	genDEF_AB(dx1, dy1, dx2, dy2);

	update_AB();
}

app_PLACE()
{
MULT_TYP param;
char *figname, *insname;
long x, y;
char sym;

	param = GetParam(0, PTR);
	figname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	sym = (char)param.ent;
	param = GetParam(12, INT);
	x = param.ent;
	param = GetParam(16, INT);
	y = param.ent;

	genPLACE(figname, insname, sym, x, y);

	fill_descr(WORK_PHINS, INS);
}

app_PLACE_RIGHT()
{
MULT_TYP param;
char *figname, *insname;
char sym;

	param = GetParam(0, PTR);
	figname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	sym = (char)param.ent;

	genPLACE_RIGHT(figname, insname, sym);

	fill_descr(WORK_PHINS, INS);
}

app_PLACE_LEFT()
{
MULT_TYP param;
char *figname, *insname;
char sym;

	param = GetParam(0, PTR);
	figname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	sym = (char)param.ent;

	genPLACE_LEFT(figname, insname, sym);

	fill_descr(WORK_PHINS, INS);
}

app_PLACE_TOP()
{
MULT_TYP param;
char *figname, *insname;
char sym;

	param = GetParam(0, PTR);
	figname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	sym = (char)param.ent;

	genPLACE_TOP(figname, insname, sym);

	fill_descr(WORK_PHINS, INS);
}

app_PLACE_BOTTOM()
{
MULT_TYP param;
char *figname, *insname;
char sym;

	param = GetParam(0, PTR);
	figname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	sym = (char)param.ent;

	genPLACE_BOTTOM(figname, insname, sym);

	fill_descr(WORK_PHINS, INS);
}

app_PLACE_REF()
{
MULT_TYP param;
char *figname, *insname;
char sym;
char *insref, *refname;

	param = GetParam(0, PTR);
	figname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	sym = (char)param.ent;
	param = GetParam(12, PTR);
	insref = param.ptr;
	param = GetParam(16, PTR);
	refname = param.ptr;

	genPLACE_REF(figname, insname, sym, insref, refname);

	fill_descr(WORK_PHINS, INS);
}

app_PLACE_ON()
{
MULT_TYP param;
char *figname, *t1, *t2, *c1, *c2;
long i1, i2;
char sym;

	param = GetParam(0, PTR);
	figname = param.ptr;
	param = GetParam(4, PTR);
	t1 = param.ptr;
	param = GetParam(8, PTR);
	c1 = param.ptr;
	param = GetParam(12, INT);
	i1 = param.ent;
	param = GetParam(16, INT);
	sym = (char)param.ent;
	param = GetParam(20, PTR);
	t2 = param.ptr;
	param = GetParam(24, PTR);
	c2 = param.ptr;
	param = GetParam(28, INT);
	i2 = param.ent;

	genPLACE_ON(figname, t1, c1, i1, sym, t2, c2, i2);

	fill_descr((char *)WORK_PHINS, INS);
}

app_PHCON()
{
MULT_TYP param;
char orient, *name;
long x, y, width;
char layer;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, PTR);
	name = param.ptr;
	param = GetParam(12, INT);
	orient = (char)param.ent;
	param = GetParam(16, INT);
	x = param.ent;
	param = GetParam(20, INT);
	y = param.ent;

	fill_descr((char *)genPHCON(layer, width, name, orient, x, y), FIGCON);
}

app_PHSEG()
{
MULT_TYP param;
char layer;
long width, x1, y1, x2, y2;
char *name;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, PTR);
	name = param.ptr;
	param = GetParam(12, INT);
	x1 = param.ent;
	param = GetParam(16, INT);
	y1 = param.ent;
	param = GetParam(20, INT);
	x2 = param.ent;
	param = GetParam(24, INT);
	y2 = param.ent;

	fill_descr((char *)genPHSEG(layer, width, name, x1, y1, x2, y2), SEG);
}


app_PHREF()
{
MULT_TYP param;
char *type, *name;
long x, y;

	param = GetParam(0, PTR);
	type = param.ptr;
	param = GetParam(4, PTR);
	name = param.ptr;
	param = GetParam(8, INT);
	x = param.ent;
	param = GetParam(12, INT);
	y = param.ent;

	fill_descr((char *)genPHREF(type, name, x, y), REF);
}

app_PHVIA()
{
MULT_TYP param;
char type;
long x, y;

	param = GetParam(0, INT);
	type = (char)param.ent;
	param = GetParam(4, INT);
	x = param.ent;
	param = GetParam(8, INT);
	y = param.ent;

	fill_descr((char *)genPHVIA(type, x, y), VIA);
}

app_PLACE_CON_REF()
{
MULT_TYP param;
char *insname, *refname, *conname;
char layer, face;
long width;
chain_list *c;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, PTR);
	refname = param.ptr;
	param = GetParam(8, PTR);
	conname = param.ptr;
	param = GetParam(12, INT);
	layer = (char)param.ent;
	param = GetParam(16, INT);
	width = param.ent;
	param = GetParam(20, INT);
	face = (char)param.ent;

	c = genPLACE_CON_REF(insname, refname, conname, layer, width, face);
	fill_descr((char *)c->DATA, FIGCON);
	if (c->NEXT)
		fill_descr((char *)c->NEXT->DATA, SEG);
	freechain(c);
}

app_PLACE_SEG_REF()
{
MULT_TYP param;
char *insname, *refname;
char layer, face;
long width;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, PTR);
	refname = param.ptr;
	param = GetParam(8, INT);
	layer = (char)param.ent;
	param = GetParam(12, INT);
	width = param.ent;
	param = GetParam(16, INT);
	face = (char)param.ent;

	fill_descr((char *)genPLACE_SEG_REF(insname, refname, layer, width, face),
					SEG);
}

app_PLACE_VIA_REF()
{
MULT_TYP param;
char *insname, *refname;
char type;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, PTR);
	refname = param.ptr;
	param = GetParam(8, INT);
	type = (char)param.ent;

	fill_descr((char *)genPLACE_VIA_REF(insname, refname, type), VIA);
}

app_COPY_UP_SEG()
{
MULT_TYP param;
char *locname;
char *insname;
char *newname;

	param = GetParam(0, PTR);
	locname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, PTR);
	newname = param.ptr;

	fill_descr((char *)genCOPY_UP_SEG(locname, insname, newname), SEG);
}

app_COPY_UP_REF()
{
MULT_TYP param;
char *refname;
char *insname;
char *newname;

	param = GetParam(0, PTR);
	refname = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, PTR);
	newname = param.ptr;

	
	fill_descr((char *)genCOPY_UP_REF(refname, insname, newname), REF);
}

app_COPY_UP_CON_FACE()
{
MULT_TYP param;
char orient;
char *insname;
char *locname;
char *newname;
chain_list *ptchain;
chain_list *ptscan;

	param = GetParam(0, INT);
	orient = (char)param.ent;
	param = GetParam(4, PTR);
	locname = param.ptr;
	param = GetParam(8, PTR);
	insname = param.ptr;
	param = GetParam(12, PTR);
	newname = param.ptr;

	/* retrieving copy_up_con results */
	ptchain = genCOPY_UP_CON_FACE(orient, locname, insname, newname);

	/* let's get the copied connectors */
	for(ptscan = (chain_list *)ptchain->DATA; 
			ptscan != NULL; ptscan = ptscan->NEXT)
		fill_descr((char *)ptscan->DATA, FIGCON);

	/* let's get the copied segments linked to connectors */
	for(ptscan = (chain_list *)ptchain->NEXT->DATA; 
			ptscan != NULL; ptscan = ptscan->NEXT)
		fill_descr((char *)ptscan->DATA, SEG);
}

app_COPY_UP_CON()
{
MULT_TYP param;
long  index;
char *insname;
char *locname;
char *newname;
chain_list *ptchain;

	param = GetParam(0, INT);
	index = (long)param.ent;
	param = GetParam(4, PTR);
	locname = param.ptr;
	param = GetParam(8, PTR);
	insname = param.ptr;
	param = GetParam(12, PTR);
	newname = param.ptr;

	/* retrieving COPY_UP_CON results */
	ptchain = genCOPY_UP_CON(index, locname, insname, newname);

	/* let's get the copied connector */
	fill_descr((char *)ptchain->DATA, FIGCON);

	/* let's get the copied segments linked to connectors */
	if((phseg_list *)(ptchain->NEXT)->DATA != NULL)
		fill_descr((phseg_list *)(chain_list *)(ptchain->NEXT)->DATA, SEG);
	freechain(ptchain);
}

app_THRU_CON_H()
{
MULT_TYP param;
chain_list *ptchain;
char layer;
char *name;
long width, y;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, PTR);
	name = param.ptr;
	param = GetParam(12, INT);
	y = param.ent;

	ptchain	= genTHRU_CON_H(layer, width, name, y);
	fill_descr((phseg_list *)ptchain->DATA, SEG);
	fill_descr((phcon_list *)(ptchain->NEXT)->DATA, FIGCON);
	fill_descr((phcon_list *)(ptchain->NEXT->NEXT)->DATA, FIGCON);
	freechain(ptchain);
}

app_THRU_CON_V()
{
MULT_TYP param;
chain_list *ptchain;
char layer;
char *name;
long width, x;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, PTR);
	name = param.ptr;
	param = GetParam(12, INT);
	x = param.ent;

	ptchain	= genTHRU_CON_V(layer, width, name, x);
	fill_descr((char *)ptchain->DATA, SEG);
	fill_descr((char *)(ptchain->NEXT)->DATA, FIGCON);
	fill_descr((char *)(ptchain->NEXT->NEXT)->DATA, FIGCON);
	freechain(ptchain);
}

app_THRU_H()
{
MULT_TYP param;
char layer;
long width, y;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, INT);
	y = param.ent;

	fill_descr((char *)genTHRU_H(layer, width, y), SEG);
}

app_THRU_V()
{
MULT_TYP param;
char layer;
long width, x;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, INT);
	x = param.ent;

	fill_descr((char *)genTHRU_V(layer, width, x), SEG);
}

app_GET_CON_X()
{
MULT_TYP param;
char *insname;
char *refname;
char face;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, PTR);
	refname = param.ptr;
	param = GetParam(8, INT);
	face = (char)param.ent;

	I_reg[25] = (int)genGET_CON_X(insname, refname, face);
}

app_GET_CON_Y()
{
MULT_TYP param;
char *insname;
char *refname;
char face;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, PTR);
	refname = param.ptr;
	param = GetParam(8, INT);
	face = (char)param.ent;

	I_reg[25] = (int)genGET_CON_Y(insname, refname, face);
}

app_GET_INS_X()
{
MULT_TYP param;
char *insname;

	param = GetParam(0, PTR);
	insname = param.ptr;

	I_reg[25] = (int)genGET_INS_X(insname);
}

app_GET_INS_Y()
{
MULT_TYP param;
char *insname;

	param = GetParam(0, PTR);
	insname = param.ptr;

	I_reg[25] = (int)genGET_INS_Y(insname);
}

app_GET_REF_X()
{
MULT_TYP param;
char *insname;
char *refname;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, PTR);
	refname = param.ptr;

	I_reg[25] = (int)genGET_REF_X(insname, refname);
}

app_GET_REF_Y()
{
MULT_TYP param;
char *insname;
char *refname;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, PTR);
	refname = param.ptr;

	I_reg[25] = (int)genGET_REF_Y(insname, refname);
}

app_WIDTH()
{
MULT_TYP param;
char *figname;

	param = GetParam(0, PTR);
	figname = param.ptr;

	I_reg[25] = (int)genWIDTH(figname);
}

app_HEIGHT()
{
MULT_TYP param;
char *figname;

	param = GetParam(0, PTR);
	figname = param.ptr;

	I_reg[25] = (int)genHEIGHT(figname);
}

app_WIRE1()
{
MULT_TYP param;
chain_list *ptchain;
char layer;
long width;
char *ins1, *ins2, *con1, *con2;
char face1, face2;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, PTR);
	ins1 = param.ptr;
	param = GetParam(12, PTR);
	con1 = param.ptr;
	param = GetParam(16, INT);
	face1 = (char)param.ent;
	param = GetParam(20, PTR);
	ins2 = param.ptr;
	param = GetParam(24, PTR);
	con2 = param.ptr;
	param = GetParam(28, INT);
	face2 = (char)param.ent;

	ptchain = genWIRE1(layer, width, ins1, con1, face1, ins2, con2, face2);
	fill_descr((phseg_list *)ptchain->DATA, SEG);
	freechain(ptchain);
}

app_WIRE2()
{
MULT_TYP param;
chain_list *ptchain;
char layer;
long width;
char *ins1, *ins2, *con1, *con2;
char face1, face2;
long x, y;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, PTR);
	ins1 = param.ptr;
	param = GetParam(12, PTR);
	con1 = param.ptr;
	param = GetParam(16, INT);
	face1 = (char)param.ent;
	param = GetParam(20, PTR);
	ins2 = param.ptr;
	param = GetParam(24, PTR);
	con2 = param.ptr;
	param = GetParam(28, INT);
	face2 = (char)param.ent;
	param = GetParam(32, INT);
	x = param.ent;
	param = GetParam(36, INT);
	y = param.ent;

	ptchain =
			genWIRE2(layer, width, ins1, con1, face1, ins2, con2, face2, x, y);
	fill_descr((phseg_list *)ptchain->DATA, SEG);
	fill_descr((phseg_list *)((chain_list *)(ptchain->NEXT)->DATA), SEG);
	freechain(ptchain);
}

app_WIRE3()
{
MULT_TYP param;
chain_list *ptchain;
char layer;
long width;
char *ins1, *ins2, *con1, *con2;
char face1, face2;
long x1, y1, x2, y2;

	param = GetParam(0, INT);
	layer = (char)param.ent;
	param = GetParam(4, INT);
	width = param.ent;
	param = GetParam(8, PTR);
	ins1 = param.ptr;
	param = GetParam(12, PTR);
	con1 = param.ptr;
	param = GetParam(16, INT);
	face1 = (char)param.ent;
	param = GetParam(20, PTR);
	ins2 = param.ptr;
	param = GetParam(24, PTR);
	con2 = param.ptr;
	param = GetParam(28, INT);
	face2 = (char)param.ent;
	param = GetParam(32, INT);
	x1 = param.ent;
	param = GetParam(36, INT);
	y1 = param.ent;
	param = GetParam(40, INT);
	x2 = param.ent;
	param = GetParam(44, INT);
	y2 = param.ent;

	ptchain	= genWIRE3(layer, width, ins1, con1, face1, ins2, con2, face2,
								 x1, y1, x2, y2);
	fill_descr((phseg_list *)ptchain->DATA, SEG);
	fill_descr((phseg_list *)(ptchain->NEXT)->DATA, SEG);
	fill_descr((phseg_list *)(ptchain->NEXT->NEXT)->DATA, SEG);
	freechain(ptchain);
}

app_COPY_UP_ALL_CON()
{
MULT_TYP param;
char orient;
char *insname;
char cheminom;
chain_list *pc;
chain_list *ps;

	param = GetParam(0, INT);
	orient = (char)param.ent;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	cheminom = (char)param.ent;

	/* retrieving copy_up_all_con results */
	pc = genCOPY_UP_ALL_CON(orient, insname, cheminom);

	/* let's get the copied connectors */
	for (ps = (chain_list *)pc->DATA; ps != NULL; ps = ps->NEXT)
		fill_descr((phcon_list *)ps->DATA, FIGCON);
	/* let's get the copied segments linked to connectors */
	for (ps = (chain_list *)pc->NEXT->DATA; ps != NULL; ps = ps->NEXT)
		fill_descr((phseg_list *)ps->DATA, SEG);
}

app_COPY_UP_ALL_REF()
{
MULT_TYP param;
char *type, *insname;
char cheminom;
chain_list *pc;

	param = GetParam(0, PTR);
	type = param.ptr;
	param = GetParam(4, PTR);
	insname = param.ptr;
	param = GetParam(8, INT);
	cheminom = (char)param.ent;

	/* retrieving copy_up_all_ref results */
	pc = genCOPY_UP_ALL_REF(type, insname, cheminom);

	/* let's get the copied refrences */
	for (; pc != NULL; pc = pc->NEXT)
		fill_descr((phref_list *)pc->DATA, REF);
}

app_FLATTEN_PHFIG()
{
MULT_TYP param;
char *insname;
char cheminom;

	param = GetParam(0, PTR);
	insname = param.ptr;
	param = GetParam(4, INT);
	cheminom = (char)param.ent;

	genFLATTEN_PHFIG(insname, cheminom);

	ram_load();
}

app_FLATTEN_ALL_PHINS()
{
char concat, catal;

	concat = (char)GetParam(0, INT).ent;
	catal = (char)GetParam(4, INT).ent;

	genFLATTEN_ALL_PHINS(concat, catal);

	ram_load();
}
