/***************************************************************************
*	MBK : global variables 				 		   *
*									   *
*	Version : 1.0							   *
*	   Date	: 11/06/90						   *
***************************************************************************/

phfig_list *xvisufig = NULL;	/* pointer on the mother figure */
LAMBDA xabfig, yabfig;	/* Mother fig. abutment box coordinates */

/* Name and extension in half lambda of all layer used in the database */
struct layer tablayer[] = {
	NWELL, "nwell", 0,
	PWELL, "pwell", 0,
	NTIE, "ntie", 1,
	PTIE, "ptie", 1,
	NDIF, "ndif", 1,
	PDIF, "pdif", 1,
	G_GATE, "gate", 0,
	POLY, "poly", 1,
	TPOLY, "allowpoly", 1,
	ALU1, "metal1", 1,
	TALU1, "allowm1", 1,
	G_CONT_POLY, "cpoly", 0,
	G_CONT_DIFN, "cdifn", 0,
	G_CONT_DIFP, "cdifp", 0,
	G_CONT_BODY_N, "cbodyn", 0,
	G_CONT_BODY_P, "cbodyp", 0,
	ALU2, "metal2", 2,
	TALU2, "allowm2", 2,
	G_CONT_VIA, "cvia", 0,
	ALU3, "metal3", 2,
	TALU3, "allowm3", 2,
	G_CONT_VIA2, "cvia2", 0,
	G_REF, "reference", 0,
	G_INS, "INS", 0,
	G_DEF, "DEFAULT", 0
};

int sizecon[] = {
	0, /* NWELL   */
	0, /* PWELL   */
	0, /* NTIE    */
	0, /* PTIE    */
	0, /* NDIF    */
	0, /* PDIF    */
	0, /* NTRANS  */
	0, /* PTRANS  */
	1, /* POLY    */
	1, /* ALU1    */
	2, /* ALU2    */
	3, /* ALU3    */
	1, /* TPOLY   */
	1, /* TALU1   */
	2, /* TALU2   */
	3  /* TALU3   */
};

/* Name of all contact types used in the database */
char *tabcont[] = {
	"CONT_POLY",
	"CONT_VIA",
	"CONT_DIF_N",
	"CONT_DIF_P",
	"CONT_BODY_N",
	"CONT_BODY_P",
	"C_X_N",
	"C_X_P",
	"CONT_VIA2"
};

/* Name of all instance transformation */
char *tabtransf[] = {
	"NOSYM",
	"ROT_P",
	"SYMXY",
	"ROT_M",
	"SYM_X",
	"SY_RM",
	"SYM_Y",
	"SY_RP"
};


/* Bounding box coordinates */
LAMBDA xvisu = 0, yvisu = 0, dxvisu = 0, dyvisu = 0;
LAMBDA xscreen, yscreen, dxscreen, dyscreen;	/* Screen coordinates */

PIXEL dxWin, dyWin;	/* Screen dimensions in pixel */
float scale;	/* Scale factor of circuit */

X_RECT *ptinsref;	/* Pointer on the last instance created in the DB */

FILE *xinspect;	/* Output stream for inspect */

struct zoomBack zoomTrack;	/* Backup structure for loom_mouse */

X_RECTPEEK *peek_db[DEFAULT_LAYER + 1];	/* Peek database */
X_RECT *visu_db[DEFAULT_LAYER + 1];	/* Visualisation database */
X_STRING *head_strlist = NULL;	/* Pointer on the string list */

char run_mode = STEP;	/* Interpretor default execution mode */

long
nbins = 0, nbseg = 0, nbvia = 0, nbinscon = 0, nbfigcon = 0, nbref = 0, nbtrans = 0;	/* Number of descriptors in the database */
