/***************************************************************************
*Inspect management functions
*Version : 1.0
*Date		: 11/06/90
***************************************************************************/

#include <stdio.h>
#include MUT_H
#include MPH_H
#include "mbk_extern.h"
#include "g_visu.h"
#include "g_extern.c"
static void mbk_con_coord();

/***************************************************************************
*print_desc : prints descriptor informations*
***************************************************************************/
static void print_desc(ptdesc, type, code)
X_RECT *ptdesc;
unsigned char type, code;
{
int x, y, width;

	switch (type & MASK) {
		case SEG:
			fprintf(xinspect, "SEGMENT :\n");
			if (((phseg_list *) ptdesc->PTMBK)->TYPE == UP
					|| ((phseg_list *) ptdesc->PTMBK)->TYPE == DOWN) {
				fprintf(xinspect, "     X1 : %-6g Y1 : %-6g\n",
							(float)ptdesc->X / 2 + (float)tablayer[code].EXT / 2,
							(float)(ptdesc->Y - (float)ptdesc->DY / 2) / 2);
				fprintf(xinspect, "     X2 : %-6g Y2 : %-6g\n", 
							(float)ptdesc->X / 2 + (float)ptdesc->DX / 2 - 
										(float)tablayer[code].EXT / 2, 
							(float)(ptdesc->Y - (float)ptdesc->DY / 2) / 2);
				fprintf(xinspect, "     WIDTH : %-6g\n", (float)ptdesc->DY / 2);
			} else {
				fprintf(xinspect, "     X1 : %-6g Y1 : %-6g\n",
							(float)(ptdesc->X + (float)ptdesc->DX / 2) / 2, 
							(float)(ptdesc->Y - ptdesc->DY) / 2 + 
										(float)tablayer[code].EXT / 2);
				fprintf(xinspect, "     X2 : %-6g Y2 : %-6g\n",
							(float)(ptdesc->X + (float)ptdesc->DX / 2) / 2, 
							(float)ptdesc->Y / 2 - (float)tablayer[code].EXT / 2);
				fprintf(xinspect, "     WIDTH : %-6g\n", (float)ptdesc->DX / 2);
			}
			if (((phseg_list *)ptdesc->PTMBK)->NAME)
				fprintf(xinspect, "     NAME  : %s\n",
							((phseg_list *)ptdesc->PTMBK)->NAME);
			fprintf (xinspect, "     LAYER : %s\n\n", tablayer[code].LAYER_NAME);
			break;

		case VIA:
			fprintf(xinspect, "MOTIF :\n");
			fprintf(xinspect, "     X : %-6g Y : %-6g\n", 
						(float)(ptdesc->X + SIZEVIA / 2) / 2,
						(float)(ptdesc->Y - SIZEVIA / 2) / 2);
			fprintf(xinspect, "     TYPE : %s\n\n",
						tabcont[((phvia_list *)ptdesc->PTMBK)->TYPE]);
			break;

		case REF:
			fprintf(xinspect, "REFERENCE :\n");
			fprintf(xinspect, "     X : %-6g Y : %-6g\n", 
						(float)(ptdesc->X + SIZEVIA / 4) / 2,
						(float)(ptdesc->Y - SIZEVIA / 4) / 2);
			fprintf(xinspect, "     NAME  : %s\n",
						((phref_list *)ptdesc->PTMBK)->NAME);
			fprintf(xinspect, "     MODEL NAME  : %s\n",
						((phref_list *)ptdesc->PTMBK)->FIGNAME);
			break;

		case INS:
			fprintf(xinspect, "INSTANCE :\n");
			fprintf(xinspect, "     X : %-6g  Y : %-6g\n",
						(float)ptdesc->X / 2, (float) (ptdesc->Y - ptdesc->DY) / 2);
			fprintf(xinspect, "     dX : %-5g dY : %-5g\n",
						(float)ptdesc->DX / 2, (float) ptdesc->DY / 2);
			fprintf(xinspect, "     NAME  : %s\n",
						((phins_list *) ptdesc->PTMBK)->INSNAME);
			fprintf(xinspect, "     MODEL : %s\n",
						((phins_list *) ptdesc->PTMBK)->FIGNAME);
			fprintf(xinspect, "     TRANSFORMATION : %s\n\n",
						tabtransf[(type & 0x7F ) >> 3]);
			break;

		case INSCON:
			mbk_con_coord(ptdesc, ((phcon_list *)ptdesc->PTMBK)->ORIENT, 
								&x, &y, &width);
			fprintf(xinspect, "INSTANCE CONNECTOR :\n");
			fprintf(xinspect, "     X : %-6g Y : %-6g\n",
						(float) x / 2, (float) y / 2);
			fprintf(xinspect, "     WIDTH : %-6g\n", (float) width);
			fprintf(xinspect, "     NAME  : %-6s\n",
						((phcon_list *) ptdesc->PTMBK)->NAME);
			fprintf(xinspect, "     LAYER : %s\n", tablayer[code].LAYER_NAME);
			fprintf(xinspect, "     MOTHER INSTANCE : %s\n\n",
						((phins_list *) ((X_RECT *) ptdesc->USER)->PTMBK)->INSNAME);
			break;

		case FIGCON:
			mbk_con_coord(ptdesc, ((phcon_list *)ptdesc->PTMBK)->ORIENT, 
								&x, &y, &width);
			fprintf(xinspect, "FIGURE CONNECTOR :\n");
			fprintf(xinspect, "     X : %-6g Y : %-6g\n",
						(float) x / 2, (float) y / 2);
			fprintf(xinspect, "     WIDTH : %-6g\n", (float) width);
			fprintf(xinspect, "     NAME  : %s\n",
						((phcon_list *) ptdesc->PTMBK)->NAME);
			fprintf(xinspect, "     INDEX : %d\n",
						((phcon_list *) ptdesc->PTMBK)->INDEX);
			fprintf(xinspect, "     LAYER : %s\n\n", tablayer[code].LAYER_NAME);
			break;

#ifdef DEBUG
		default:
		fprintf (xinspect, "????? unknown object code");
#endif
	}
}

/* inspect : prints textual information about a subwindow */
void inspect (xwin, ywin, dxwin, dywin)
LAMBDA xwin, ywin, dxwin, dywin;
{
unsigned char flag;
LAMBDA x, y, dx, dy;
unsigned char i;
X_RECT *pt;

	/* Opens the file that receive information */
	if ((xinspect = fopen (".xinspect", "w")) == NULL)
	g_error ("inspect : unable to open file !", -1);

	for (i = 0; i <= DEFAULT_LAYER; i++) {
		pt = visu_db[i];
		while (pt) {
			x = pt->X;
			dx = pt->DX;
			dy = pt->DY;
			y = pt->Y - dy;
			if (appart_win(&flag, x, y, dx, dy, xwin, ywin, dxwin, dywin)) {
				/* even surround descriptors are printed */
				if (flag == APSURROUND)
				fprintf(xinspect, "SURROUND ");
				/* print info into the file */
				print_desc(pt, pt->TYPE, i);
			}
			pt = pt->NEXT;
		}
	}
	fclose(xinspect);
}

/* find original coordinates without refering to mbk */
static void mbk_con_coord(pt, face, x, y, width)
X_RECT *pt;
char face;
LAMBDA *x, *y, *width;
{
  switch (face) {
    case NORTH:
      *width = pt->DX / 2;
      *x = pt->X + *width;
      *y = pt->Y - SIZECON / 2;
      break;

    case SOUTH:
      *width = pt->DX / 2;
      *x = pt->X + *width;
      *y = pt->Y - SIZECON / 2;
      break;

    case WEST:
      *width = pt->DY / 2;
      *x = pt->X + SIZECON / 2;
      *y = pt->Y - *width;
      break;

    case EAST:
      *width = pt->DY / 2;
      *x = pt->X + SIZECON / 2;
      *y = pt->Y - *width;
      break;
	}
}
